# Contributing to Facebook Ads API SDK for PHP
We want to make contributing to this project as easy and transparent as
possible.

## Code of Conduct
The code of conduct is described in [`CODE_OF_CONDUCT.md`](CODE_OF_CONDUCT.md)

## Our Development Process
The Facebook Ads API SDK for PHP is currently developed in Facebook's internal
repositories and then exported out to GitHub by a Facebook team member. We invite
you to submit pull requests directly to GitHub and, after review, these can be
merged into the project.

## Pull Requests
We actively welcome your pull requests.

1. Fork the repo and create your branch from `main`.
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
4. Ensure the test suite passes.
5. Make sure your code lints.
6. If you haven't already, complete the Contributor License Agreement ("CLA").

## Contributor License Agreement ("CLA")
In order to accept your pull request, we need you to submit a CLA. You only need
to do this once to work on any of Facebook's open source projects.

Complete your CLA [here](https://code.facebook.com/cla)

## Issues
Since we want to handle bugs more efficiently, we encourage you report bug to
our dedicated bug reporting channel. If you encounter a bug with Business SDK
(PHP), please report the issue at
[our developer bug reporting channel](https://developers.facebook.com/support/bugs/).

Facebook has a [bounty program](https://www.facebook.com/whitehat/) for the safe
disclosure of security bugs. In those cases, please go through the process
outlined on that page

## Coding Style
Please follow [PHP Coding Standards](https://secure.phabricator.com/book/phabcontrib/article/php_coding_standards/)

## License
By contributing to Facebook Ads API SDK for PHP, you agree that your contributions
will be licensed under the LICENSE file in the root directory of this source tree.
