<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/googleads/v13/errors/criterion_error.proto

namespace Google\Ads\GoogleAds\V13\Errors\CriterionErrorEnum;

use UnexpectedValueException;

/**
 * Enum describing possible criterion errors.
 *
 * Protobuf type <code>google.ads.googleads.v13.errors.CriterionErrorEnum.CriterionError</code>
 */
class CriterionError
{
    /**
     * Enum unspecified.
     *
     * Generated from protobuf enum <code>UNSPECIFIED = 0;</code>
     */
    const UNSPECIFIED = 0;
    /**
     * The received error code is not known in this version.
     *
     * Generated from protobuf enum <code>UNKNOWN = 1;</code>
     */
    const UNKNOWN = 1;
    /**
     * Concrete type of criterion is required for CREATE and UPDATE operations.
     *
     * Generated from protobuf enum <code>CONCRETE_TYPE_REQUIRED = 2;</code>
     */
    const CONCRETE_TYPE_REQUIRED = 2;
    /**
     * The category requested for exclusion is invalid.
     *
     * Generated from protobuf enum <code>INVALID_EXCLUDED_CATEGORY = 3;</code>
     */
    const INVALID_EXCLUDED_CATEGORY = 3;
    /**
     * Invalid keyword criteria text.
     *
     * Generated from protobuf enum <code>INVALID_KEYWORD_TEXT = 4;</code>
     */
    const INVALID_KEYWORD_TEXT = 4;
    /**
     * Keyword text should be less than 80 chars.
     *
     * Generated from protobuf enum <code>KEYWORD_TEXT_TOO_LONG = 5;</code>
     */
    const KEYWORD_TEXT_TOO_LONG = 5;
    /**
     * Keyword text has too many words.
     *
     * Generated from protobuf enum <code>KEYWORD_HAS_TOO_MANY_WORDS = 6;</code>
     */
    const KEYWORD_HAS_TOO_MANY_WORDS = 6;
    /**
     * Keyword text has invalid characters or symbols.
     *
     * Generated from protobuf enum <code>KEYWORD_HAS_INVALID_CHARS = 7;</code>
     */
    const KEYWORD_HAS_INVALID_CHARS = 7;
    /**
     * Invalid placement URL.
     *
     * Generated from protobuf enum <code>INVALID_PLACEMENT_URL = 8;</code>
     */
    const INVALID_PLACEMENT_URL = 8;
    /**
     * Invalid user list criterion.
     *
     * Generated from protobuf enum <code>INVALID_USER_LIST = 9;</code>
     */
    const INVALID_USER_LIST = 9;
    /**
     * Invalid user interest criterion.
     *
     * Generated from protobuf enum <code>INVALID_USER_INTEREST = 10;</code>
     */
    const INVALID_USER_INTEREST = 10;
    /**
     * Placement URL has wrong format.
     *
     * Generated from protobuf enum <code>INVALID_FORMAT_FOR_PLACEMENT_URL = 11;</code>
     */
    const INVALID_FORMAT_FOR_PLACEMENT_URL = 11;
    /**
     * Placement URL is too long.
     *
     * Generated from protobuf enum <code>PLACEMENT_URL_IS_TOO_LONG = 12;</code>
     */
    const PLACEMENT_URL_IS_TOO_LONG = 12;
    /**
     * Indicates the URL contains an illegal character.
     *
     * Generated from protobuf enum <code>PLACEMENT_URL_HAS_ILLEGAL_CHAR = 13;</code>
     */
    const PLACEMENT_URL_HAS_ILLEGAL_CHAR = 13;
    /**
     * Indicates the URL contains multiple comma separated URLs.
     *
     * Generated from protobuf enum <code>PLACEMENT_URL_HAS_MULTIPLE_SITES_IN_LINE = 14;</code>
     */
    const PLACEMENT_URL_HAS_MULTIPLE_SITES_IN_LINE = 14;
    /**
     * Indicates the domain is blocked.
     *
     * Generated from protobuf enum <code>PLACEMENT_IS_NOT_AVAILABLE_FOR_TARGETING_OR_EXCLUSION = 15;</code>
     */
    const PLACEMENT_IS_NOT_AVAILABLE_FOR_TARGETING_OR_EXCLUSION = 15;
    /**
     * Invalid topic path.
     *
     * Generated from protobuf enum <code>INVALID_TOPIC_PATH = 16;</code>
     */
    const INVALID_TOPIC_PATH = 16;
    /**
     * The YouTube Channel Id is invalid.
     *
     * Generated from protobuf enum <code>INVALID_YOUTUBE_CHANNEL_ID = 17;</code>
     */
    const INVALID_YOUTUBE_CHANNEL_ID = 17;
    /**
     * The YouTube Video Id is invalid.
     *
     * Generated from protobuf enum <code>INVALID_YOUTUBE_VIDEO_ID = 18;</code>
     */
    const INVALID_YOUTUBE_VIDEO_ID = 18;
    /**
     * Indicates the placement is a YouTube vertical channel, which is no longer
     * supported.
     *
     * Generated from protobuf enum <code>YOUTUBE_VERTICAL_CHANNEL_DEPRECATED = 19;</code>
     */
    const YOUTUBE_VERTICAL_CHANNEL_DEPRECATED = 19;
    /**
     * Indicates the placement is a YouTube demographic channel, which is no
     * longer supported.
     *
     * Generated from protobuf enum <code>YOUTUBE_DEMOGRAPHIC_CHANNEL_DEPRECATED = 20;</code>
     */
    const YOUTUBE_DEMOGRAPHIC_CHANNEL_DEPRECATED = 20;
    /**
     * YouTube urls are not supported in Placement criterion. Use YouTubeChannel
     * and YouTubeVideo criterion instead.
     *
     * Generated from protobuf enum <code>YOUTUBE_URL_UNSUPPORTED = 21;</code>
     */
    const YOUTUBE_URL_UNSUPPORTED = 21;
    /**
     * Criteria type can not be excluded by the customer, like AOL account type
     * cannot target site type criteria.
     *
     * Generated from protobuf enum <code>CANNOT_EXCLUDE_CRITERIA_TYPE = 22;</code>
     */
    const CANNOT_EXCLUDE_CRITERIA_TYPE = 22;
    /**
     * Criteria type can not be targeted.
     *
     * Generated from protobuf enum <code>CANNOT_ADD_CRITERIA_TYPE = 23;</code>
     */
    const CANNOT_ADD_CRITERIA_TYPE = 23;
    /**
     * Not allowed to exclude similar user list.
     *
     * Generated from protobuf enum <code>CANNOT_EXCLUDE_SIMILAR_USER_LIST = 26;</code>
     */
    const CANNOT_EXCLUDE_SIMILAR_USER_LIST = 26;
    /**
     * Not allowed to target a closed user list.
     *
     * Generated from protobuf enum <code>CANNOT_ADD_CLOSED_USER_LIST = 27;</code>
     */
    const CANNOT_ADD_CLOSED_USER_LIST = 27;
    /**
     * Not allowed to add display only UserLists to search only campaigns.
     *
     * Generated from protobuf enum <code>CANNOT_ADD_DISPLAY_ONLY_LISTS_TO_SEARCH_ONLY_CAMPAIGNS = 28;</code>
     */
    const CANNOT_ADD_DISPLAY_ONLY_LISTS_TO_SEARCH_ONLY_CAMPAIGNS = 28;
    /**
     * Not allowed to add display only UserLists to search plus campaigns.
     *
     * Generated from protobuf enum <code>CANNOT_ADD_DISPLAY_ONLY_LISTS_TO_SEARCH_CAMPAIGNS = 29;</code>
     */
    const CANNOT_ADD_DISPLAY_ONLY_LISTS_TO_SEARCH_CAMPAIGNS = 29;
    /**
     * Not allowed to add display only UserLists to shopping campaigns.
     *
     * Generated from protobuf enum <code>CANNOT_ADD_DISPLAY_ONLY_LISTS_TO_SHOPPING_CAMPAIGNS = 30;</code>
     */
    const CANNOT_ADD_DISPLAY_ONLY_LISTS_TO_SHOPPING_CAMPAIGNS = 30;
    /**
     * Not allowed to add User interests to search only campaigns.
     *
     * Generated from protobuf enum <code>CANNOT_ADD_USER_INTERESTS_TO_SEARCH_CAMPAIGNS = 31;</code>
     */
    const CANNOT_ADD_USER_INTERESTS_TO_SEARCH_CAMPAIGNS = 31;
    /**
     * Not allowed to set bids for this criterion type in search campaigns
     *
     * Generated from protobuf enum <code>CANNOT_SET_BIDS_ON_CRITERION_TYPE_IN_SEARCH_CAMPAIGNS = 32;</code>
     */
    const CANNOT_SET_BIDS_ON_CRITERION_TYPE_IN_SEARCH_CAMPAIGNS = 32;
    /**
     * Final URLs, URL Templates and CustomParameters cannot be set for the
     * criterion types of Gender, AgeRange, UserList, Placement, MobileApp, and
     * MobileAppCategory in search campaigns and shopping campaigns.
     *
     * Generated from protobuf enum <code>CANNOT_ADD_URLS_TO_CRITERION_TYPE_FOR_CAMPAIGN_TYPE = 33;</code>
     */
    const CANNOT_ADD_URLS_TO_CRITERION_TYPE_FOR_CAMPAIGN_TYPE = 33;
    /**
     * Invalid combined audience criterion.
     *
     * Generated from protobuf enum <code>INVALID_COMBINED_AUDIENCE = 122;</code>
     */
    const INVALID_COMBINED_AUDIENCE = 122;
    /**
     * Invalid custom affinity criterion.
     *
     * Generated from protobuf enum <code>INVALID_CUSTOM_AFFINITY = 96;</code>
     */
    const INVALID_CUSTOM_AFFINITY = 96;
    /**
     * Invalid custom intent criterion.
     *
     * Generated from protobuf enum <code>INVALID_CUSTOM_INTENT = 97;</code>
     */
    const INVALID_CUSTOM_INTENT = 97;
    /**
     * Invalid custom audience criterion.
     *
     * Generated from protobuf enum <code>INVALID_CUSTOM_AUDIENCE = 121;</code>
     */
    const INVALID_CUSTOM_AUDIENCE = 121;
    /**
     * IP address is not valid.
     *
     * Generated from protobuf enum <code>INVALID_IP_ADDRESS = 34;</code>
     */
    const INVALID_IP_ADDRESS = 34;
    /**
     * IP format is not valid.
     *
     * Generated from protobuf enum <code>INVALID_IP_FORMAT = 35;</code>
     */
    const INVALID_IP_FORMAT = 35;
    /**
     * Mobile application is not valid.
     *
     * Generated from protobuf enum <code>INVALID_MOBILE_APP = 36;</code>
     */
    const INVALID_MOBILE_APP = 36;
    /**
     * Mobile application category is not valid.
     *
     * Generated from protobuf enum <code>INVALID_MOBILE_APP_CATEGORY = 37;</code>
     */
    const INVALID_MOBILE_APP_CATEGORY = 37;
    /**
     * The CriterionId does not exist or is of the incorrect type.
     *
     * Generated from protobuf enum <code>INVALID_CRITERION_ID = 38;</code>
     */
    const INVALID_CRITERION_ID = 38;
    /**
     * The Criterion is not allowed to be targeted.
     *
     * Generated from protobuf enum <code>CANNOT_TARGET_CRITERION = 39;</code>
     */
    const CANNOT_TARGET_CRITERION = 39;
    /**
     * The criterion is not allowed to be targeted as it is deprecated.
     *
     * Generated from protobuf enum <code>CANNOT_TARGET_OBSOLETE_CRITERION = 40;</code>
     */
    const CANNOT_TARGET_OBSOLETE_CRITERION = 40;
    /**
     * The CriterionId is not valid for the type.
     *
     * Generated from protobuf enum <code>CRITERION_ID_AND_TYPE_MISMATCH = 41;</code>
     */
    const CRITERION_ID_AND_TYPE_MISMATCH = 41;
    /**
     * Distance for the radius for the proximity criterion is invalid.
     *
     * Generated from protobuf enum <code>INVALID_PROXIMITY_RADIUS = 42;</code>
     */
    const INVALID_PROXIMITY_RADIUS = 42;
    /**
     * Units for the distance for the radius for the proximity criterion is
     * invalid.
     *
     * Generated from protobuf enum <code>INVALID_PROXIMITY_RADIUS_UNITS = 43;</code>
     */
    const INVALID_PROXIMITY_RADIUS_UNITS = 43;
    /**
     * Street address in the address is not valid.
     *
     * Generated from protobuf enum <code>INVALID_STREETADDRESS_LENGTH = 44;</code>
     */
    const INVALID_STREETADDRESS_LENGTH = 44;
    /**
     * City name in the address is not valid.
     *
     * Generated from protobuf enum <code>INVALID_CITYNAME_LENGTH = 45;</code>
     */
    const INVALID_CITYNAME_LENGTH = 45;
    /**
     * Region code in the address is not valid.
     *
     * Generated from protobuf enum <code>INVALID_REGIONCODE_LENGTH = 46;</code>
     */
    const INVALID_REGIONCODE_LENGTH = 46;
    /**
     * Region name in the address is not valid.
     *
     * Generated from protobuf enum <code>INVALID_REGIONNAME_LENGTH = 47;</code>
     */
    const INVALID_REGIONNAME_LENGTH = 47;
    /**
     * Postal code in the address is not valid.
     *
     * Generated from protobuf enum <code>INVALID_POSTALCODE_LENGTH = 48;</code>
     */
    const INVALID_POSTALCODE_LENGTH = 48;
    /**
     * Country code in the address is not valid.
     *
     * Generated from protobuf enum <code>INVALID_COUNTRY_CODE = 49;</code>
     */
    const INVALID_COUNTRY_CODE = 49;
    /**
     * Latitude for the GeoPoint is not valid.
     *
     * Generated from protobuf enum <code>INVALID_LATITUDE = 50;</code>
     */
    const INVALID_LATITUDE = 50;
    /**
     * Longitude for the GeoPoint is not valid.
     *
     * Generated from protobuf enum <code>INVALID_LONGITUDE = 51;</code>
     */
    const INVALID_LONGITUDE = 51;
    /**
     * The Proximity input is not valid. Both address and geoPoint cannot be
     * null.
     *
     * Generated from protobuf enum <code>PROXIMITY_GEOPOINT_AND_ADDRESS_BOTH_CANNOT_BE_NULL = 52;</code>
     */
    const PROXIMITY_GEOPOINT_AND_ADDRESS_BOTH_CANNOT_BE_NULL = 52;
    /**
     * The Proximity address cannot be geocoded to a valid lat/long.
     *
     * Generated from protobuf enum <code>INVALID_PROXIMITY_ADDRESS = 53;</code>
     */
    const INVALID_PROXIMITY_ADDRESS = 53;
    /**
     * User domain name is not valid.
     *
     * Generated from protobuf enum <code>INVALID_USER_DOMAIN_NAME = 54;</code>
     */
    const INVALID_USER_DOMAIN_NAME = 54;
    /**
     * Length of serialized criterion parameter exceeded size limit.
     *
     * Generated from protobuf enum <code>CRITERION_PARAMETER_TOO_LONG = 55;</code>
     */
    const CRITERION_PARAMETER_TOO_LONG = 55;
    /**
     * Time interval in the AdSchedule overlaps with another AdSchedule.
     *
     * Generated from protobuf enum <code>AD_SCHEDULE_TIME_INTERVALS_OVERLAP = 56;</code>
     */
    const AD_SCHEDULE_TIME_INTERVALS_OVERLAP = 56;
    /**
     * AdSchedule time interval cannot span multiple days.
     *
     * Generated from protobuf enum <code>AD_SCHEDULE_INTERVAL_CANNOT_SPAN_MULTIPLE_DAYS = 57;</code>
     */
    const AD_SCHEDULE_INTERVAL_CANNOT_SPAN_MULTIPLE_DAYS = 57;
    /**
     * AdSchedule time interval specified is invalid, endTime cannot be earlier
     * than startTime.
     *
     * Generated from protobuf enum <code>AD_SCHEDULE_INVALID_TIME_INTERVAL = 58;</code>
     */
    const AD_SCHEDULE_INVALID_TIME_INTERVAL = 58;
    /**
     * The number of AdSchedule entries in a day exceeds the limit.
     *
     * Generated from protobuf enum <code>AD_SCHEDULE_EXCEEDED_INTERVALS_PER_DAY_LIMIT = 59;</code>
     */
    const AD_SCHEDULE_EXCEEDED_INTERVALS_PER_DAY_LIMIT = 59;
    /**
     * CriteriaId does not match the interval of the AdSchedule specified.
     *
     * Generated from protobuf enum <code>AD_SCHEDULE_CRITERION_ID_MISMATCHING_FIELDS = 60;</code>
     */
    const AD_SCHEDULE_CRITERION_ID_MISMATCHING_FIELDS = 60;
    /**
     * Cannot set bid modifier for this criterion type.
     *
     * Generated from protobuf enum <code>CANNOT_BID_MODIFY_CRITERION_TYPE = 61;</code>
     */
    const CANNOT_BID_MODIFY_CRITERION_TYPE = 61;
    /**
     * Cannot bid modify criterion, since it is opted out of the campaign.
     *
     * Generated from protobuf enum <code>CANNOT_BID_MODIFY_CRITERION_CAMPAIGN_OPTED_OUT = 62;</code>
     */
    const CANNOT_BID_MODIFY_CRITERION_CAMPAIGN_OPTED_OUT = 62;
    /**
     * Cannot set bid modifier for a negative criterion.
     *
     * Generated from protobuf enum <code>CANNOT_BID_MODIFY_NEGATIVE_CRITERION = 63;</code>
     */
    const CANNOT_BID_MODIFY_NEGATIVE_CRITERION = 63;
    /**
     * Bid Modifier already exists. Use SET operation to update.
     *
     * Generated from protobuf enum <code>BID_MODIFIER_ALREADY_EXISTS = 64;</code>
     */
    const BID_MODIFIER_ALREADY_EXISTS = 64;
    /**
     * Feed Id is not allowed in these Location Groups.
     *
     * Generated from protobuf enum <code>FEED_ID_NOT_ALLOWED = 65;</code>
     */
    const FEED_ID_NOT_ALLOWED = 65;
    /**
     * The account may not use the requested criteria type. For example, some
     * accounts are restricted to keywords only.
     *
     * Generated from protobuf enum <code>ACCOUNT_INELIGIBLE_FOR_CRITERIA_TYPE = 66;</code>
     */
    const ACCOUNT_INELIGIBLE_FOR_CRITERIA_TYPE = 66;
    /**
     * The requested criteria type cannot be used with campaign or ad group
     * bidding strategy.
     *
     * Generated from protobuf enum <code>CRITERIA_TYPE_INVALID_FOR_BIDDING_STRATEGY = 67;</code>
     */
    const CRITERIA_TYPE_INVALID_FOR_BIDDING_STRATEGY = 67;
    /**
     * The Criterion is not allowed to be excluded.
     *
     * Generated from protobuf enum <code>CANNOT_EXCLUDE_CRITERION = 68;</code>
     */
    const CANNOT_EXCLUDE_CRITERION = 68;
    /**
     * The criterion is not allowed to be removed. For example, we cannot remove
     * any of the device criterion.
     *
     * Generated from protobuf enum <code>CANNOT_REMOVE_CRITERION = 69;</code>
     */
    const CANNOT_REMOVE_CRITERION = 69;
    /**
     * Bidding categories do not form a valid path in the Shopping bidding
     * category taxonomy.
     *
     * Generated from protobuf enum <code>INVALID_PRODUCT_BIDDING_CATEGORY = 76;</code>
     */
    const INVALID_PRODUCT_BIDDING_CATEGORY = 76;
    /**
     * ShoppingSetting must be added to the campaign before ProductScope
     * criteria can be added.
     *
     * Generated from protobuf enum <code>MISSING_SHOPPING_SETTING = 77;</code>
     */
    const MISSING_SHOPPING_SETTING = 77;
    /**
     * Matching function is invalid.
     *
     * Generated from protobuf enum <code>INVALID_MATCHING_FUNCTION = 78;</code>
     */
    const INVALID_MATCHING_FUNCTION = 78;
    /**
     * Filter parameters not allowed for location groups targeting.
     *
     * Generated from protobuf enum <code>LOCATION_FILTER_NOT_ALLOWED = 79;</code>
     */
    const LOCATION_FILTER_NOT_ALLOWED = 79;
    /**
     * Feed not found, or the feed is not an enabled location feed.
     *
     * Generated from protobuf enum <code>INVALID_FEED_FOR_LOCATION_FILTER = 98;</code>
     */
    const INVALID_FEED_FOR_LOCATION_FILTER = 98;
    /**
     * Given location filter parameter is invalid for location groups targeting.
     *
     * Generated from protobuf enum <code>LOCATION_FILTER_INVALID = 80;</code>
     */
    const LOCATION_FILTER_INVALID = 80;
    /**
     * Cannot set geo target constants and feed item sets at the same time.
     *
     * Generated from protobuf enum <code>CANNOT_SET_GEO_TARGET_CONSTANTS_WITH_FEED_ITEM_SETS = 123;</code>
     */
    const CANNOT_SET_GEO_TARGET_CONSTANTS_WITH_FEED_ITEM_SETS = 123;
    /**
     * Cannot set both assetset and feed at the same time.
     *
     * Generated from protobuf enum <code>CANNOT_SET_BOTH_ASSET_SET_AND_FEED = 140;</code>
     */
    const CANNOT_SET_BOTH_ASSET_SET_AND_FEED = 140;
    /**
     * Cannot set feed or feed item sets for Customer.
     *
     * Generated from protobuf enum <code>CANNOT_SET_FEED_OR_FEED_ITEM_SETS_FOR_CUSTOMER = 142;</code>
     */
    const CANNOT_SET_FEED_OR_FEED_ITEM_SETS_FOR_CUSTOMER = 142;
    /**
     * Cannot set AssetSet criteria for customer.
     *
     * Generated from protobuf enum <code>CANNOT_SET_ASSET_SET_FIELD_FOR_CUSTOMER = 150;</code>
     */
    const CANNOT_SET_ASSET_SET_FIELD_FOR_CUSTOMER = 150;
    /**
     * Cannot set geo target constants and asset sets at the same time.
     *
     * Generated from protobuf enum <code>CANNOT_SET_GEO_TARGET_CONSTANTS_WITH_ASSET_SETS = 143;</code>
     */
    const CANNOT_SET_GEO_TARGET_CONSTANTS_WITH_ASSET_SETS = 143;
    /**
     * Cannot set asset sets and feed item sets at the same time.
     *
     * Generated from protobuf enum <code>CANNOT_SET_ASSET_SETS_WITH_FEED_ITEM_SETS = 144;</code>
     */
    const CANNOT_SET_ASSET_SETS_WITH_FEED_ITEM_SETS = 144;
    /**
     * The location group asset set id is invalid
     *
     * Generated from protobuf enum <code>INVALID_LOCATION_GROUP_ASSET_SET = 141;</code>
     */
    const INVALID_LOCATION_GROUP_ASSET_SET = 141;
    /**
     * The location group radius is in the range but not at the valid increment.
     *
     * Generated from protobuf enum <code>INVALID_LOCATION_GROUP_RADIUS = 124;</code>
     */
    const INVALID_LOCATION_GROUP_RADIUS = 124;
    /**
     * The location group radius unit is invalid.
     *
     * Generated from protobuf enum <code>INVALID_LOCATION_GROUP_RADIUS_UNIT = 125;</code>
     */
    const INVALID_LOCATION_GROUP_RADIUS_UNIT = 125;
    /**
     * Criteria type cannot be associated with a campaign and its ad group(s)
     * simultaneously.
     *
     * Generated from protobuf enum <code>CANNOT_ATTACH_CRITERIA_AT_CAMPAIGN_AND_ADGROUP = 81;</code>
     */
    const CANNOT_ATTACH_CRITERIA_AT_CAMPAIGN_AND_ADGROUP = 81;
    /**
     * Range represented by hotel length of stay's min nights and max nights
     * overlaps with an existing criterion.
     *
     * Generated from protobuf enum <code>HOTEL_LENGTH_OF_STAY_OVERLAPS_WITH_EXISTING_CRITERION = 82;</code>
     */
    const HOTEL_LENGTH_OF_STAY_OVERLAPS_WITH_EXISTING_CRITERION = 82;
    /**
     * Range represented by hotel advance booking window's min days and max days
     * overlaps with an existing criterion.
     *
     * Generated from protobuf enum <code>HOTEL_ADVANCE_BOOKING_WINDOW_OVERLAPS_WITH_EXISTING_CRITERION = 83;</code>
     */
    const HOTEL_ADVANCE_BOOKING_WINDOW_OVERLAPS_WITH_EXISTING_CRITERION = 83;
    /**
     * The field is not allowed to be set when the negative field is set to
     * true, for example, we don't allow bids in negative ad group or campaign
     * criteria.
     *
     * Generated from protobuf enum <code>FIELD_INCOMPATIBLE_WITH_NEGATIVE_TARGETING = 84;</code>
     */
    const FIELD_INCOMPATIBLE_WITH_NEGATIVE_TARGETING = 84;
    /**
     * The combination of operand and operator in webpage condition is invalid.
     *
     * Generated from protobuf enum <code>INVALID_WEBPAGE_CONDITION = 85;</code>
     */
    const INVALID_WEBPAGE_CONDITION = 85;
    /**
     * The URL of webpage condition is invalid.
     *
     * Generated from protobuf enum <code>INVALID_WEBPAGE_CONDITION_URL = 86;</code>
     */
    const INVALID_WEBPAGE_CONDITION_URL = 86;
    /**
     * The URL of webpage condition cannot be empty or contain white space.
     *
     * Generated from protobuf enum <code>WEBPAGE_CONDITION_URL_CANNOT_BE_EMPTY = 87;</code>
     */
    const WEBPAGE_CONDITION_URL_CANNOT_BE_EMPTY = 87;
    /**
     * The URL of webpage condition contains an unsupported protocol.
     *
     * Generated from protobuf enum <code>WEBPAGE_CONDITION_URL_UNSUPPORTED_PROTOCOL = 88;</code>
     */
    const WEBPAGE_CONDITION_URL_UNSUPPORTED_PROTOCOL = 88;
    /**
     * The URL of webpage condition cannot be an IP address.
     *
     * Generated from protobuf enum <code>WEBPAGE_CONDITION_URL_CANNOT_BE_IP_ADDRESS = 89;</code>
     */
    const WEBPAGE_CONDITION_URL_CANNOT_BE_IP_ADDRESS = 89;
    /**
     * The domain of the URL is not consistent with the domain in campaign
     * setting.
     *
     * Generated from protobuf enum <code>WEBPAGE_CONDITION_URL_DOMAIN_NOT_CONSISTENT_WITH_CAMPAIGN_SETTING = 90;</code>
     */
    const WEBPAGE_CONDITION_URL_DOMAIN_NOT_CONSISTENT_WITH_CAMPAIGN_SETTING = 90;
    /**
     * The URL of webpage condition cannot be a public suffix itself.
     *
     * Generated from protobuf enum <code>WEBPAGE_CONDITION_URL_CANNOT_BE_PUBLIC_SUFFIX = 91;</code>
     */
    const WEBPAGE_CONDITION_URL_CANNOT_BE_PUBLIC_SUFFIX = 91;
    /**
     * The URL of webpage condition has an invalid public suffix.
     *
     * Generated from protobuf enum <code>WEBPAGE_CONDITION_URL_INVALID_PUBLIC_SUFFIX = 92;</code>
     */
    const WEBPAGE_CONDITION_URL_INVALID_PUBLIC_SUFFIX = 92;
    /**
     * Value track parameter is not supported in webpage condition URL.
     *
     * Generated from protobuf enum <code>WEBPAGE_CONDITION_URL_VALUE_TRACK_VALUE_NOT_SUPPORTED = 93;</code>
     */
    const WEBPAGE_CONDITION_URL_VALUE_TRACK_VALUE_NOT_SUPPORTED = 93;
    /**
     * Only one URL-EQUALS webpage condition is allowed in a webpage
     * criterion and it cannot be combined with other conditions.
     *
     * Generated from protobuf enum <code>WEBPAGE_CRITERION_URL_EQUALS_CAN_HAVE_ONLY_ONE_CONDITION = 94;</code>
     */
    const WEBPAGE_CRITERION_URL_EQUALS_CAN_HAVE_ONLY_ONE_CONDITION = 94;
    /**
     * A webpage criterion cannot be added to a non-DSA ad group.
     *
     * Generated from protobuf enum <code>WEBPAGE_CRITERION_NOT_SUPPORTED_ON_NON_DSA_AD_GROUP = 95;</code>
     */
    const WEBPAGE_CRITERION_NOT_SUPPORTED_ON_NON_DSA_AD_GROUP = 95;
    /**
     * Cannot add positive user list criteria in Smart Display campaigns.
     *
     * Generated from protobuf enum <code>CANNOT_TARGET_USER_LIST_FOR_SMART_DISPLAY_CAMPAIGNS = 99;</code>
     */
    const CANNOT_TARGET_USER_LIST_FOR_SMART_DISPLAY_CAMPAIGNS = 99;
    /**
     * Cannot add positive placement criterion types in search campaigns.
     *
     * Generated from protobuf enum <code>CANNOT_TARGET_PLACEMENTS_FOR_SEARCH_CAMPAIGNS = 126;</code>
     */
    const CANNOT_TARGET_PLACEMENTS_FOR_SEARCH_CAMPAIGNS = 126;
    /**
     * Listing scope contains too many dimension types.
     *
     * Generated from protobuf enum <code>LISTING_SCOPE_TOO_MANY_DIMENSION_TYPES = 100;</code>
     */
    const LISTING_SCOPE_TOO_MANY_DIMENSION_TYPES = 100;
    /**
     * Listing scope has too many IN operators.
     *
     * Generated from protobuf enum <code>LISTING_SCOPE_TOO_MANY_IN_OPERATORS = 101;</code>
     */
    const LISTING_SCOPE_TOO_MANY_IN_OPERATORS = 101;
    /**
     * Listing scope contains IN operator on an unsupported dimension type.
     *
     * Generated from protobuf enum <code>LISTING_SCOPE_IN_OPERATOR_NOT_SUPPORTED = 102;</code>
     */
    const LISTING_SCOPE_IN_OPERATOR_NOT_SUPPORTED = 102;
    /**
     * There are dimensions with duplicate dimension type.
     *
     * Generated from protobuf enum <code>DUPLICATE_LISTING_DIMENSION_TYPE = 103;</code>
     */
    const DUPLICATE_LISTING_DIMENSION_TYPE = 103;
    /**
     * There are dimensions with duplicate dimension value.
     *
     * Generated from protobuf enum <code>DUPLICATE_LISTING_DIMENSION_VALUE = 104;</code>
     */
    const DUPLICATE_LISTING_DIMENSION_VALUE = 104;
    /**
     * Listing group SUBDIVISION nodes cannot have bids.
     *
     * Generated from protobuf enum <code>CANNOT_SET_BIDS_ON_LISTING_GROUP_SUBDIVISION = 105;</code>
     */
    const CANNOT_SET_BIDS_ON_LISTING_GROUP_SUBDIVISION = 105;
    /**
     * Ad group is invalid due to the listing groups it contains.
     *
     * Generated from protobuf enum <code>INVALID_LISTING_GROUP_HIERARCHY = 106;</code>
     */
    const INVALID_LISTING_GROUP_HIERARCHY = 106;
    /**
     * Listing group unit cannot have children.
     *
     * Generated from protobuf enum <code>LISTING_GROUP_UNIT_CANNOT_HAVE_CHILDREN = 107;</code>
     */
    const LISTING_GROUP_UNIT_CANNOT_HAVE_CHILDREN = 107;
    /**
     * Subdivided listing groups must have an "others" case.
     *
     * Generated from protobuf enum <code>LISTING_GROUP_SUBDIVISION_REQUIRES_OTHERS_CASE = 108;</code>
     */
    const LISTING_GROUP_SUBDIVISION_REQUIRES_OTHERS_CASE = 108;
    /**
     * Dimension type of listing group must be the same as that of its siblings.
     *
     * Generated from protobuf enum <code>LISTING_GROUP_REQUIRES_SAME_DIMENSION_TYPE_AS_SIBLINGS = 109;</code>
     */
    const LISTING_GROUP_REQUIRES_SAME_DIMENSION_TYPE_AS_SIBLINGS = 109;
    /**
     * Listing group cannot be added to the ad group because it already exists.
     *
     * Generated from protobuf enum <code>LISTING_GROUP_ALREADY_EXISTS = 110;</code>
     */
    const LISTING_GROUP_ALREADY_EXISTS = 110;
    /**
     * Listing group referenced in the operation was not found in the ad group.
     *
     * Generated from protobuf enum <code>LISTING_GROUP_DOES_NOT_EXIST = 111;</code>
     */
    const LISTING_GROUP_DOES_NOT_EXIST = 111;
    /**
     * Recursive removal failed because listing group subdivision is being
     * created or modified in this request.
     *
     * Generated from protobuf enum <code>LISTING_GROUP_CANNOT_BE_REMOVED = 112;</code>
     */
    const LISTING_GROUP_CANNOT_BE_REMOVED = 112;
    /**
     * Listing group type is not allowed for specified ad group criterion type.
     *
     * Generated from protobuf enum <code>INVALID_LISTING_GROUP_TYPE = 113;</code>
     */
    const INVALID_LISTING_GROUP_TYPE = 113;
    /**
     * Listing group in an ADD operation specifies a non temporary criterion id.
     *
     * Generated from protobuf enum <code>LISTING_GROUP_ADD_MAY_ONLY_USE_TEMP_ID = 114;</code>
     */
    const LISTING_GROUP_ADD_MAY_ONLY_USE_TEMP_ID = 114;
    /**
     * The combined length of dimension values of the Listing scope criterion
     * is too long.
     *
     * Generated from protobuf enum <code>LISTING_SCOPE_TOO_LONG = 115;</code>
     */
    const LISTING_SCOPE_TOO_LONG = 115;
    /**
     * Listing scope contains too many dimensions.
     *
     * Generated from protobuf enum <code>LISTING_SCOPE_TOO_MANY_DIMENSIONS = 116;</code>
     */
    const LISTING_SCOPE_TOO_MANY_DIMENSIONS = 116;
    /**
     * The combined length of dimension values of the Listing group criterion is
     * too long.
     *
     * Generated from protobuf enum <code>LISTING_GROUP_TOO_LONG = 117;</code>
     */
    const LISTING_GROUP_TOO_LONG = 117;
    /**
     * Listing group tree is too deep.
     *
     * Generated from protobuf enum <code>LISTING_GROUP_TREE_TOO_DEEP = 118;</code>
     */
    const LISTING_GROUP_TREE_TOO_DEEP = 118;
    /**
     * Listing dimension is invalid (for example, dimension contains illegal
     * value, dimension type is represented with wrong class, etc). Listing
     * dimension value can not contain "==" or "&+".
     *
     * Generated from protobuf enum <code>INVALID_LISTING_DIMENSION = 119;</code>
     */
    const INVALID_LISTING_DIMENSION = 119;
    /**
     * Listing dimension type is either invalid for campaigns of this type or
     * cannot be used in the current context. BIDDING_CATEGORY_Lx and
     * PRODUCT_TYPE_Lx dimensions must be used in ascending order of their
     * levels: L1, L2, L3, L4, L5... The levels must be specified sequentially
     * and start from L1. Furthermore, an "others" Listing group cannot be
     * subdivided with a dimension of the same type but of a higher level
     * ("others" BIDDING_CATEGORY_L3 can be subdivided with BRAND but not with
     * BIDDING_CATEGORY_L4).
     *
     * Generated from protobuf enum <code>INVALID_LISTING_DIMENSION_TYPE = 120;</code>
     */
    const INVALID_LISTING_DIMENSION_TYPE = 120;
    /**
     * Customer is not on allowlist for composite audience in display campaigns.
     *
     * Generated from protobuf enum <code>ADVERTISER_NOT_ON_ALLOWLIST_FOR_COMBINED_AUDIENCE_ON_DISPLAY = 127;</code>
     */
    const ADVERTISER_NOT_ON_ALLOWLIST_FOR_COMBINED_AUDIENCE_ON_DISPLAY = 127;
    /**
     * Cannot target on a removed combined audience.
     *
     * Generated from protobuf enum <code>CANNOT_TARGET_REMOVED_COMBINED_AUDIENCE = 128;</code>
     */
    const CANNOT_TARGET_REMOVED_COMBINED_AUDIENCE = 128;
    /**
     * Combined audience ID is invalid.
     *
     * Generated from protobuf enum <code>INVALID_COMBINED_AUDIENCE_ID = 129;</code>
     */
    const INVALID_COMBINED_AUDIENCE_ID = 129;
    /**
     * Can not target removed combined audience.
     *
     * Generated from protobuf enum <code>CANNOT_TARGET_REMOVED_CUSTOM_AUDIENCE = 130;</code>
     */
    const CANNOT_TARGET_REMOVED_CUSTOM_AUDIENCE = 130;
    /**
     * Range represented by hotel check-in date's start date and end date
     * overlaps with an existing criterion.
     *
     * Generated from protobuf enum <code>HOTEL_CHECK_IN_DATE_RANGE_OVERLAPS_WITH_EXISTING_CRITERION = 131;</code>
     */
    const HOTEL_CHECK_IN_DATE_RANGE_OVERLAPS_WITH_EXISTING_CRITERION = 131;
    /**
     * Start date is earlier than earliest allowed value of yesterday UTC.
     *
     * Generated from protobuf enum <code>HOTEL_CHECK_IN_DATE_RANGE_START_DATE_TOO_EARLY = 132;</code>
     */
    const HOTEL_CHECK_IN_DATE_RANGE_START_DATE_TOO_EARLY = 132;
    /**
     * End date later is than latest allowed day of 330 days in the future UTC.
     *
     * Generated from protobuf enum <code>HOTEL_CHECK_IN_DATE_RANGE_END_DATE_TOO_LATE = 133;</code>
     */
    const HOTEL_CHECK_IN_DATE_RANGE_END_DATE_TOO_LATE = 133;
    /**
     * Start date is after end date.
     *
     * Generated from protobuf enum <code>HOTEL_CHECK_IN_DATE_RANGE_REVERSED = 134;</code>
     */
    const HOTEL_CHECK_IN_DATE_RANGE_REVERSED = 134;
    /**
     * Broad match modifier (BMM) keywords can no longer be created. See
     * https://ads-developers.googleblog.com/2021/06/broad-match-modifier-upcoming-changes.html.
     *
     * Generated from protobuf enum <code>BROAD_MATCH_MODIFIER_KEYWORD_NOT_ALLOWED = 135;</code>
     */
    const BROAD_MATCH_MODIFIER_KEYWORD_NOT_ALLOWED = 135;
    /**
     * Only one audience is allowed in an asset group.
     *
     * Generated from protobuf enum <code>ONE_AUDIENCE_ALLOWED_PER_ASSET_GROUP = 136;</code>
     */
    const ONE_AUDIENCE_ALLOWED_PER_ASSET_GROUP = 136;
    /**
     * Audience is not supported for the specified campaign type.
     *
     * Generated from protobuf enum <code>AUDIENCE_NOT_ELIGIBLE_FOR_CAMPAIGN_TYPE = 137;</code>
     */
    const AUDIENCE_NOT_ELIGIBLE_FOR_CAMPAIGN_TYPE = 137;
    /**
     * Audience is not allowed to attach when use_audience_grouped bit is set to
     * false.
     *
     * Generated from protobuf enum <code>AUDIENCE_NOT_ALLOWED_TO_ATTACH_WHEN_AUDIENCE_GROUPED_SET_TO_FALSE = 138;</code>
     */
    const AUDIENCE_NOT_ALLOWED_TO_ATTACH_WHEN_AUDIENCE_GROUPED_SET_TO_FALSE = 138;
    /**
     * Targeting is not allowed for Customer Match lists as per Customer Match
     * policy. See
     * https://support.google.com/google-ads/answer/6299717.
     *
     * Generated from protobuf enum <code>CANNOT_TARGET_CUSTOMER_MATCH_USER_LIST = 139;</code>
     */
    const CANNOT_TARGET_CUSTOMER_MATCH_USER_LIST = 139;

    private static $valueToName = [
        self::UNSPECIFIED => 'UNSPECIFIED',
        self::UNKNOWN => 'UNKNOWN',
        self::CONCRETE_TYPE_REQUIRED => 'CONCRETE_TYPE_REQUIRED',
        self::INVALID_EXCLUDED_CATEGORY => 'INVALID_EXCLUDED_CATEGORY',
        self::INVALID_KEYWORD_TEXT => 'INVALID_KEYWORD_TEXT',
        self::KEYWORD_TEXT_TOO_LONG => 'KEYWORD_TEXT_TOO_LONG',
        self::KEYWORD_HAS_TOO_MANY_WORDS => 'KEYWORD_HAS_TOO_MANY_WORDS',
        self::KEYWORD_HAS_INVALID_CHARS => 'KEYWORD_HAS_INVALID_CHARS',
        self::INVALID_PLACEMENT_URL => 'INVALID_PLACEMENT_URL',
        self::INVALID_USER_LIST => 'INVALID_USER_LIST',
        self::INVALID_USER_INTEREST => 'INVALID_USER_INTEREST',
        self::INVALID_FORMAT_FOR_PLACEMENT_URL => 'INVALID_FORMAT_FOR_PLACEMENT_URL',
        self::PLACEMENT_URL_IS_TOO_LONG => 'PLACEMENT_URL_IS_TOO_LONG',
        self::PLACEMENT_URL_HAS_ILLEGAL_CHAR => 'PLACEMENT_URL_HAS_ILLEGAL_CHAR',
        self::PLACEMENT_URL_HAS_MULTIPLE_SITES_IN_LINE => 'PLACEMENT_URL_HAS_MULTIPLE_SITES_IN_LINE',
        self::PLACEMENT_IS_NOT_AVAILABLE_FOR_TARGETING_OR_EXCLUSION => 'PLACEMENT_IS_NOT_AVAILABLE_FOR_TARGETING_OR_EXCLUSION',
        self::INVALID_TOPIC_PATH => 'INVALID_TOPIC_PATH',
        self::INVALID_YOUTUBE_CHANNEL_ID => 'INVALID_YOUTUBE_CHANNEL_ID',
        self::INVALID_YOUTUBE_VIDEO_ID => 'INVALID_YOUTUBE_VIDEO_ID',
        self::YOUTUBE_VERTICAL_CHANNEL_DEPRECATED => 'YOUTUBE_VERTICAL_CHANNEL_DEPRECATED',
        self::YOUTUBE_DEMOGRAPHIC_CHANNEL_DEPRECATED => 'YOUTUBE_DEMOGRAPHIC_CHANNEL_DEPRECATED',
        self::YOUTUBE_URL_UNSUPPORTED => 'YOUTUBE_URL_UNSUPPORTED',
        self::CANNOT_EXCLUDE_CRITERIA_TYPE => 'CANNOT_EXCLUDE_CRITERIA_TYPE',
        self::CANNOT_ADD_CRITERIA_TYPE => 'CANNOT_ADD_CRITERIA_TYPE',
        self::CANNOT_EXCLUDE_SIMILAR_USER_LIST => 'CANNOT_EXCLUDE_SIMILAR_USER_LIST',
        self::CANNOT_ADD_CLOSED_USER_LIST => 'CANNOT_ADD_CLOSED_USER_LIST',
        self::CANNOT_ADD_DISPLAY_ONLY_LISTS_TO_SEARCH_ONLY_CAMPAIGNS => 'CANNOT_ADD_DISPLAY_ONLY_LISTS_TO_SEARCH_ONLY_CAMPAIGNS',
        self::CANNOT_ADD_DISPLAY_ONLY_LISTS_TO_SEARCH_CAMPAIGNS => 'CANNOT_ADD_DISPLAY_ONLY_LISTS_TO_SEARCH_CAMPAIGNS',
        self::CANNOT_ADD_DISPLAY_ONLY_LISTS_TO_SHOPPING_CAMPAIGNS => 'CANNOT_ADD_DISPLAY_ONLY_LISTS_TO_SHOPPING_CAMPAIGNS',
        self::CANNOT_ADD_USER_INTERESTS_TO_SEARCH_CAMPAIGNS => 'CANNOT_ADD_USER_INTERESTS_TO_SEARCH_CAMPAIGNS',
        self::CANNOT_SET_BIDS_ON_CRITERION_TYPE_IN_SEARCH_CAMPAIGNS => 'CANNOT_SET_BIDS_ON_CRITERION_TYPE_IN_SEARCH_CAMPAIGNS',
        self::CANNOT_ADD_URLS_TO_CRITERION_TYPE_FOR_CAMPAIGN_TYPE => 'CANNOT_ADD_URLS_TO_CRITERION_TYPE_FOR_CAMPAIGN_TYPE',
        self::INVALID_COMBINED_AUDIENCE => 'INVALID_COMBINED_AUDIENCE',
        self::INVALID_CUSTOM_AFFINITY => 'INVALID_CUSTOM_AFFINITY',
        self::INVALID_CUSTOM_INTENT => 'INVALID_CUSTOM_INTENT',
        self::INVALID_CUSTOM_AUDIENCE => 'INVALID_CUSTOM_AUDIENCE',
        self::INVALID_IP_ADDRESS => 'INVALID_IP_ADDRESS',
        self::INVALID_IP_FORMAT => 'INVALID_IP_FORMAT',
        self::INVALID_MOBILE_APP => 'INVALID_MOBILE_APP',
        self::INVALID_MOBILE_APP_CATEGORY => 'INVALID_MOBILE_APP_CATEGORY',
        self::INVALID_CRITERION_ID => 'INVALID_CRITERION_ID',
        self::CANNOT_TARGET_CRITERION => 'CANNOT_TARGET_CRITERION',
        self::CANNOT_TARGET_OBSOLETE_CRITERION => 'CANNOT_TARGET_OBSOLETE_CRITERION',
        self::CRITERION_ID_AND_TYPE_MISMATCH => 'CRITERION_ID_AND_TYPE_MISMATCH',
        self::INVALID_PROXIMITY_RADIUS => 'INVALID_PROXIMITY_RADIUS',
        self::INVALID_PROXIMITY_RADIUS_UNITS => 'INVALID_PROXIMITY_RADIUS_UNITS',
        self::INVALID_STREETADDRESS_LENGTH => 'INVALID_STREETADDRESS_LENGTH',
        self::INVALID_CITYNAME_LENGTH => 'INVALID_CITYNAME_LENGTH',
        self::INVALID_REGIONCODE_LENGTH => 'INVALID_REGIONCODE_LENGTH',
        self::INVALID_REGIONNAME_LENGTH => 'INVALID_REGIONNAME_LENGTH',
        self::INVALID_POSTALCODE_LENGTH => 'INVALID_POSTALCODE_LENGTH',
        self::INVALID_COUNTRY_CODE => 'INVALID_COUNTRY_CODE',
        self::INVALID_LATITUDE => 'INVALID_LATITUDE',
        self::INVALID_LONGITUDE => 'INVALID_LONGITUDE',
        self::PROXIMITY_GEOPOINT_AND_ADDRESS_BOTH_CANNOT_BE_NULL => 'PROXIMITY_GEOPOINT_AND_ADDRESS_BOTH_CANNOT_BE_NULL',
        self::INVALID_PROXIMITY_ADDRESS => 'INVALID_PROXIMITY_ADDRESS',
        self::INVALID_USER_DOMAIN_NAME => 'INVALID_USER_DOMAIN_NAME',
        self::CRITERION_PARAMETER_TOO_LONG => 'CRITERION_PARAMETER_TOO_LONG',
        self::AD_SCHEDULE_TIME_INTERVALS_OVERLAP => 'AD_SCHEDULE_TIME_INTERVALS_OVERLAP',
        self::AD_SCHEDULE_INTERVAL_CANNOT_SPAN_MULTIPLE_DAYS => 'AD_SCHEDULE_INTERVAL_CANNOT_SPAN_MULTIPLE_DAYS',
        self::AD_SCHEDULE_INVALID_TIME_INTERVAL => 'AD_SCHEDULE_INVALID_TIME_INTERVAL',
        self::AD_SCHEDULE_EXCEEDED_INTERVALS_PER_DAY_LIMIT => 'AD_SCHEDULE_EXCEEDED_INTERVALS_PER_DAY_LIMIT',
        self::AD_SCHEDULE_CRITERION_ID_MISMATCHING_FIELDS => 'AD_SCHEDULE_CRITERION_ID_MISMATCHING_FIELDS',
        self::CANNOT_BID_MODIFY_CRITERION_TYPE => 'CANNOT_BID_MODIFY_CRITERION_TYPE',
        self::CANNOT_BID_MODIFY_CRITERION_CAMPAIGN_OPTED_OUT => 'CANNOT_BID_MODIFY_CRITERION_CAMPAIGN_OPTED_OUT',
        self::CANNOT_BID_MODIFY_NEGATIVE_CRITERION => 'CANNOT_BID_MODIFY_NEGATIVE_CRITERION',
        self::BID_MODIFIER_ALREADY_EXISTS => 'BID_MODIFIER_ALREADY_EXISTS',
        self::FEED_ID_NOT_ALLOWED => 'FEED_ID_NOT_ALLOWED',
        self::ACCOUNT_INELIGIBLE_FOR_CRITERIA_TYPE => 'ACCOUNT_INELIGIBLE_FOR_CRITERIA_TYPE',
        self::CRITERIA_TYPE_INVALID_FOR_BIDDING_STRATEGY => 'CRITERIA_TYPE_INVALID_FOR_BIDDING_STRATEGY',
        self::CANNOT_EXCLUDE_CRITERION => 'CANNOT_EXCLUDE_CRITERION',
        self::CANNOT_REMOVE_CRITERION => 'CANNOT_REMOVE_CRITERION',
        self::INVALID_PRODUCT_BIDDING_CATEGORY => 'INVALID_PRODUCT_BIDDING_CATEGORY',
        self::MISSING_SHOPPING_SETTING => 'MISSING_SHOPPING_SETTING',
        self::INVALID_MATCHING_FUNCTION => 'INVALID_MATCHING_FUNCTION',
        self::LOCATION_FILTER_NOT_ALLOWED => 'LOCATION_FILTER_NOT_ALLOWED',
        self::INVALID_FEED_FOR_LOCATION_FILTER => 'INVALID_FEED_FOR_LOCATION_FILTER',
        self::LOCATION_FILTER_INVALID => 'LOCATION_FILTER_INVALID',
        self::CANNOT_SET_GEO_TARGET_CONSTANTS_WITH_FEED_ITEM_SETS => 'CANNOT_SET_GEO_TARGET_CONSTANTS_WITH_FEED_ITEM_SETS',
        self::CANNOT_SET_BOTH_ASSET_SET_AND_FEED => 'CANNOT_SET_BOTH_ASSET_SET_AND_FEED',
        self::CANNOT_SET_FEED_OR_FEED_ITEM_SETS_FOR_CUSTOMER => 'CANNOT_SET_FEED_OR_FEED_ITEM_SETS_FOR_CUSTOMER',
        self::CANNOT_SET_ASSET_SET_FIELD_FOR_CUSTOMER => 'CANNOT_SET_ASSET_SET_FIELD_FOR_CUSTOMER',
        self::CANNOT_SET_GEO_TARGET_CONSTANTS_WITH_ASSET_SETS => 'CANNOT_SET_GEO_TARGET_CONSTANTS_WITH_ASSET_SETS',
        self::CANNOT_SET_ASSET_SETS_WITH_FEED_ITEM_SETS => 'CANNOT_SET_ASSET_SETS_WITH_FEED_ITEM_SETS',
        self::INVALID_LOCATION_GROUP_ASSET_SET => 'INVALID_LOCATION_GROUP_ASSET_SET',
        self::INVALID_LOCATION_GROUP_RADIUS => 'INVALID_LOCATION_GROUP_RADIUS',
        self::INVALID_LOCATION_GROUP_RADIUS_UNIT => 'INVALID_LOCATION_GROUP_RADIUS_UNIT',
        self::CANNOT_ATTACH_CRITERIA_AT_CAMPAIGN_AND_ADGROUP => 'CANNOT_ATTACH_CRITERIA_AT_CAMPAIGN_AND_ADGROUP',
        self::HOTEL_LENGTH_OF_STAY_OVERLAPS_WITH_EXISTING_CRITERION => 'HOTEL_LENGTH_OF_STAY_OVERLAPS_WITH_EXISTING_CRITERION',
        self::HOTEL_ADVANCE_BOOKING_WINDOW_OVERLAPS_WITH_EXISTING_CRITERION => 'HOTEL_ADVANCE_BOOKING_WINDOW_OVERLAPS_WITH_EXISTING_CRITERION',
        self::FIELD_INCOMPATIBLE_WITH_NEGATIVE_TARGETING => 'FIELD_INCOMPATIBLE_WITH_NEGATIVE_TARGETING',
        self::INVALID_WEBPAGE_CONDITION => 'INVALID_WEBPAGE_CONDITION',
        self::INVALID_WEBPAGE_CONDITION_URL => 'INVALID_WEBPAGE_CONDITION_URL',
        self::WEBPAGE_CONDITION_URL_CANNOT_BE_EMPTY => 'WEBPAGE_CONDITION_URL_CANNOT_BE_EMPTY',
        self::WEBPAGE_CONDITION_URL_UNSUPPORTED_PROTOCOL => 'WEBPAGE_CONDITION_URL_UNSUPPORTED_PROTOCOL',
        self::WEBPAGE_CONDITION_URL_CANNOT_BE_IP_ADDRESS => 'WEBPAGE_CONDITION_URL_CANNOT_BE_IP_ADDRESS',
        self::WEBPAGE_CONDITION_URL_DOMAIN_NOT_CONSISTENT_WITH_CAMPAIGN_SETTING => 'WEBPAGE_CONDITION_URL_DOMAIN_NOT_CONSISTENT_WITH_CAMPAIGN_SETTING',
        self::WEBPAGE_CONDITION_URL_CANNOT_BE_PUBLIC_SUFFIX => 'WEBPAGE_CONDITION_URL_CANNOT_BE_PUBLIC_SUFFIX',
        self::WEBPAGE_CONDITION_URL_INVALID_PUBLIC_SUFFIX => 'WEBPAGE_CONDITION_URL_INVALID_PUBLIC_SUFFIX',
        self::WEBPAGE_CONDITION_URL_VALUE_TRACK_VALUE_NOT_SUPPORTED => 'WEBPAGE_CONDITION_URL_VALUE_TRACK_VALUE_NOT_SUPPORTED',
        self::WEBPAGE_CRITERION_URL_EQUALS_CAN_HAVE_ONLY_ONE_CONDITION => 'WEBPAGE_CRITERION_URL_EQUALS_CAN_HAVE_ONLY_ONE_CONDITION',
        self::WEBPAGE_CRITERION_NOT_SUPPORTED_ON_NON_DSA_AD_GROUP => 'WEBPAGE_CRITERION_NOT_SUPPORTED_ON_NON_DSA_AD_GROUP',
        self::CANNOT_TARGET_USER_LIST_FOR_SMART_DISPLAY_CAMPAIGNS => 'CANNOT_TARGET_USER_LIST_FOR_SMART_DISPLAY_CAMPAIGNS',
        self::CANNOT_TARGET_PLACEMENTS_FOR_SEARCH_CAMPAIGNS => 'CANNOT_TARGET_PLACEMENTS_FOR_SEARCH_CAMPAIGNS',
        self::LISTING_SCOPE_TOO_MANY_DIMENSION_TYPES => 'LISTING_SCOPE_TOO_MANY_DIMENSION_TYPES',
        self::LISTING_SCOPE_TOO_MANY_IN_OPERATORS => 'LISTING_SCOPE_TOO_MANY_IN_OPERATORS',
        self::LISTING_SCOPE_IN_OPERATOR_NOT_SUPPORTED => 'LISTING_SCOPE_IN_OPERATOR_NOT_SUPPORTED',
        self::DUPLICATE_LISTING_DIMENSION_TYPE => 'DUPLICATE_LISTING_DIMENSION_TYPE',
        self::DUPLICATE_LISTING_DIMENSION_VALUE => 'DUPLICATE_LISTING_DIMENSION_VALUE',
        self::CANNOT_SET_BIDS_ON_LISTING_GROUP_SUBDIVISION => 'CANNOT_SET_BIDS_ON_LISTING_GROUP_SUBDIVISION',
        self::INVALID_LISTING_GROUP_HIERARCHY => 'INVALID_LISTING_GROUP_HIERARCHY',
        self::LISTING_GROUP_UNIT_CANNOT_HAVE_CHILDREN => 'LISTING_GROUP_UNIT_CANNOT_HAVE_CHILDREN',
        self::LISTING_GROUP_SUBDIVISION_REQUIRES_OTHERS_CASE => 'LISTING_GROUP_SUBDIVISION_REQUIRES_OTHERS_CASE',
        self::LISTING_GROUP_REQUIRES_SAME_DIMENSION_TYPE_AS_SIBLINGS => 'LISTING_GROUP_REQUIRES_SAME_DIMENSION_TYPE_AS_SIBLINGS',
        self::LISTING_GROUP_ALREADY_EXISTS => 'LISTING_GROUP_ALREADY_EXISTS',
        self::LISTING_GROUP_DOES_NOT_EXIST => 'LISTING_GROUP_DOES_NOT_EXIST',
        self::LISTING_GROUP_CANNOT_BE_REMOVED => 'LISTING_GROUP_CANNOT_BE_REMOVED',
        self::INVALID_LISTING_GROUP_TYPE => 'INVALID_LISTING_GROUP_TYPE',
        self::LISTING_GROUP_ADD_MAY_ONLY_USE_TEMP_ID => 'LISTING_GROUP_ADD_MAY_ONLY_USE_TEMP_ID',
        self::LISTING_SCOPE_TOO_LONG => 'LISTING_SCOPE_TOO_LONG',
        self::LISTING_SCOPE_TOO_MANY_DIMENSIONS => 'LISTING_SCOPE_TOO_MANY_DIMENSIONS',
        self::LISTING_GROUP_TOO_LONG => 'LISTING_GROUP_TOO_LONG',
        self::LISTING_GROUP_TREE_TOO_DEEP => 'LISTING_GROUP_TREE_TOO_DEEP',
        self::INVALID_LISTING_DIMENSION => 'INVALID_LISTING_DIMENSION',
        self::INVALID_LISTING_DIMENSION_TYPE => 'INVALID_LISTING_DIMENSION_TYPE',
        self::ADVERTISER_NOT_ON_ALLOWLIST_FOR_COMBINED_AUDIENCE_ON_DISPLAY => 'ADVERTISER_NOT_ON_ALLOWLIST_FOR_COMBINED_AUDIENCE_ON_DISPLAY',
        self::CANNOT_TARGET_REMOVED_COMBINED_AUDIENCE => 'CANNOT_TARGET_REMOVED_COMBINED_AUDIENCE',
        self::INVALID_COMBINED_AUDIENCE_ID => 'INVALID_COMBINED_AUDIENCE_ID',
        self::CANNOT_TARGET_REMOVED_CUSTOM_AUDIENCE => 'CANNOT_TARGET_REMOVED_CUSTOM_AUDIENCE',
        self::HOTEL_CHECK_IN_DATE_RANGE_OVERLAPS_WITH_EXISTING_CRITERION => 'HOTEL_CHECK_IN_DATE_RANGE_OVERLAPS_WITH_EXISTING_CRITERION',
        self::HOTEL_CHECK_IN_DATE_RANGE_START_DATE_TOO_EARLY => 'HOTEL_CHECK_IN_DATE_RANGE_START_DATE_TOO_EARLY',
        self::HOTEL_CHECK_IN_DATE_RANGE_END_DATE_TOO_LATE => 'HOTEL_CHECK_IN_DATE_RANGE_END_DATE_TOO_LATE',
        self::HOTEL_CHECK_IN_DATE_RANGE_REVERSED => 'HOTEL_CHECK_IN_DATE_RANGE_REVERSED',
        self::BROAD_MATCH_MODIFIER_KEYWORD_NOT_ALLOWED => 'BROAD_MATCH_MODIFIER_KEYWORD_NOT_ALLOWED',
        self::ONE_AUDIENCE_ALLOWED_PER_ASSET_GROUP => 'ONE_AUDIENCE_ALLOWED_PER_ASSET_GROUP',
        self::AUDIENCE_NOT_ELIGIBLE_FOR_CAMPAIGN_TYPE => 'AUDIENCE_NOT_ELIGIBLE_FOR_CAMPAIGN_TYPE',
        self::AUDIENCE_NOT_ALLOWED_TO_ATTACH_WHEN_AUDIENCE_GROUPED_SET_TO_FALSE => 'AUDIENCE_NOT_ALLOWED_TO_ATTACH_WHEN_AUDIENCE_GROUPED_SET_TO_FALSE',
        self::CANNOT_TARGET_CUSTOMER_MATCH_USER_LIST => 'CANNOT_TARGET_CUSTOMER_MATCH_USER_LIST',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(CriterionError::class, \Google\Ads\GoogleAds\V13\Errors\CriterionErrorEnum_CriterionError::class);

