<?php
namespace BP3D\Addons;

if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

class ModelViewer extends \Elementor\Widget_Base {

	public function get_name() {
		return '3dModelViewer';
	}

	public function get_title() {
		return esc_html__( 'Model Viewer', 'model-viewer' );
	}

	public function get_icon() {
		return 'eicon-preview-medium';
	}

	public function get_categories() {
		return [ 'general' ];
	}

	public function get_keywords() {
		return [ '3d embed', '3d viewer', 'model viewer' ];
	}

	public function get_script_depends() {
		return ['bp3d-public'];
	}

	// /**
	//  * Style
	//  */
	public function get_style_depends() {
		return ['bp3d-public'];
	}

	protected function register_controls() {

		// Content Tab Start
		$this->start_controls_section(
			'embedder',
			[
				'label' => esc_html__( 'Model Viewer', 'model-viewer' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'multiple',
			[
				'label' => esc_html__( 'Use Multiple Model?', 'model-viewer' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => false,
			]
		);

		// single model input field start
		$this->add_control(
			'modelUrl',
			[
				'label' 		=> esc_html__( 'Select Model', 'model-viewer' ),
				'type' 			=> 'b-select-file',
				'separator' 	=> 'before',
				'placeholder' => esc_html__("Paste Model URL", 'model-viewer'),
				'condition' => array(
					'multiple!' => 'yes'
				)
			]
		);

		$this->add_control(
			'useDecoder',
			[
				'label' => esc_html__( 'Use Decoder', 'model-viewer' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'none',
				'options' => [
					'none'  => esc_html__( 'None', 'model-viewer' ),
					'draco'  => esc_html__( 'Draco', 'model-viewer' ),
				],
				'condition' => array(
					'multiple!' => 'yes'
				)
			]
		);

		$this->add_control(
			'bin_file',
			[
				'label' 		=> esc_html__( 'Upload bin file', 'model-viewer' ),
				'type' 			=> 'b-select-file',
				'separator' 	=> 'before',
				'placeholder' => esc_html__("Paste bin file URL", 'model-viewer'),
				'condition' => array(
					'decoder' => 'draco',
					'multiple!' => 'yes'
				)
			]
		);

		$this->add_control(
			'poster',
			[
				'label' 		=> esc_html__( 'Select Poster', 'model-viewer' ),
				'type' 			=> 'b-select-file',
				'separator' 	=> 'after',
				'placeholder' => esc_html__("Paste Poster URL", 'model-viewer'),
				'condition' => array(
					'multiple!' => 'yes'
				)
			]
		);
		//single model input field end

		//multiple model input field start
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'modelUrl',
			[
				'label' 		=> esc_html__( 'Select Model', 'model-viewer' ),
				'type' 			=> 'b-select-file',
				'separator' 	=> 'before',
				'placeholder' => esc_html__("Paste Model URL", 'model-viewer'),
			]
		);
		$repeater->add_control(
			'useDecoder',
			[
				'label' => esc_html__( 'Use Decoder', 'model-viewer' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'none',
				'options' => [
					'none'  => esc_html__( 'None', 'model-viewer' ),
					'draco'  => esc_html__( 'Draco', 'model-viewer' ),
				],
			]
		);
		$repeater->add_control(
			'bin_file',
			[
				'label' 		=> esc_html__( 'Upload bin file', 'model-viewer' ),
				'type' 			=> 'b-select-file',
				'separator' 	=> 'before',
				'placeholder' => esc_html__("Paste bin file URL", 'model-viewer'),
				'condition' => array(
					'decoder' => 'draco'
				)
			]
		);

		$repeater->add_control(
			'poster',
			[
				'label' 		=> esc_html__( 'Select Poster', 'model-viewer' ),
				'type' 			=> 'b-select-file',
				'separator' 	=> 'after',
				'placeholder' => esc_html__("Paste Poster URL", 'model-viewer'),
			]
		);

		$this->add_control(
			'models',
			[
				'label' => esc_html__( 'Models', 'model-viewer' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'condition' => array(
					'multiple' => 'yes'
				),
				'default' => [
					[
						'modelUrl' => '',
						'poster' => ''
					]
				]
			]
		);
		//multiple model input field end

		
		//custom angle start
		$this->add_control(
			'hr',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
			'rotate',
			[
				'label' => esc_html__( 'Rotate', 'model-viewer' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
			]
		);
		$this->add_control(
			'rotateAlongX',
			[
				'label' => esc_html__( 'Rotate Along X (degree)', 'model-viewer' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 360,
						'step' => 1,
					],
				],
				'condition' => array(
					'multiple!' => 'yes',
					'rotate' => 'yes'
				)
			]
		);
		$this->add_control(
			'rotateAlongY',
			[
				'label' => esc_html__( 'Rotate Along Y (degree)', 'model-viewer' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 360,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '75'
				],
				'condition' => array(
					'multiple!' => 'yes',
					'rotate' => 'yes'
				)
			]
		);

		$this->add_control(
			'hr_after_angle',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
				'condition' => array(
					'multiple!' => 'yes',
					'rotate' => 'yes'
				)
			]
		);
		//custom angle end

		//disable full screen
		$this->add_control(
			'fullscreen',
			[
				'label' => esc_html__( 'Fullscreen Button', 'model-viewer' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		//camera controls
		$this->add_control(
			'mouseControls',
			[
				'label' => esc_html__( 'Mouse Control', 'model-viewer' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Enable', 'model-viewer' ),
				'label_off' => esc_html__( 'Disable', 'model-viewer' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		//lazy load
		$this->add_control(
			'lazy_load',
			[
				'label' => esc_html__( 'Lazy Load', 'model-viewer' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Enable', 'model-viewer' ),
				'label_off' => esc_html__( 'Disable', 'model-viewer' ),
				'return_value' => 'yes',
				'default' => false,
			]
		);

		//shadow
		$this->add_control(
			'shadow',
			[
				'label' => esc_html__( 'Enable Shadow', 'model-viewer' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Enable', 'model-viewer' ),
				'label_off' => esc_html__( 'Disable', 'model-viewer' ),
				'return_value' => 'yes',
				'default' => false,
			]
		);

		//autoplay
		$this->add_control(
			'autoplay',
			[
				'label' => esc_html__( 'Autoplay ( if animated )', 'model-viewer' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => false,
			]
		);

		//variant
		$this->add_control(
			'variant',
			[
				'label' => esc_html__( 'Enable Variant Selector', 'model-viewer' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => false,
			]
		);

		$this->add_control(
			'enableAnimationSelector',
			[
				'label' => esc_html__( 'Enable Animation Selector', 'model-viewer' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => false,
			]
		);

		$this->add_control(
			'loadingPercentage',
			[
				'label' => esc_html__( 'show loading percentage', 'model-viewer' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => false,
			]
		);
		

		$this->add_control(
			'progressBar',
			[
				'label' => esc_html__( 'show progressbar', 'model-viewer' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'exposure',
			[
				'label' => esc_html__( 'Exposure', 'model-viewer' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0.1,
						'max' => 10,
						'step' => 0.1,
					],
				],
				'default' => [
					'unit'  => 'px',
					'size' => 1
				]
			]
		);

		$this->end_controls_section();

		
		// Style Tab Start
		$this->start_controls_section(
			'model',
			[
				'label' => esc_html__( 'Model', 'model-viewer' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		//width
		$this->add_control(
			'width',
			[
				'label' => esc_html__( 'Width', 'model-viewer' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'vw' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 20,
						'max' => 100,
					],
					'vw' => [
						'min' => 5,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .b3dviewer model-viewer' => 'width: {{SIZE}}{{UNIT}};margin:0 auto;max-width:100%;',
				],
			]
		);

		//height
		$this->add_control(
			'height',
			[
				'label' => esc_html__( 'Height', 'model-viewer' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'vh' ],
				'range' => [
					'px' => [
						'min' => 200,
						'max' => 1000,
						'step' => 5,
					],
					'vh' => [
						'min' => 5,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 500,
				],
				'selectors' => [
					'{{WRAPPER}} .b3dviewer model-viewer' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .b3dviewer model-viewer #lazy-load-poster img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		//background color
		$this->add_control(
			'backgroundColor',
			[
				'label' => esc_html__( 'Background Color', 'model-viewer' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .b3dviewer model-viewer' => 'background: {{VALUE}}',
				],
			]
		);

		//background image
		$this->add_control(
			'backgroundImage',
			[
				'label' => esc_html__( 'Choose Background Image', 'model-viewer' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .b3dviewer model-viewer' => 'background-image: url({{URL}});background-repeat: no-repeat; background-size: cover',
				],
			]
		);

		$this->end_controls_section();

		// Style Tab End

	}

	protected function render() {
		
		$settings = $this->get_settings_for_display();	
		
		$data = [
			'uniqueId' => "b3dviewer".uniqid(),
			'model' => [
				'modelUrl' => $settings['modelUrl'],
				'poster' => $settings['poster'],
				'useDecoder' => $settings['useDecoder']
			],
			'stylesheet' => '',
			'multiple' => $settings['multiple'],
			'models' => $settings['models'],
			'lazyLoad' => $settings['lazy_load'],
			'autoplay' => $settings['autoplay'],
			'shadow' => $settings['shadow'],
			'rotate' => $settings['rotate'],
			'autoRotate' => true,
            "zoom" => true,
			'mouseControl' => (boolean) $settings['mouseControls'],
			'fullscreen' => $settings['fullscreen'],
			'variant' => (boolean) $settings['variant'],
			'animation' =>  (boolean) $settings['enableAnimationSelector'],
			'loadingPercentage' => (boolean) $settings['loadingPercentage'],
			'progressBar' => $settings['progressBar'],
			'rotateAlongX' => isset($settings['rotateAlongX']['size']) ? $settings['rotateAlongX']['size']: 0,
			'rotateAlongY' => isset($settings['rotateAlongY']['size']) ? $settings['rotateAlongY']['size'] : 75,
			'exposure' =>  isset($settings['exposure']['size']) ? $settings['exposure']['size'] : 1,
			'styles' => [],
			'additional' => [],
			'selectedAnimation' => '',
			'woo' => false,
			'elementor' => true
		];
		

		echo \BP3D\Template\ModelViewer::html($data);

	}
}