<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/googleads/v13/resources/campaign.proto

namespace Google\Ads\GoogleAds\V13\Resources\Campaign;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The setting for Shopping campaigns. Defines the universe of products that
 * can be advertised by the campaign, and how this campaign interacts with
 * other Shopping campaigns.
 *
 * Generated from protobuf message <code>google.ads.googleads.v13.resources.Campaign.ShoppingSetting</code>
 */
class ShoppingSetting extends \Google\Protobuf\Internal\Message
{
    /**
     * Immutable. ID of the Merchant Center account.
     * This field is required for create operations. This field is immutable for
     * Shopping campaigns.
     *
     * Generated from protobuf field <code>optional int64 merchant_id = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $merchant_id = null;
    /**
     * Sales country of products to include in the campaign.
     * Only one of feed_label or sales_country can be set.
     * Field is immutable except for clearing.
     * Once this field is cleared, you must use feed_label if you
     * want to set the sales country.
     *
     * Generated from protobuf field <code>optional string sales_country = 6;</code>
     */
    protected $sales_country = null;
    /**
     * Feed label of products to include in the campaign.
     * Only one of feed_label or sales_country can be set.
     * If used instead of sales_country, the feed_label field accepts country
     * codes in the same format for example: 'XX'.
     * Otherwise can be any string used for feed label in Google Merchant
     * Center.
     *
     * Generated from protobuf field <code>string feed_label = 10;</code>
     */
    protected $feed_label = '';
    /**
     * Priority of the campaign. Campaigns with numerically higher priorities
     * take precedence over those with lower priorities.
     * This field is required for Shopping campaigns, with values between 0 and
     * 2, inclusive.
     * This field is optional for Smart Shopping campaigns, but must be equal to
     * 3 if set.
     *
     * Generated from protobuf field <code>optional int32 campaign_priority = 7;</code>
     */
    protected $campaign_priority = null;
    /**
     * Whether to include local products.
     *
     * Generated from protobuf field <code>optional bool enable_local = 8;</code>
     */
    protected $enable_local = null;
    /**
     * Immutable. Whether to target Vehicle Listing inventory. This field is
     * supported only in Smart Shopping Campaigns. For setting Vehicle Listing
     * inventory in Performance Max campaigns, use `listing_type` instead.
     *
     * Generated from protobuf field <code>bool use_vehicle_inventory = 9 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $use_vehicle_inventory = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int|string $merchant_id
     *           Immutable. ID of the Merchant Center account.
     *           This field is required for create operations. This field is immutable for
     *           Shopping campaigns.
     *     @type string $sales_country
     *           Sales country of products to include in the campaign.
     *           Only one of feed_label or sales_country can be set.
     *           Field is immutable except for clearing.
     *           Once this field is cleared, you must use feed_label if you
     *           want to set the sales country.
     *     @type string $feed_label
     *           Feed label of products to include in the campaign.
     *           Only one of feed_label or sales_country can be set.
     *           If used instead of sales_country, the feed_label field accepts country
     *           codes in the same format for example: 'XX'.
     *           Otherwise can be any string used for feed label in Google Merchant
     *           Center.
     *     @type int $campaign_priority
     *           Priority of the campaign. Campaigns with numerically higher priorities
     *           take precedence over those with lower priorities.
     *           This field is required for Shopping campaigns, with values between 0 and
     *           2, inclusive.
     *           This field is optional for Smart Shopping campaigns, but must be equal to
     *           3 if set.
     *     @type bool $enable_local
     *           Whether to include local products.
     *     @type bool $use_vehicle_inventory
     *           Immutable. Whether to target Vehicle Listing inventory. This field is
     *           supported only in Smart Shopping Campaigns. For setting Vehicle Listing
     *           inventory in Performance Max campaigns, use `listing_type` instead.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\GoogleAds\V13\Resources\Campaign::initOnce();
        parent::__construct($data);
    }

    /**
     * Immutable. ID of the Merchant Center account.
     * This field is required for create operations. This field is immutable for
     * Shopping campaigns.
     *
     * Generated from protobuf field <code>optional int64 merchant_id = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return int|string
     */
    public function getMerchantId()
    {
        return isset($this->merchant_id) ? $this->merchant_id : 0;
    }

    public function hasMerchantId()
    {
        return isset($this->merchant_id);
    }

    public function clearMerchantId()
    {
        unset($this->merchant_id);
    }

    /**
     * Immutable. ID of the Merchant Center account.
     * This field is required for create operations. This field is immutable for
     * Shopping campaigns.
     *
     * Generated from protobuf field <code>optional int64 merchant_id = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param int|string $var
     * @return $this
     */
    public function setMerchantId($var)
    {
        GPBUtil::checkInt64($var);
        $this->merchant_id = $var;

        return $this;
    }

    /**
     * Sales country of products to include in the campaign.
     * Only one of feed_label or sales_country can be set.
     * Field is immutable except for clearing.
     * Once this field is cleared, you must use feed_label if you
     * want to set the sales country.
     *
     * Generated from protobuf field <code>optional string sales_country = 6;</code>
     * @return string
     */
    public function getSalesCountry()
    {
        return isset($this->sales_country) ? $this->sales_country : '';
    }

    public function hasSalesCountry()
    {
        return isset($this->sales_country);
    }

    public function clearSalesCountry()
    {
        unset($this->sales_country);
    }

    /**
     * Sales country of products to include in the campaign.
     * Only one of feed_label or sales_country can be set.
     * Field is immutable except for clearing.
     * Once this field is cleared, you must use feed_label if you
     * want to set the sales country.
     *
     * Generated from protobuf field <code>optional string sales_country = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setSalesCountry($var)
    {
        GPBUtil::checkString($var, True);
        $this->sales_country = $var;

        return $this;
    }

    /**
     * Feed label of products to include in the campaign.
     * Only one of feed_label or sales_country can be set.
     * If used instead of sales_country, the feed_label field accepts country
     * codes in the same format for example: 'XX'.
     * Otherwise can be any string used for feed label in Google Merchant
     * Center.
     *
     * Generated from protobuf field <code>string feed_label = 10;</code>
     * @return string
     */
    public function getFeedLabel()
    {
        return $this->feed_label;
    }

    /**
     * Feed label of products to include in the campaign.
     * Only one of feed_label or sales_country can be set.
     * If used instead of sales_country, the feed_label field accepts country
     * codes in the same format for example: 'XX'.
     * Otherwise can be any string used for feed label in Google Merchant
     * Center.
     *
     * Generated from protobuf field <code>string feed_label = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setFeedLabel($var)
    {
        GPBUtil::checkString($var, True);
        $this->feed_label = $var;

        return $this;
    }

    /**
     * Priority of the campaign. Campaigns with numerically higher priorities
     * take precedence over those with lower priorities.
     * This field is required for Shopping campaigns, with values between 0 and
     * 2, inclusive.
     * This field is optional for Smart Shopping campaigns, but must be equal to
     * 3 if set.
     *
     * Generated from protobuf field <code>optional int32 campaign_priority = 7;</code>
     * @return int
     */
    public function getCampaignPriority()
    {
        return isset($this->campaign_priority) ? $this->campaign_priority : 0;
    }

    public function hasCampaignPriority()
    {
        return isset($this->campaign_priority);
    }

    public function clearCampaignPriority()
    {
        unset($this->campaign_priority);
    }

    /**
     * Priority of the campaign. Campaigns with numerically higher priorities
     * take precedence over those with lower priorities.
     * This field is required for Shopping campaigns, with values between 0 and
     * 2, inclusive.
     * This field is optional for Smart Shopping campaigns, but must be equal to
     * 3 if set.
     *
     * Generated from protobuf field <code>optional int32 campaign_priority = 7;</code>
     * @param int $var
     * @return $this
     */
    public function setCampaignPriority($var)
    {
        GPBUtil::checkInt32($var);
        $this->campaign_priority = $var;

        return $this;
    }

    /**
     * Whether to include local products.
     *
     * Generated from protobuf field <code>optional bool enable_local = 8;</code>
     * @return bool
     */
    public function getEnableLocal()
    {
        return isset($this->enable_local) ? $this->enable_local : false;
    }

    public function hasEnableLocal()
    {
        return isset($this->enable_local);
    }

    public function clearEnableLocal()
    {
        unset($this->enable_local);
    }

    /**
     * Whether to include local products.
     *
     * Generated from protobuf field <code>optional bool enable_local = 8;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableLocal($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_local = $var;

        return $this;
    }

    /**
     * Immutable. Whether to target Vehicle Listing inventory. This field is
     * supported only in Smart Shopping Campaigns. For setting Vehicle Listing
     * inventory in Performance Max campaigns, use `listing_type` instead.
     *
     * Generated from protobuf field <code>bool use_vehicle_inventory = 9 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return bool
     */
    public function getUseVehicleInventory()
    {
        return $this->use_vehicle_inventory;
    }

    /**
     * Immutable. Whether to target Vehicle Listing inventory. This field is
     * supported only in Smart Shopping Campaigns. For setting Vehicle Listing
     * inventory in Performance Max campaigns, use `listing_type` instead.
     *
     * Generated from protobuf field <code>bool use_vehicle_inventory = 9 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param bool $var
     * @return $this
     */
    public function setUseVehicleInventory($var)
    {
        GPBUtil::checkBool($var);
        $this->use_vehicle_inventory = $var;

        return $this;
    }

}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ShoppingSetting::class, \Google\Ads\GoogleAds\V13\Resources\Campaign_ShoppingSetting::class);

