import { __ } from "@wordpress/i18n";

export const NoDataIcon = (props) => {
  return (
    <svg
      width="301"
      height="170"
      viewBox="0 0 301 170"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M216.63 143.584H77.1725C76.4512 143.584 75.8662 142.999 75.8662 142.277V58.5242C75.8662 54.1166 79.4484 50.5344 83.84 50.5344H209.955C214.354 50.5344 217.937 54.1166 217.937 58.5242V142.277C217.937 142.999 217.352 143.584 216.63 143.584V143.584Z"
        fill="#F2F2F2"
      />
      <path
        d="M183.076 40.2365C183.397 38.9783 184.182 37.9285 185.296 37.2633C186.201 36.7264 187.227 36.502 188.253 36.6062C188.493 36.6303 188.726 36.6703 188.958 36.7344C191.547 37.3916 193.117 40.0281 192.468 42.6166C191.811 45.2051 189.175 46.7758 186.586 46.1267C183.998 45.4696 182.427 42.833 183.076 40.2445V40.2365Z"
        fill="#E6E6E6"
      />
      <path
        d="M160.18 38.2651V44.548C160.18 44.7323 160.293 44.8926 160.469 44.9567L165.421 46.6637C165.99 49.1159 166.96 51.4159 168.25 53.4995L165.95 58.2117C165.87 58.38 165.902 58.5723 166.031 58.7085L170.47 63.1563C170.598 63.2845 170.799 63.3165 170.959 63.2364L175.671 60.9444C177.747 62.2347 180.047 63.2043 182.499 63.7813L184.206 68.7339C184.262 68.9102 184.43 69.0224 184.615 69.0224H190.898C191.082 69.0224 191.242 68.9102 191.306 68.7339L193.013 63.7813C195.466 63.2124 197.766 62.2427 199.849 60.9524L204.561 63.2524C204.73 63.3326 204.922 63.3005 205.058 63.1723L209.506 58.7326C209.634 58.6044 209.666 58.404 209.586 58.2357L207.294 53.5235C208.584 51.4479 209.554 49.148 210.131 46.6957L215.084 44.9887C215.26 44.9327 215.372 44.7644 215.372 44.58V38.2971C215.372 38.1128 215.26 37.9525 215.084 37.8884L210.131 36.1815C209.562 33.7292 208.592 31.4292 207.302 29.3456L209.602 24.6334C209.682 24.4652 209.65 24.2728 209.522 24.1366L205.082 19.6889C204.954 19.5607 204.754 19.5286 204.585 19.6087L199.873 21.9007C197.798 20.6105 195.498 19.6408 193.045 19.0638L191.338 14.1112C191.282 13.9349 191.114 13.8227 190.93 13.8227H184.647C184.462 13.8227 184.302 13.9349 184.238 14.1112L182.531 19.0638C180.079 19.6328 177.779 20.6025 175.695 21.8927L170.983 19.5927C170.815 19.5126 170.622 19.5446 170.486 19.6728L166.039 24.1125C165.91 24.2408 165.878 24.4411 165.958 24.6014L168.25 29.3136C166.96 31.3892 165.99 33.6892 165.413 36.1414L160.461 37.8484C160.285 37.9045 160.172 38.0728 160.172 38.2571L160.18 38.2651ZM176.713 30.3313C179.646 27.3982 183.549 25.7875 187.7 25.7875C196.259 25.7875 203.231 32.7676 203.223 41.3344C203.223 41.8633 203.199 42.3922 203.143 42.9132C202.91 45.1731 202.189 47.3609 201.019 49.3082C200.915 49.4845 200.691 49.5406 200.514 49.4365C200.386 49.3643 200.322 49.2201 200.338 49.0839C200.338 49.0278 200.362 48.9797 200.386 48.9316C201.5 47.0724 202.189 44.9887 202.414 42.833C202.462 42.3361 202.494 41.8313 202.494 41.3344C202.494 33.1763 195.874 26.5327 187.708 26.5247C183.757 26.5247 180.039 28.0554 177.242 30.8522C174.806 33.2804 173.323 36.4139 172.979 39.7877C172.93 40.2926 172.898 40.7975 172.898 41.3104C172.898 44.2274 173.74 46.9522 175.206 49.2441C177.835 53.3713 182.443 56.112 187.684 56.1201C188.742 56.1201 189.792 56.0079 190.818 55.7915C191.018 55.7514 191.21 55.8716 191.258 56.072C191.266 56.112 191.266 56.1521 191.258 56.1842C191.242 56.3364 191.13 56.4727 190.97 56.5047C190.906 56.5207 190.85 56.5288 190.785 56.5448C190.753 56.5448 190.721 56.5608 190.689 56.5608H190.657C189.848 56.7211 189.014 56.8173 188.189 56.8413C188.021 56.8413 187.852 56.8413 187.684 56.8413C187.147 56.8413 186.618 56.8173 186.089 56.7612C182.539 56.4005 179.253 54.8458 176.705 52.2894C173.772 49.3563 172.161 45.4536 172.161 41.3024C172.161 40.7654 172.185 40.2365 172.241 39.7076C172.602 36.1654 174.165 32.8798 176.713 30.3233V30.3313ZM187.139 47.7135C186.835 47.6814 186.53 47.6253 186.226 47.5532C182.852 46.6957 180.8 43.2577 181.65 39.8759C182.066 38.241 183.092 36.8627 184.543 35.9972C185.993 35.1317 187.692 34.8832 189.327 35.2999C192.701 36.1574 194.752 39.5954 193.903 42.9773C193.126 46.0466 190.208 48.026 187.139 47.7135V47.7135Z"
        fill="#E6E6E6"
      />
      <path
        d="M210.948 65.4082V69.6155C210.948 69.7357 211.02 69.8479 211.141 69.8879L214.45 71.0339C214.835 72.6768 215.476 74.2154 216.342 75.6098L214.803 78.7593C214.747 78.8715 214.771 78.9997 214.859 79.0879L217.832 82.061C217.92 82.1492 218.049 82.1732 218.161 82.1171L221.31 80.5865C222.705 81.452 224.235 82.1011 225.878 82.4858L227.016 85.7955C227.056 85.9077 227.168 85.9878 227.289 85.9878H231.496C231.616 85.9878 231.728 85.9157 231.768 85.7955L232.914 82.4858C234.557 82.1011 236.096 81.46 237.49 80.5945L240.64 82.1332C240.752 82.1893 240.88 82.1652 240.968 82.0771L243.941 79.1039C244.03 79.0157 244.054 78.8875 243.998 78.7753L242.467 75.6259C243.332 74.2315 243.982 72.7008 244.366 71.058L247.676 69.92C247.796 69.8799 247.868 69.7677 247.868 69.6475V65.4402C247.868 65.32 247.796 65.2078 247.676 65.1677L244.366 64.0218C243.982 62.3789 243.34 60.8402 242.475 59.4458L244.014 56.2964C244.07 56.1842 244.046 56.0559 243.957 55.9678L240.984 52.9946C240.896 52.9065 240.768 52.8824 240.656 52.9385L237.506 54.4692C236.112 53.6037 234.581 52.9546 232.938 52.5699L231.8 49.2601C231.76 49.148 231.648 49.0678 231.528 49.0678H227.321C227.2 49.0678 227.088 49.1399 227.048 49.2601L225.902 52.5699C224.259 52.9546 222.721 53.5957 221.326 54.4612L218.177 52.9225C218.065 52.8664 217.936 52.8904 217.848 52.9786L214.875 55.9518C214.787 56.0399 214.763 56.1681 214.819 56.2803L216.35 59.4298C215.484 60.8242 214.835 62.3549 214.45 63.9977L211.141 65.1357C211.02 65.1757 210.948 65.2879 210.948 65.4082ZM221.783 59.8706C223.811 57.851 226.503 56.7371 229.364 56.7371C232.225 56.7371 234.918 57.8591 236.937 59.8786C238.957 61.9061 240.071 64.5987 240.071 67.4597C240.071 67.8203 240.055 68.189 240.015 68.5496C239.854 70.1123 239.358 71.6189 238.548 72.9653C238.388 73.2377 238.035 73.3179 237.771 73.1576C237.578 73.0374 237.474 72.821 237.498 72.6126C237.498 72.5325 237.53 72.4524 237.578 72.3802C238.3 71.1782 238.748 69.8318 238.893 68.4374C238.925 68.1169 238.941 67.7883 238.941 67.4677C238.941 64.9113 237.947 62.5071 236.144 60.696C234.333 58.8848 231.929 57.8911 229.372 57.8831C226.816 57.8831 224.412 58.8768 222.6 60.68C221.022 62.2507 220.06 64.2782 219.844 66.466C219.812 66.7946 219.796 67.1231 219.796 67.4517C219.796 70.0081 220.789 72.4123 222.592 74.2234C222.608 74.2395 222.624 74.2555 222.641 74.2715L222.657 74.2876C223.282 74.9046 223.971 75.3053 224.716 75.722C226.086 76.4914 227.641 76.8119 229.252 76.8119C229.292 76.8119 228.779 76.8119 228.779 76.8119V77.0043C229.917 77.0043 230.438 76.9482 231.103 76.8119C231.408 76.7478 231.856 76.9482 231.929 77.2607C231.945 77.3168 232.017 77.3889 232.009 77.445C231.985 77.6854 231.849 77.8938 231.6 77.9419C231.568 77.9419 231.552 77.9579 231.52 77.9659C230.807 78.1102 230.085 78.1823 229.356 78.1823C228.988 78.1823 228.627 78.1663 228.274 78.1262C222.873 77.5733 218.65 72.9973 218.658 67.4597C218.658 67.0911 218.682 66.7224 218.714 66.3618C218.962 63.9176 220.036 61.6496 221.799 59.8866L221.783 59.8706ZM231.616 71.2182C230.815 71.6991 229.901 71.8994 228.988 71.8032C228.779 71.7792 228.571 71.7471 228.362 71.691C227.249 71.4106 226.311 70.7134 225.718 69.7196C225.133 68.7339 224.965 67.5719 225.245 66.458C225.83 64.158 228.17 62.7636 230.47 63.3406C232.77 63.9256 234.165 66.2656 233.588 68.5656C233.307 69.6796 232.61 70.6172 231.616 71.2022V71.2182Z"
        fill="#E6E6E6"
      />
      <path
        d="M226.695 69.1426C226.263 68.4134 226.142 67.5639 226.343 66.7465C226.735 65.2078 228.194 64.2141 229.733 64.3744C229.885 64.3904 230.037 64.4144 230.189 64.4545C231.88 64.8872 232.906 66.6102 232.481 68.3012C232.273 69.1186 231.76 69.8078 231.031 70.2405C230.302 70.6733 229.452 70.7935 228.635 70.5931C227.817 70.3848 227.128 69.8719 226.695 69.1426Z"
        fill="#E6E6E6"
      />
      <path
        d="M77.1723 147.446C74.2873 147.446 71.5386 145.162 71.5386 142.277V58.5242C71.5386 51.9608 77.2845 47.1846 83.8399 47.1846H209.955C216.518 47.1846 221.919 51.9608 221.919 58.5242V142.277C221.919 145.162 219.507 147.446 216.622 147.446H77.1723Z"
        fill="white"
      />
      <path
        d="M135.152 20.1136H110.301C109.636 20.1136 109.099 19.5767 109.099 18.9115V5.36002C109.099 4.69487 109.636 4.15794 110.301 4.15794H135.152C135.817 4.15794 136.354 4.69487 136.354 5.36002V18.9115C136.354 19.5767 135.817 20.1136 135.152 20.1136V20.1136ZM110.301 4.67083C109.925 4.67083 109.612 4.97536 109.612 5.36002V18.9115C109.612 19.2882 109.917 19.6007 110.301 19.6007H135.152C135.529 19.6007 135.833 19.2962 135.833 18.9115V5.36002C135.833 4.98337 135.529 4.67083 135.152 4.67083H110.301V4.67083Z"
        fill="#E6E6E6"
      />
      <path
        d="M136.09 9.7837H109.356C109.211 9.7837 109.099 9.6715 109.099 9.52725V7.45967C109.099 7.31542 109.211 7.20322 109.356 7.20322H136.09C136.234 7.20322 136.346 7.31542 136.346 7.45967V9.52725C136.346 9.6715 136.234 9.7837 136.09 9.7837V9.7837ZM109.612 9.27081H135.833V7.71611H109.612V9.27081Z"
        fill="#E6E6E6"
      />
      <path
        d="M128.918 16.7077C127.868 16.7077 127.011 15.8502 127.011 14.8004C127.011 13.7506 127.868 12.9011 128.918 12.9011C129.415 12.9011 129.88 13.0934 130.232 13.43C130.28 13.4781 130.312 13.5422 130.312 13.6143C130.312 13.6865 130.28 13.7506 130.232 13.7987C129.96 14.0551 129.808 14.4237 129.808 14.8004C129.808 15.177 129.96 15.5377 130.232 15.8021C130.28 15.8502 130.312 15.9143 130.312 15.9865C130.312 16.0586 130.28 16.1227 130.232 16.1708C129.88 16.5154 129.407 16.6997 128.918 16.6997V16.7077ZM128.918 13.414C128.149 13.414 127.532 14.0391 127.532 14.8004C127.532 15.5617 128.157 16.1948 128.918 16.1948C129.199 16.1948 129.463 16.1147 129.687 15.9624C129.431 15.6338 129.295 15.2251 129.295 14.8004C129.295 14.3757 129.439 13.9669 129.687 13.6384C129.463 13.4861 129.199 13.406 128.918 13.406V13.414Z"
        fill="#E6E6E6"
      />
      <path
        d="M131.193 16.7077C130.144 16.7077 129.286 15.8502 129.286 14.8004C129.286 13.7506 130.144 12.9011 131.193 12.9011C132.243 12.9011 133.101 13.7586 133.101 14.8004C133.101 15.8422 132.243 16.7077 131.193 16.7077ZM131.193 13.414C130.424 13.414 129.807 14.0391 129.807 14.8004C129.807 15.5617 130.432 16.1948 131.193 16.1948C131.955 16.1948 132.58 15.5697 132.58 14.8004C132.58 14.0311 131.955 13.414 131.193 13.414Z"
        fill="#E6E6E6"
      />
      <path
        d="M121.882 12.9171H110.775C110.63 12.9171 110.518 12.8049 110.518 12.6607C110.518 12.5164 110.63 12.4042 110.775 12.4042H121.882C122.026 12.4042 122.138 12.5164 122.138 12.6607C122.138 12.8049 122.026 12.9171 121.882 12.9171V12.9171Z"
        fill="#E6E6E6"
      />
      <path
        d="M121.882 16.0185H110.775C110.63 16.0185 110.518 15.9063 110.518 15.7621C110.518 15.6178 110.63 15.5056 110.775 15.5056H121.882C122.026 15.5056 122.138 15.6178 122.138 15.7621C122.138 15.9063 122.026 16.0185 121.882 16.0185V16.0185Z"
        fill="#E6E6E6"
      />
      <path
        d="M112.569 6.19347H111.167C111.022 6.19347 110.91 6.08127 110.91 5.93702C110.91 5.79277 111.022 5.68058 111.167 5.68058H112.569C112.713 5.68058 112.825 5.79277 112.825 5.93702C112.825 6.08127 112.713 6.19347 112.569 6.19347Z"
        fill="#E6E6E6"
      />
      <path
        d="M115.463 6.19347H114.06C113.916 6.19347 113.804 6.08127 113.804 5.93702C113.804 5.79277 113.916 5.68058 114.06 5.68058H115.463C115.607 5.68058 115.719 5.79277 115.719 5.93702C115.719 6.08127 115.607 6.19347 115.463 6.19347Z"
        fill="#E6E6E6"
      />
      <path
        d="M118.347 6.19347H116.945C116.801 6.19347 116.688 6.08127 116.688 5.93702C116.688 5.79277 116.801 5.68058 116.945 5.68058H118.347C118.492 5.68058 118.604 5.79277 118.604 5.93702C118.604 6.08127 118.492 6.19347 118.347 6.19347Z"
        fill="#E6E6E6"
      />
      <path
        d="M109.356 16.1387H106.247C105.589 16.1387 105.044 15.6018 105.044 14.9446V1.39315C105.044 0.736006 105.581 0.199074 106.247 0.199074H131.098C131.755 0.199074 132.292 0.736006 132.292 1.39315V4.4224C132.292 4.56665 132.179 4.67884 132.035 4.67884H110.294C109.917 4.67884 109.604 4.98337 109.604 5.36804V15.8903C109.604 16.0345 109.492 16.1467 109.348 16.1467L109.356 16.1387ZM106.247 0.703949C105.87 0.703949 105.565 1.00848 105.565 1.38513V14.9446C105.565 15.3213 105.87 15.6258 106.247 15.6258H109.091V5.36002C109.091 4.69487 109.628 4.15794 110.294 4.15794H131.779V1.38513C131.779 1.00848 131.474 0.703949 131.098 0.703949H106.247V0.703949Z"
        fill="#E6E6E6"
      />
      <path
        d="M51.3519 117.186C49.9975 117.186 48.8916 116.08 48.8916 114.726C48.8916 113.371 49.9975 112.265 51.3519 112.265C52.7062 112.265 53.8121 113.371 53.8121 114.726C53.8121 116.08 52.7062 117.186 51.3519 117.186ZM51.3519 113.163C50.4944 113.163 49.7892 113.86 49.7892 114.726C49.7892 115.591 50.4864 116.28 51.3519 116.28C52.2174 116.28 52.9146 115.583 52.9146 114.726C52.9146 113.868 52.2174 113.163 51.3519 113.163Z"
        fill="#E6E6E6"
      />
      <path
        d="M24.754 141.989C24.5055 141.989 24.3052 141.789 24.3052 141.54V135.313C24.3052 135.065 24.5055 134.865 24.754 134.865C25.0024 134.865 25.2027 135.065 25.2027 135.313V141.54C25.2027 141.789 25.0024 141.989 24.754 141.989Z"
        fill="#E6E6E6"
      />
      <path
        d="M27.8631 138.88H21.6363C21.3879 138.88 21.1875 138.679 21.1875 138.431C21.1875 138.182 21.3879 137.982 21.6363 137.982H27.8631C28.1115 137.982 28.3119 138.182 28.3119 138.431C28.3119 138.679 28.1115 138.88 27.8631 138.88Z"
        fill="#E6E6E6"
      />
      <path
        d="M10.8179 51.3758C10.5695 51.3758 10.3691 51.1755 10.3691 50.927V44.7002C10.3691 44.4518 10.5695 44.2515 10.8179 44.2515C11.0664 44.2515 11.2667 44.4518 11.2667 44.7002V50.927C11.2667 51.1755 11.0664 51.3758 10.8179 51.3758Z"
        fill="#E6E6E6"
      />
      <path
        d="M13.927 48.2664H7.70025C7.45182 48.2664 7.25146 48.0661 7.25146 47.8177C7.25146 47.5692 7.45182 47.3689 7.70025 47.3689H13.927C14.1755 47.3689 14.3758 47.5692 14.3758 47.8177C14.3758 48.0661 14.1755 48.2664 13.927 48.2664Z"
        fill="#E6E6E6"
      />
      <path
        d="M54.309 81.6443H31.285C30.7401 81.6443 30.2993 81.2036 30.2993 80.6586C30.2993 80.1137 30.7401 79.6729 31.285 79.6729H54.309C54.8539 79.6729 55.2947 80.1137 55.2947 80.6586C55.2947 81.2036 54.8539 81.6443 54.309 81.6443Z"
        fill="#E6E6E6"
      />
      <path
        d="M19.256 100.725H1.64147C1.09653 100.725 0.655762 100.285 0.655762 99.7397C0.655762 99.1948 1.09653 98.754 1.64147 98.754H19.256C19.801 98.754 20.2417 99.1948 20.2417 99.7397C20.2417 100.285 19.801 100.725 19.256 100.725Z"
        fill="#E6E6E6"
      />
      <path
        d="M57.554 48.2183C57.3938 48.2183 57.2495 48.0821 57.2495 47.9218V41.3825C57.2495 41.2222 57.3857 41.086 57.546 41.086H64.0533C64.1415 41.086 64.2216 41.1261 64.2777 41.1902C64.3819 41.3104 64.3819 41.4947 64.2777 41.5989L57.7704 48.1302C57.7143 48.1863 57.6422 48.2183 57.5621 48.2183H57.554ZM57.8425 41.679V47.2166L63.3641 41.679H57.8425Z"
        fill="#E6E6E6"
      />
      <path
        d="M57.5464 48.2184H38.0245C37.8643 48.2184 37.728 48.0821 37.728 47.9218V12.5164C37.728 12.3562 37.8643 12.2199 38.0245 12.2199H64.0537C64.214 12.2199 64.3502 12.3562 64.3502 12.5164V41.3825C64.3502 41.5428 64.214 41.679 64.0537 41.679H57.8429V47.9218C57.8429 48.0821 57.7067 48.2184 57.5464 48.2184V48.2184ZM38.3211 47.6253H57.2499V41.3825C57.2499 41.2222 57.3861 41.086 57.5464 41.086H63.7572V12.8049H38.3211V47.6173V47.6253ZM45.3012 41.4226C44.8444 41.4226 44.3956 41.1902 44.1472 40.7734L43.2095 39.2187C43.0252 38.9142 42.9691 38.5536 43.0573 38.201C43.1454 37.8484 43.3618 37.5519 43.6663 37.3675L54.5572 30.7721C54.6133 30.74 54.6774 30.724 54.7415 30.732L57.7788 31.0526C57.867 31.0606 57.9471 31.1087 57.9952 31.1888C58.0433 31.2609 58.0513 31.3571 58.0272 31.4453L57.0175 34.4745C56.9934 34.5386 56.9534 34.5947 56.8893 34.6348L46.928 40.6693C46.928 40.6693 46.9039 40.6773 46.8959 40.6853L45.9984 41.2382C45.782 41.3665 45.5416 41.4306 45.3012 41.4306V41.4226ZM54.7736 31.3251L43.9628 37.8724C43.7945 37.9766 43.6743 38.1369 43.6182 38.3372C43.5702 38.5376 43.6022 38.7379 43.7064 38.9062L44.644 40.4609C44.8604 40.8215 45.3252 40.9337 45.6858 40.7173L46.6074 40.1484C46.6074 40.1484 46.6315 40.1323 46.6475 40.1323L56.4886 34.17L57.346 31.5975L54.7736 31.3251V31.3251Z"
        fill="#E6E6E6"
      />
      <path
        d="M56.745 34.6669C56.6408 34.6669 56.5446 34.6108 56.4885 34.5226L54.461 31.1728C54.4049 31.0766 54.4049 30.9564 54.461 30.8602C54.5251 30.7641 54.6293 30.716 54.7415 30.724L57.7788 31.0446C57.8669 31.0526 57.9471 31.1007 57.9951 31.1808C58.0432 31.2529 58.0512 31.3491 58.0272 31.4373L57.0175 34.4665C56.9774 34.5787 56.8812 34.6508 56.769 34.6669C56.761 34.6669 56.745 34.6669 56.737 34.6669H56.745ZM55.2784 31.3812L56.6648 33.6731L57.354 31.6055L55.2784 31.3812V31.3812Z"
        fill="#E6E6E6"
      />
      <path
        d="M46.7841 40.7013C46.6799 40.7013 46.5837 40.6452 46.5276 40.5571L45.5098 38.8822C45.4537 38.794 45.4537 38.6738 45.5098 38.5856C45.5419 38.5296 45.59 38.4895 45.6461 38.4574L55.5833 32.439C55.6474 32.3989 55.7276 32.3829 55.8077 32.4069C55.8878 32.423 55.952 32.471 55.992 32.5432L57.0018 34.2181C57.0899 34.3543 57.0418 34.5386 56.9056 34.6268L46.9443 40.6613C46.8963 40.6853 46.8482 40.7013 46.7921 40.7013H46.7841ZM46.167 38.8341L46.8802 39.9961L56.3366 34.2662L55.6314 33.0961L46.167 38.8261V38.8341Z"
        fill="#E6E6E6"
      />
      <path
        d="M45.7658 39.0344C45.6616 39.0344 45.5574 38.9783 45.5093 38.8902L44.5076 37.2233C44.4675 37.1672 44.4515 37.0951 44.4595 37.0229C44.4675 36.9348 44.5236 36.8546 44.5958 36.8066L54.565 30.7721C54.7013 30.6839 54.8856 30.732 54.9738 30.8683L55.9915 32.5432C56.0316 32.6073 56.0476 32.6874 56.0236 32.7676C56.0075 32.8477 55.9595 32.9118 55.8873 32.9519L45.9261 38.9863C45.878 39.0104 45.8299 39.0264 45.7738 39.0264L45.7658 39.0344ZM45.1567 37.1592L45.862 38.3372L55.3264 32.6073L54.6131 31.4373L45.1567 37.1672V37.1592Z"
        fill="#E6E6E6"
      />
      <path
        d="M45.3014 41.4226C44.8446 41.4226 44.3958 41.1902 44.1474 40.7734L43.2097 39.2187C43.0254 38.9142 42.9693 38.5536 43.0575 38.201C43.1456 37.8484 43.362 37.5519 43.6665 37.3675L44.5961 36.8066C44.7164 36.7344 44.8686 36.7585 44.9648 36.8546C44.9808 36.8707 44.9968 36.8947 45.0049 36.9107L47.0324 40.2525C47.1205 40.3888 47.0724 40.5731 46.9362 40.6612L46.0066 41.2302C45.7902 41.3585 45.5498 41.4226 45.3094 41.4226H45.3014ZM44.6442 37.4637L43.9711 37.8724C43.8028 37.9766 43.6826 38.1369 43.6265 38.3372C43.5784 38.5376 43.6104 38.7379 43.7146 38.9062L44.6522 40.4609C44.8686 40.8215 45.3334 40.9337 45.694 40.7173L46.3672 40.3086L45.5819 39.0104L44.6442 37.4557V37.4637Z"
        fill="#E6E6E6"
      />
      <path
        d="M57.5464 48.2184H38.0245C37.8643 48.2184 37.728 48.0821 37.728 47.9218V12.5164C37.728 12.3562 37.8643 12.2199 38.0245 12.2199H64.0537C64.214 12.2199 64.3502 12.3562 64.3502 12.5164V41.3825C64.3502 41.5428 64.214 41.679 64.0537 41.679H57.8429V47.9218C57.8429 48.0821 57.7067 48.2184 57.5464 48.2184V48.2184ZM38.3211 47.6253H57.2499V41.3825C57.2499 41.2222 57.3861 41.086 57.5464 41.086H63.7572V12.8049H38.3211V47.6173V47.6253Z"
        fill="#E6E6E6"
      />
      <path
        d="M57.5542 48.2183C57.4821 48.2183 57.402 48.1863 57.3459 48.1302C57.2337 48.018 57.2337 47.8257 57.3459 47.7135L63.8532 41.1821C63.9653 41.0699 64.1577 41.0699 64.2699 41.1821C64.3821 41.2943 64.3821 41.4867 64.2699 41.5989L57.7626 48.1302C57.7065 48.1863 57.6263 48.2183 57.5542 48.2183Z"
        fill="#E6E6E6"
      />
      <path
        d="M59.654 19.3283H42.1276C41.9673 19.3283 41.8311 19.192 41.8311 19.0317C41.8311 18.8715 41.9673 18.7352 42.1276 18.7352H59.654C59.8142 18.7352 59.9505 18.8715 59.9505 19.0317C59.9505 19.192 59.8142 19.3283 59.654 19.3283Z"
        fill="#E6E6E6"
      />
      <path
        d="M59.654 24.0324H42.1276C41.9673 24.0324 41.8311 23.8962 41.8311 23.7359C41.8311 23.5756 41.9673 23.4394 42.1276 23.4394H59.654C59.8142 23.4394 59.9505 23.5756 59.9505 23.7359C59.9505 23.8962 59.8142 24.0324 59.654 24.0324Z"
        fill="#E6E6E6"
      />
      <path
        d="M59.654 28.7285H42.1276C41.9673 28.7285 41.8311 28.5923 41.8311 28.432C41.8311 28.2718 41.9673 28.1355 42.1276 28.1355H59.654C59.8142 28.1355 59.9505 28.2718 59.9505 28.432C59.9505 28.5923 59.8142 28.7285 59.654 28.7285Z"
        fill="#E6E6E6"
      />
      <path
        d="M45.3014 41.4226C44.8446 41.4226 44.3958 41.1902 44.1474 40.7734L43.2097 39.2187C43.0254 38.9142 42.9693 38.5536 43.0575 38.201C43.1456 37.8484 43.362 37.5519 43.6665 37.3675L54.5574 30.7721C54.6135 30.74 54.6776 30.724 54.7417 30.732L57.779 31.0526C57.8672 31.0606 57.9473 31.1087 57.9954 31.1888C58.0435 31.2609 58.0515 31.3571 58.0274 31.4453L57.0177 34.4745C56.9936 34.5386 56.9536 34.5947 56.8895 34.6348L46.9282 40.6693C46.9282 40.6693 46.9041 40.6773 46.8961 40.6853L45.9986 41.2382C45.7822 41.3665 45.5418 41.4306 45.3014 41.4306V41.4226ZM54.7738 31.3251L43.963 37.8724C43.7948 37.9766 43.6745 38.1369 43.6184 38.3372C43.5704 38.5376 43.6024 38.7379 43.7066 38.9062L44.6442 40.4609C44.8606 40.8215 45.3254 40.9337 45.686 40.7173L46.6076 40.1484C46.6076 40.1484 46.6317 40.1323 46.6477 40.1323L56.4888 34.17L57.3463 31.5975L54.7738 31.3251V31.3251Z"
        fill="#E6E6E6"
      />
      <path
        d="M46.7838 40.7093C46.7116 40.7093 46.6395 40.6853 46.5914 40.6372C46.5674 40.6132 46.5434 40.5891 46.5273 40.5651L44.4998 37.2153C44.4117 37.079 44.4597 36.8947 44.604 36.8066C44.7402 36.7184 44.9245 36.7665 45.0127 36.9107L47.0162 40.2205C47.0562 40.2686 47.0803 40.3327 47.0803 40.4048C47.0803 40.5651 46.944 40.7013 46.7838 40.7013V40.7093Z"
        fill="#E6E6E6"
      />
      <path
        d="M56.745 34.6669C56.6489 34.6669 56.5447 34.6188 56.4886 34.5226L54.4611 31.1728C54.3729 31.0366 54.421 30.8522 54.5572 30.7641C54.6935 30.6839 54.8778 30.724 54.9659 30.8602L56.9935 34.2101C57.0816 34.3463 57.0335 34.5306 56.8973 34.6188C56.8492 34.6508 56.7931 34.6588 56.745 34.6588V34.6669Z"
        fill="#E6E6E6"
      />
      <path
        d="M45.7659 39.0344C45.6697 39.0344 45.5655 38.9863 45.5094 38.8902C45.4213 38.7539 45.4693 38.5696 45.6056 38.4815L55.5669 32.447C55.7031 32.3589 55.8874 32.4069 55.9756 32.5432C56.0637 32.6794 56.0156 32.8637 55.8794 32.9519L45.9181 38.9863C45.87 39.0184 45.8139 39.0264 45.7659 39.0264V39.0344Z"
        fill="#E6E6E6"
      />
      <path
        d="M244.543 96.1254C243.188 96.1254 242.083 95.0195 242.083 93.6652C242.083 92.3108 243.188 91.2049 244.543 91.2049C245.897 91.2049 247.003 92.3108 247.003 93.6652C247.003 95.0195 245.897 96.1254 244.543 96.1254ZM244.543 92.1025C243.685 92.1025 242.98 92.7997 242.98 93.6652C242.98 94.5307 243.677 95.2279 244.543 95.2279C245.408 95.2279 246.106 94.5307 246.106 93.6652C246.106 92.7997 245.408 92.1025 244.543 92.1025Z"
        fill="#E6E6E6"
      />
      <path
        d="M285.718 69.0304C285.469 69.0304 285.269 68.8301 285.269 68.5817V62.3549C285.269 62.1064 285.469 61.9061 285.718 61.9061C285.966 61.9061 286.167 62.1064 286.167 62.3549V68.5817C286.167 68.8301 285.966 69.0304 285.718 69.0304Z"
        fill="#E6E6E6"
      />
      <path
        d="M288.827 65.921H282.601C282.352 65.921 282.152 65.7207 282.152 65.4723C282.152 65.2238 282.352 65.0235 282.601 65.0235H288.827C289.076 65.0235 289.276 65.2238 289.276 65.4723C289.276 65.7207 289.076 65.921 288.827 65.921Z"
        fill="#E6E6E6"
      />
      <path
        d="M284.668 28.961C284.42 28.961 284.219 28.7606 284.219 28.5122V22.2854C284.219 22.0369 284.42 21.8366 284.668 21.8366C284.916 21.8366 285.117 22.0369 285.117 22.2854V28.5122C285.117 28.7606 284.916 28.961 284.668 28.961Z"
        fill="#E6E6E6"
      />
      <path
        d="M257.573 25.9397H251.346C251.098 25.9397 250.897 25.7394 250.897 25.4909C250.897 25.2425 251.098 25.0422 251.346 25.0422H257.573C257.821 25.0422 258.022 25.2425 258.022 25.4909C258.022 25.7394 257.821 25.9397 257.573 25.9397Z"
        fill="#E6E6E6"
      />
      <path
        d="M299.052 116.369H259.641C258.794 116.369 258.11 115.286 258.11 113.964C258.11 112.643 258.799 111.56 259.641 111.56H299.052C299.899 111.56 300.584 112.643 300.584 113.964C300.584 115.286 299.894 116.369 299.052 116.369ZM259.641 112.452C259.109 112.452 258.678 113.128 258.678 113.964C258.678 114.8 259.109 115.477 259.641 115.477H299.052C299.585 115.477 300.016 114.8 300.016 113.964C300.016 113.128 299.585 112.452 299.052 112.452H259.641Z"
        fill="#E6E6E6"
      />
      <path
        d="M299.67 98.3373H282.056C281.511 98.3373 281.07 97.8965 281.07 97.3516C281.07 96.8066 281.511 96.3658 282.056 96.3658H299.67C300.215 96.3658 300.656 96.8066 300.656 97.3516C300.656 97.8965 300.215 98.3373 299.67 98.3373Z"
        fill="#E6E6E6"
      />
      <path
        d="M278.353 163.987H249.847C249.102 163.987 248.493 163.378 248.493 162.625V143.407C248.493 142.654 249.102 142.045 249.847 142.045H278.353C279.098 142.045 279.707 142.654 279.707 143.407V162.625C279.707 163.378 279.098 163.987 278.353 163.987ZM249.847 142.558C249.383 142.558 249.006 142.935 249.006 143.407V162.625C249.006 163.09 249.383 163.474 249.847 163.474H278.353C278.818 163.474 279.194 163.098 279.194 162.625V143.407C279.194 142.943 278.818 142.558 278.353 142.558H249.847Z"
        fill="#E6E6E6"
      />
      <path
        d="M279.459 146.485H248.758C248.614 146.485 248.501 146.373 248.501 146.228C248.501 146.084 248.614 145.972 248.758 145.972H279.459C279.603 145.972 279.716 146.084 279.716 146.228C279.716 146.373 279.603 146.485 279.459 146.485Z"
        fill="#E6E6E6"
      />
      <path
        d="M251.675 145.339H250.048C249.904 145.339 249.792 145.227 249.792 145.082V143.455C249.792 143.311 249.904 143.199 250.048 143.199H251.675C251.82 143.199 251.932 143.311 251.932 143.455V145.082C251.932 145.227 251.82 145.339 251.675 145.339ZM250.305 144.826H251.419V143.712H250.305V144.826Z"
        fill="#E6E6E6"
      />
      <path
        d="M254.832 145.339H253.206C253.061 145.339 252.949 145.227 252.949 145.082V143.455C252.949 143.311 253.061 143.199 253.206 143.199H254.832C254.977 143.199 255.089 143.311 255.089 143.455V145.082C255.089 145.227 254.977 145.339 254.832 145.339ZM253.47 144.826H254.576V143.712H253.47V144.826Z"
        fill="#E6E6E6"
      />
      <path
        d="M257.99 145.339H256.363C256.219 145.339 256.107 145.227 256.107 145.082V143.455C256.107 143.311 256.219 143.199 256.363 143.199H257.99C258.134 143.199 258.247 143.311 258.247 143.455V145.082C258.247 145.227 258.134 145.339 257.99 145.339ZM256.62 144.826H257.734V143.712H256.62V144.826Z"
        fill="#E6E6E6"
      />
      <path
        d="M260.138 160.445C260.082 160.445 260.026 160.429 259.978 160.389L253.542 155.036C253.486 154.987 253.446 154.915 253.446 154.835C253.446 154.755 253.478 154.683 253.542 154.635L259.633 149.57C259.745 149.482 259.905 149.498 259.994 149.602C260.082 149.714 260.066 149.875 259.962 149.963L254.103 154.835L260.306 159.988C260.418 160.076 260.426 160.237 260.338 160.349C260.29 160.413 260.218 160.445 260.138 160.445V160.445Z"
        fill="#E6E6E6"
      />
      <path
        d="M268.071 160.445C267.999 160.445 267.927 160.413 267.871 160.349C267.783 160.237 267.799 160.076 267.903 159.988L274.106 154.835L268.247 149.963C268.135 149.875 268.127 149.714 268.215 149.602C268.303 149.49 268.464 149.482 268.576 149.57L274.666 154.635C274.723 154.683 274.763 154.755 274.763 154.835C274.763 154.915 274.731 154.987 274.666 155.036L268.231 160.389C268.183 160.429 268.127 160.445 268.071 160.445V160.445Z"
        fill="#E6E6E6"
      />
      <path
        d="M260.883 161.599C260.883 161.599 260.802 161.591 260.77 161.575C260.642 161.511 260.594 161.359 260.658 161.23L267.037 148.512C267.101 148.384 267.254 148.336 267.382 148.4C267.51 148.464 267.558 148.616 267.494 148.745L261.115 161.463C261.067 161.551 260.979 161.607 260.883 161.607V161.599Z"
        fill="#E6E6E6"
      />
      <path
        d="M209.963 50.6065H83.8481C79.4484 50.6065 76.0986 54.1246 76.0986 58.5242V142.277C76.0986 142.999 76.4512 144.025 77.1725 144.025H216.63C217.352 144.025 218.506 142.999 218.506 142.277V58.5242C218.506 54.1166 214.354 50.6065 209.955 50.6065H209.963ZM215.092 141.749H78.3746V58.5242C78.3746 55.5591 80.8829 54.0204 83.84 54.0204H209.955C212.912 54.0204 215.084 55.5591 215.084 58.5242V141.749H215.092Z"
        fill="#F2F2F2"
      />
      <path
        d="M85.7633 59.1173H208.055C208.777 59.1173 209.362 59.7023 209.362 60.4235V133.703C209.362 134.424 208.777 135.009 208.055 135.009H85.7633C85.042 135.009 84.457 134.424 84.457 133.703V60.4235C84.457 59.7023 85.042 59.1173 85.7633 59.1173Z"
        fill="#F2F2F2"
      />
      <g filter="url(#filter0_d_14_1273)">
        <mask
          id="path-56-outside-1_14_1273"
          maskUnits="userSpaceOnUse"
          x="110.656"
          y="81.2442"
          width="62"
          height="23"
          fill="black"
        >
          <rect fill="white" x="110.656" y="81.2442" width="62" height="23" />
          <path d="M119.471 98.3641C117.913 98.3641 116.547 98.0227 115.375 97.3399C114.217 96.6572 113.304 95.7146 112.636 94.5123C111.983 93.2951 111.656 91.8924 111.656 90.3042C111.656 88.7159 111.983 87.3207 112.636 86.1183C113.304 84.9012 114.217 83.9512 115.375 83.2684C116.547 82.5856 117.913 82.2442 119.471 82.2442C121.015 82.2442 122.373 82.5856 123.546 83.2684C124.718 83.9512 125.631 84.9012 126.284 86.1183C126.938 87.3207 127.264 88.7159 127.264 90.3042C127.264 91.8924 126.938 93.2951 126.284 94.5123C125.631 95.7146 124.718 96.6572 123.546 97.3399C122.373 98.0227 121.015 98.3641 119.471 98.3641ZM119.471 95.8037C120.956 95.8037 122.136 95.3138 123.011 94.3342C123.902 93.3545 124.347 92.0112 124.347 90.3042C124.347 88.5972 123.902 87.2539 123.011 86.2742C122.136 85.2945 120.956 84.8047 119.471 84.8047C117.987 84.8047 116.799 85.2945 115.909 86.2742C115.018 87.2539 114.573 88.5972 114.573 90.3042C114.573 92.0112 115.018 93.3545 115.909 94.3342C116.799 95.3138 117.987 95.8037 119.471 95.8037Z" />
          <path d="M134.567 98.3641C133.499 98.3641 132.534 98.1192 131.673 97.6294C130.827 97.1396 130.151 96.4642 129.647 95.6033C129.157 94.7275 128.912 93.7182 128.912 92.5752C128.912 91.4323 129.164 90.4303 129.669 89.5694C130.174 88.6937 130.849 88.0109 131.695 87.521C132.556 87.0312 133.521 86.7863 134.59 86.7863C135.644 86.7863 136.594 87.0312 137.44 87.521C138.3 88.0109 138.976 88.6937 139.466 89.5694C139.97 90.4303 140.223 91.4323 140.223 92.5752C140.223 93.7182 139.97 94.7275 139.466 95.6033C138.976 96.4642 138.3 97.1396 137.44 97.6294C136.579 98.1192 135.621 98.3641 134.567 98.3641ZM134.567 95.8927C135.31 95.8927 135.955 95.6181 136.504 95.0689C137.054 94.5049 137.328 93.6736 137.328 92.5752C137.328 91.4768 137.054 90.653 136.504 90.1038C135.955 89.5397 135.317 89.2577 134.59 89.2577C133.833 89.2577 133.18 89.5397 132.63 90.1038C132.096 90.653 131.829 91.4768 131.829 92.5752C131.829 93.6736 132.096 94.5049 132.63 95.0689C133.18 95.6181 133.825 95.8927 134.567 95.8927Z" />
          <path d="M142.326 102.995V87.0535H144.864L145.175 88.6343C145.532 88.1445 145.999 87.714 146.578 87.3429C147.172 86.9718 147.936 86.7863 148.871 86.7863C149.911 86.7863 150.838 87.0386 151.655 87.5433C152.471 88.048 153.117 88.7382 153.592 89.614C154.067 90.4897 154.304 91.4842 154.304 92.5975C154.304 93.7107 154.067 94.7052 153.592 95.581C153.117 96.4419 152.471 97.1247 151.655 97.6294C150.838 98.1192 149.911 98.3641 148.871 98.3641C148.04 98.3641 147.313 98.2083 146.69 97.8966C146.066 97.5849 145.561 97.147 145.175 96.5829V102.995H142.326ZM148.27 95.8705C149.176 95.8705 149.925 95.5662 150.519 94.9576C151.113 94.349 151.41 93.5623 151.41 92.5975C151.41 91.6327 151.113 90.8385 150.519 90.2151C149.925 89.5917 149.176 89.28 148.27 89.28C147.35 89.28 146.593 89.5917 145.999 90.2151C145.42 90.8237 145.131 91.6104 145.131 92.5752C145.131 93.54 145.42 94.3342 145.999 94.9576C146.593 95.5662 147.35 95.8705 148.27 95.8705Z" />
          <path d="M160.969 98.3641C159.989 98.3641 159.129 98.2083 158.386 97.8966C157.644 97.57 157.05 97.1247 156.605 96.5607C156.16 95.9966 155.893 95.3435 155.804 94.6013H158.676C158.765 95.0318 159.002 95.4029 159.388 95.7146C159.789 96.0115 160.301 96.1599 160.925 96.1599C161.548 96.1599 162.001 96.0337 162.283 95.7814C162.58 95.5291 162.728 95.2396 162.728 94.9131C162.728 94.4381 162.52 94.1189 162.105 93.9557C161.689 93.7775 161.11 93.6068 160.368 93.4436C159.893 93.3397 159.411 93.2135 158.921 93.0651C158.431 92.9166 157.978 92.7311 157.563 92.5084C157.162 92.2709 156.835 91.9741 156.583 91.6178C156.331 91.2467 156.204 90.794 156.204 90.2597C156.204 89.28 156.59 88.4562 157.362 87.7882C158.149 87.1203 159.247 86.7863 160.657 86.7863C161.964 86.7863 163.003 87.0906 163.774 87.6992C164.561 88.3077 165.029 89.1464 165.177 90.2151H162.483C162.32 89.3987 161.704 88.9905 160.635 88.9905C160.101 88.9905 159.685 89.0944 159.388 89.3023C159.106 89.5101 158.965 89.7698 158.965 90.0815C158.965 90.4081 159.18 90.6678 159.611 90.8608C160.041 91.0538 160.613 91.2319 161.325 91.3952C162.097 91.5733 162.802 91.7737 163.441 91.9963C164.094 92.2041 164.613 92.5233 164.999 92.9537C165.385 93.3693 165.578 93.9705 165.578 94.7572C165.593 95.44 165.415 96.056 165.044 96.6052C164.673 97.1544 164.138 97.5849 163.441 97.8966C162.743 98.2083 161.919 98.3641 160.969 98.3641Z" />
          <path d="M168.258 93.1764L167.947 82.5114H170.997L170.663 93.1764H168.258ZM169.528 98.2528C168.993 98.2528 168.555 98.0895 168.214 97.763C167.887 97.4364 167.724 97.0431 167.724 96.5829C167.724 96.1079 167.887 95.7072 168.214 95.3806C168.555 95.0541 168.993 94.8908 169.528 94.8908C170.032 94.8908 170.448 95.0541 170.774 95.3806C171.116 95.7072 171.287 96.1079 171.287 96.5829C171.287 97.0431 171.116 97.4364 170.774 97.763C170.448 98.0895 170.032 98.2528 169.528 98.2528Z" />
        </mask>
        <path
          d="M119.471 98.3641C117.913 98.3641 116.547 98.0227 115.375 97.3399C114.217 96.6572 113.304 95.7146 112.636 94.5123C111.983 93.2951 111.656 91.8924 111.656 90.3042C111.656 88.7159 111.983 87.3207 112.636 86.1183C113.304 84.9012 114.217 83.9512 115.375 83.2684C116.547 82.5856 117.913 82.2442 119.471 82.2442C121.015 82.2442 122.373 82.5856 123.546 83.2684C124.718 83.9512 125.631 84.9012 126.284 86.1183C126.938 87.3207 127.264 88.7159 127.264 90.3042C127.264 91.8924 126.938 93.2951 126.284 94.5123C125.631 95.7146 124.718 96.6572 123.546 97.3399C122.373 98.0227 121.015 98.3641 119.471 98.3641ZM119.471 95.8037C120.956 95.8037 122.136 95.3138 123.011 94.3342C123.902 93.3545 124.347 92.0112 124.347 90.3042C124.347 88.5972 123.902 87.2539 123.011 86.2742C122.136 85.2945 120.956 84.8047 119.471 84.8047C117.987 84.8047 116.799 85.2945 115.909 86.2742C115.018 87.2539 114.573 88.5972 114.573 90.3042C114.573 92.0112 115.018 93.3545 115.909 94.3342C116.799 95.3138 117.987 95.8037 119.471 95.8037Z"
          fill="#2673FF"
        />
        <path
          d="M134.567 98.3641C133.499 98.3641 132.534 98.1192 131.673 97.6294C130.827 97.1396 130.151 96.4642 129.647 95.6033C129.157 94.7275 128.912 93.7182 128.912 92.5752C128.912 91.4323 129.164 90.4303 129.669 89.5694C130.174 88.6937 130.849 88.0109 131.695 87.521C132.556 87.0312 133.521 86.7863 134.59 86.7863C135.644 86.7863 136.594 87.0312 137.44 87.521C138.3 88.0109 138.976 88.6937 139.466 89.5694C139.97 90.4303 140.223 91.4323 140.223 92.5752C140.223 93.7182 139.97 94.7275 139.466 95.6033C138.976 96.4642 138.3 97.1396 137.44 97.6294C136.579 98.1192 135.621 98.3641 134.567 98.3641ZM134.567 95.8927C135.31 95.8927 135.955 95.6181 136.504 95.0689C137.054 94.5049 137.328 93.6736 137.328 92.5752C137.328 91.4768 137.054 90.653 136.504 90.1038C135.955 89.5397 135.317 89.2577 134.59 89.2577C133.833 89.2577 133.18 89.5397 132.63 90.1038C132.096 90.653 131.829 91.4768 131.829 92.5752C131.829 93.6736 132.096 94.5049 132.63 95.0689C133.18 95.6181 133.825 95.8927 134.567 95.8927Z"
          fill="#2673FF"
        />
        <path
          d="M142.326 102.995V87.0535H144.864L145.175 88.6343C145.532 88.1445 145.999 87.714 146.578 87.3429C147.172 86.9718 147.936 86.7863 148.871 86.7863C149.911 86.7863 150.838 87.0386 151.655 87.5433C152.471 88.048 153.117 88.7382 153.592 89.614C154.067 90.4897 154.304 91.4842 154.304 92.5975C154.304 93.7107 154.067 94.7052 153.592 95.581C153.117 96.4419 152.471 97.1247 151.655 97.6294C150.838 98.1192 149.911 98.3641 148.871 98.3641C148.04 98.3641 147.313 98.2083 146.69 97.8966C146.066 97.5849 145.561 97.147 145.175 96.5829V102.995H142.326ZM148.27 95.8705C149.176 95.8705 149.925 95.5662 150.519 94.9576C151.113 94.349 151.41 93.5623 151.41 92.5975C151.41 91.6327 151.113 90.8385 150.519 90.2151C149.925 89.5917 149.176 89.28 148.27 89.28C147.35 89.28 146.593 89.5917 145.999 90.2151C145.42 90.8237 145.131 91.6104 145.131 92.5752C145.131 93.54 145.42 94.3342 145.999 94.9576C146.593 95.5662 147.35 95.8705 148.27 95.8705Z"
          fill="#2673FF"
        />
        <path
          d="M160.969 98.3641C159.989 98.3641 159.129 98.2083 158.386 97.8966C157.644 97.57 157.05 97.1247 156.605 96.5607C156.16 95.9966 155.893 95.3435 155.804 94.6013H158.676C158.765 95.0318 159.002 95.4029 159.388 95.7146C159.789 96.0115 160.301 96.1599 160.925 96.1599C161.548 96.1599 162.001 96.0337 162.283 95.7814C162.58 95.5291 162.728 95.2396 162.728 94.9131C162.728 94.4381 162.52 94.1189 162.105 93.9557C161.689 93.7775 161.11 93.6068 160.368 93.4436C159.893 93.3397 159.411 93.2135 158.921 93.0651C158.431 92.9166 157.978 92.7311 157.563 92.5084C157.162 92.2709 156.835 91.9741 156.583 91.6178C156.331 91.2467 156.204 90.794 156.204 90.2597C156.204 89.28 156.59 88.4562 157.362 87.7882C158.149 87.1203 159.247 86.7863 160.657 86.7863C161.964 86.7863 163.003 87.0906 163.774 87.6992C164.561 88.3077 165.029 89.1464 165.177 90.2151H162.483C162.32 89.3987 161.704 88.9905 160.635 88.9905C160.101 88.9905 159.685 89.0944 159.388 89.3023C159.106 89.5101 158.965 89.7698 158.965 90.0815C158.965 90.4081 159.18 90.6678 159.611 90.8608C160.041 91.0538 160.613 91.2319 161.325 91.3952C162.097 91.5733 162.802 91.7737 163.441 91.9963C164.094 92.2041 164.613 92.5233 164.999 92.9537C165.385 93.3693 165.578 93.9705 165.578 94.7572C165.593 95.44 165.415 96.056 165.044 96.6052C164.673 97.1544 164.138 97.5849 163.441 97.8966C162.743 98.2083 161.919 98.3641 160.969 98.3641Z"
          fill="#2673FF"
        />
        <path
          d="M168.258 93.1764L167.947 82.5114H170.997L170.663 93.1764H168.258ZM169.528 98.2528C168.993 98.2528 168.555 98.0895 168.214 97.763C167.887 97.4364 167.724 97.0431 167.724 96.5829C167.724 96.1079 167.887 95.7072 168.214 95.3806C168.555 95.0541 168.993 94.8908 169.528 94.8908C170.032 94.8908 170.448 95.0541 170.774 95.3806C171.116 95.7072 171.287 96.1079 171.287 96.5829C171.287 97.0431 171.116 97.4364 170.774 97.763C170.448 98.0895 170.032 98.2528 169.528 98.2528Z"
          fill="#2673FF"
        />
        <path
          d="M119.471 98.3641C117.913 98.3641 116.547 98.0227 115.375 97.3399C114.217 96.6572 113.304 95.7146 112.636 94.5123C111.983 93.2951 111.656 91.8924 111.656 90.3042C111.656 88.7159 111.983 87.3207 112.636 86.1183C113.304 84.9012 114.217 83.9512 115.375 83.2684C116.547 82.5856 117.913 82.2442 119.471 82.2442C121.015 82.2442 122.373 82.5856 123.546 83.2684C124.718 83.9512 125.631 84.9012 126.284 86.1183C126.938 87.3207 127.264 88.7159 127.264 90.3042C127.264 91.8924 126.938 93.2951 126.284 94.5123C125.631 95.7146 124.718 96.6572 123.546 97.3399C122.373 98.0227 121.015 98.3641 119.471 98.3641ZM119.471 95.8037C120.956 95.8037 122.136 95.3138 123.011 94.3342C123.902 93.3545 124.347 92.0112 124.347 90.3042C124.347 88.5972 123.902 87.2539 123.011 86.2742C122.136 85.2945 120.956 84.8047 119.471 84.8047C117.987 84.8047 116.799 85.2945 115.909 86.2742C115.018 87.2539 114.573 88.5972 114.573 90.3042C114.573 92.0112 115.018 93.3545 115.909 94.3342C116.799 95.3138 117.987 95.8037 119.471 95.8037Z"
          stroke="white"
          stroke-width="2"
          mask="url(#path-56-outside-1_14_1273)"
        />
        <path
          d="M134.567 98.3641C133.499 98.3641 132.534 98.1192 131.673 97.6294C130.827 97.1396 130.151 96.4642 129.647 95.6033C129.157 94.7275 128.912 93.7182 128.912 92.5752C128.912 91.4323 129.164 90.4303 129.669 89.5694C130.174 88.6937 130.849 88.0109 131.695 87.521C132.556 87.0312 133.521 86.7863 134.59 86.7863C135.644 86.7863 136.594 87.0312 137.44 87.521C138.3 88.0109 138.976 88.6937 139.466 89.5694C139.97 90.4303 140.223 91.4323 140.223 92.5752C140.223 93.7182 139.97 94.7275 139.466 95.6033C138.976 96.4642 138.3 97.1396 137.44 97.6294C136.579 98.1192 135.621 98.3641 134.567 98.3641ZM134.567 95.8927C135.31 95.8927 135.955 95.6181 136.504 95.0689C137.054 94.5049 137.328 93.6736 137.328 92.5752C137.328 91.4768 137.054 90.653 136.504 90.1038C135.955 89.5397 135.317 89.2577 134.59 89.2577C133.833 89.2577 133.18 89.5397 132.63 90.1038C132.096 90.653 131.829 91.4768 131.829 92.5752C131.829 93.6736 132.096 94.5049 132.63 95.0689C133.18 95.6181 133.825 95.8927 134.567 95.8927Z"
          stroke="white"
          stroke-width="2"
          mask="url(#path-56-outside-1_14_1273)"
        />
        <path
          d="M142.326 102.995V87.0535H144.864L145.175 88.6343C145.532 88.1445 145.999 87.714 146.578 87.3429C147.172 86.9718 147.936 86.7863 148.871 86.7863C149.911 86.7863 150.838 87.0386 151.655 87.5433C152.471 88.048 153.117 88.7382 153.592 89.614C154.067 90.4897 154.304 91.4842 154.304 92.5975C154.304 93.7107 154.067 94.7052 153.592 95.581C153.117 96.4419 152.471 97.1247 151.655 97.6294C150.838 98.1192 149.911 98.3641 148.871 98.3641C148.04 98.3641 147.313 98.2083 146.69 97.8966C146.066 97.5849 145.561 97.147 145.175 96.5829V102.995H142.326ZM148.27 95.8705C149.176 95.8705 149.925 95.5662 150.519 94.9576C151.113 94.349 151.41 93.5623 151.41 92.5975C151.41 91.6327 151.113 90.8385 150.519 90.2151C149.925 89.5917 149.176 89.28 148.27 89.28C147.35 89.28 146.593 89.5917 145.999 90.2151C145.42 90.8237 145.131 91.6104 145.131 92.5752C145.131 93.54 145.42 94.3342 145.999 94.9576C146.593 95.5662 147.35 95.8705 148.27 95.8705Z"
          stroke="white"
          stroke-width="2"
          mask="url(#path-56-outside-1_14_1273)"
        />
        <path
          d="M160.969 98.3641C159.989 98.3641 159.129 98.2083 158.386 97.8966C157.644 97.57 157.05 97.1247 156.605 96.5607C156.16 95.9966 155.893 95.3435 155.804 94.6013H158.676C158.765 95.0318 159.002 95.4029 159.388 95.7146C159.789 96.0115 160.301 96.1599 160.925 96.1599C161.548 96.1599 162.001 96.0337 162.283 95.7814C162.58 95.5291 162.728 95.2396 162.728 94.9131C162.728 94.4381 162.52 94.1189 162.105 93.9557C161.689 93.7775 161.11 93.6068 160.368 93.4436C159.893 93.3397 159.411 93.2135 158.921 93.0651C158.431 92.9166 157.978 92.7311 157.563 92.5084C157.162 92.2709 156.835 91.9741 156.583 91.6178C156.331 91.2467 156.204 90.794 156.204 90.2597C156.204 89.28 156.59 88.4562 157.362 87.7882C158.149 87.1203 159.247 86.7863 160.657 86.7863C161.964 86.7863 163.003 87.0906 163.774 87.6992C164.561 88.3077 165.029 89.1464 165.177 90.2151H162.483C162.32 89.3987 161.704 88.9905 160.635 88.9905C160.101 88.9905 159.685 89.0944 159.388 89.3023C159.106 89.5101 158.965 89.7698 158.965 90.0815C158.965 90.4081 159.18 90.6678 159.611 90.8608C160.041 91.0538 160.613 91.2319 161.325 91.3952C162.097 91.5733 162.802 91.7737 163.441 91.9963C164.094 92.2041 164.613 92.5233 164.999 92.9537C165.385 93.3693 165.578 93.9705 165.578 94.7572C165.593 95.44 165.415 96.056 165.044 96.6052C164.673 97.1544 164.138 97.5849 163.441 97.8966C162.743 98.2083 161.919 98.3641 160.969 98.3641Z"
          stroke="white"
          stroke-width="2"
          mask="url(#path-56-outside-1_14_1273)"
        />
        <path
          d="M168.258 93.1764L167.947 82.5114H170.997L170.663 93.1764H168.258ZM169.528 98.2528C168.993 98.2528 168.555 98.0895 168.214 97.763C167.887 97.4364 167.724 97.0431 167.724 96.5829C167.724 96.1079 167.887 95.7072 168.214 95.3806C168.555 95.0541 168.993 94.8908 169.528 94.8908C170.032 94.8908 170.448 95.0541 170.774 95.3806C171.116 95.7072 171.287 96.1079 171.287 96.5829C171.287 97.0431 171.116 97.4364 170.774 97.763C170.448 98.0895 170.032 98.2528 169.528 98.2528Z"
          stroke="white"
          stroke-width="2"
          mask="url(#path-56-outside-1_14_1273)"
        />
      </g>
      <path
        d="M216.638 156.398H77.1722C71.8109 156.398 67.4434 152.936 67.4434 148.681V142.277C67.4434 141.556 68.0284 140.971 68.7496 140.971H225.053C225.774 140.971 226.359 141.556 226.359 142.277V148.681C226.359 152.936 221.999 156.398 216.638 156.398ZM70.0559 143.584V148.681C70.0559 151.445 73.3175 153.785 77.1722 153.785H216.638C220.493 153.785 223.746 151.445 223.746 148.681V143.584H70.0559Z"
        fill="#F2F2F2"
      />
      <path
        d="M146.901 152.792C144.641 152.792 142.798 150.949 142.798 148.681C142.798 146.413 144.641 144.577 146.901 144.577C149.161 144.577 151.012 146.421 151.012 148.681C151.012 150.941 149.169 152.792 146.901 152.792ZM146.901 147.198C146.084 147.198 145.41 147.863 145.41 148.689C145.41 149.514 146.076 150.187 146.901 150.187C147.726 150.187 148.4 149.514 148.4 148.689C148.4 147.863 147.726 147.198 146.901 147.198Z"
        fill="#F2F2F2"
      />
      <g filter="url(#filter1_d_14_1273)">
        <path
          d="M109.205 116.489C102.449 109.252 91.0614 108.851 83.8169 115.615C76.5803 122.371 76.1796 133.759 82.9434 141.003C89.6991 148.24 101.087 148.64 108.331 141.877C115.568 135.121 115.969 123.733 109.205 116.489ZM105.19 138.511C99.8046 143.535 91.3339 143.247 86.3092 137.862C81.2845 132.476 81.573 124.006 86.9583 118.981C92.3437 113.956 100.814 114.245 105.839 119.63C110.864 125.015 110.575 133.486 105.19 138.511Z"
          fill="white"
        />
        <path
          d="M110.542 128.739C110.642 120.852 104.331 114.378 96.4443 114.277C88.5579 114.177 82.0832 120.489 81.9827 128.375C81.8822 136.261 88.194 142.736 96.0804 142.836C103.967 142.937 110.441 136.625 110.542 128.739Z"
          fill="#F2F2F2"
        />
        <path
          opacity="0.35"
          d="M87.0466 129.455C87.8566 129.455 88.5132 128.798 88.5132 127.989C88.5132 127.179 87.8566 126.522 87.0466 126.522C86.2367 126.522 85.5801 127.179 85.5801 127.989C85.5801 128.798 86.2367 129.455 87.0466 129.455Z"
          fill="white"
        />
        <path
          d="M108.46 116.665C101.888 109.925 91.1018 109.789 84.3621 116.36C77.6224 122.932 77.4862 133.718 84.0576 140.458C90.629 147.198 101.416 147.334 108.155 140.763C114.895 134.191 115.031 123.405 108.46 116.665ZM86.037 138.527C80.5314 132.877 80.6436 123.837 86.2934 118.332C91.9432 112.826 100.983 112.938 106.488 118.588C111.994 124.238 111.882 133.278 106.232 138.783C100.582 144.289 91.5425 144.177 86.037 138.527Z"
          fill="#CCCCCC"
        />
        <path
          d="M63.7582 160.244C62.1474 158.594 62.1794 155.957 63.8303 154.346L76.1477 142.341L81.9738 148.32L69.6564 160.325C68.0055 161.935 65.369 161.903 63.7582 160.252V160.244Z"
          fill="#CCCCCC"
        />
        <path
          d="M85.8366 142.869L81.6802 138.605C80.8337 137.737 79.4435 137.719 78.5751 138.566L76.2166 140.865C75.3483 141.711 75.3306 143.101 76.1771 143.97L80.3334 148.234C81.18 149.102 82.5702 149.12 83.4385 148.273L85.797 145.974C86.6654 145.127 86.6831 143.737 85.8366 142.869Z"
          fill="#FFFFFD"
        />
      </g>
      <defs>
        <filter
          id="filter0_d_14_1273"
          x="110.656"
          y="81.2442"
          width="62.6304"
          height="24.7511"
          filterUnits="userSpaceOnUse"
          color-interpolation-filters="sRGB"
        >
          <feFlood flood-opacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dx="1" dy="2" />
          <feComposite in2="hardAlpha" operator="out" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0.757726 0 0 0 0 0.795391 0 0 0 0 0.895833 0 0 0 1 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_14_1273"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect1_dropShadow_14_1273"
            result="shape"
          />
        </filter>
        <filter
          id="filter1_d_14_1273"
          x="58.5708"
          y="106.791"
          width="63.4585"
          height="62.7211"
          filterUnits="userSpaceOnUse"
          color-interpolation-filters="sRGB"
        >
          <feFlood flood-opacity="0" result="BackgroundImageFix" />
          <feColorMatrix
            in="SourceAlpha"
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
            result="hardAlpha"
          />
          <feOffset dx="2" dy="2" />
          <feGaussianBlur stdDeviation="3" />
          <feColorMatrix
            type="matrix"
            values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.2 0"
          />
          <feBlend
            mode="normal"
            in2="BackgroundImageFix"
            result="effect1_dropShadow_14_1273"
          />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="effect1_dropShadow_14_1273"
            result="shape"
          />
        </filter>
      </defs>
    </svg>
  );
};
