<?php
/**
 * Lupr admin notify
 *
 */
if ( !defined( 'ABSPATH' ) ) {
	exit;
}

if ( !class_exists( 'Lupr_Notify_Admin' ) ) :

	/**
	 * The Lupr admin notify
	 */
	class Lupr_Notify_Admin {

		/**
		 * Setup class.
		 *
		 */
		public function __construct() {

			add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
			add_action( 'admin_notices', array( $this, 'admin_notices' ), 99 );
			add_action( 'wp_ajax_lupr_dismiss_notice', array( $this, 'dismiss_nux' ) );
			add_action( 'admin_menu', array( $this, 'add_menu' ), 5 );
		}

		/**
		 * Enqueue scripts.
		 *
		 */
		public function enqueue_scripts() {
			global $wp_customize;

			if ( isset( $wp_customize ) || lupr_envo_extra_is_activated() ) {
				return;
			}

			wp_enqueue_style( 'lupr-admin', get_template_directory_uri() . '/assets/css/admin/admin.css', '', '1' );

			wp_enqueue_script( 'lupr-admin', get_template_directory_uri() . '/assets/js/admin/admin.js', array( 'jquery', 'updates' ), '1', 'all' );

			$lupr_notify = array(
				'nonce' => wp_create_nonce( 'lupr_notice_dismiss' )
			);

			wp_localize_script( 'lupr-admin', 'lupr_ux', $lupr_notify );
		}

		/**
		 * Output admin notices.
		 *
		 */
		public function admin_notices() {
			global $pagenow;

			if ( ( 'themes.php' === $pagenow ) && isset( $_GET[ 'page' ] ) && ( 'lupr' === $_GET[ 'page' ] ) || true === (bool) get_option( 'lupr_notify_dismissed' ) || lupr_envo_extra_is_activated() ) {
				return;
			}
			?>

			<div class="notice notice-info lupr-notice is-dismissible">

				<div class="notice-content">
					<?php if ( !lupr_envo_extra_is_activated() && current_user_can( 'install_plugins' ) && current_user_can( 'activate_plugins' ) ) : ?>
						<h2>
							<?php
							/* translators: %s: Theme name */
							printf( esc_html__( 'Thank you for installing %s.', 'lupr' ), '<strong>Lupr</strong>' );
							?>
						</h2>
						<p>
							<?php
							/* translators: %s: Plugin name string */
							printf( esc_html__( 'To take full advantage of all the features this theme has to offer, please install and activate the %s plugin.', 'lupr' ), '<strong>Envo Extra</strong>' );
							?>
						</p>
						<p>
							<a href="<?php echo esc_url( admin_url( 'themes.php?page=lupr' ) ); ?>" class="button button-primary button-hero">
								<?php
								/* translators: %s: Theme name */
								printf( esc_html__( 'Get started with %s', 'lupr' ), 'Lupr' );
								?>
							</a>
						</p>
					<?php endif; ?>
				</div>
			</div>
			<?php
		}

		public function add_menu() {
			if ( isset( $wp_customize ) || lupr_envo_extra_is_activated() ) {
				return;
			}
			add_theme_page(
			'Lupr', 'Lupr', 'edit_theme_options', 'lupr', array( $this, 'admin_page' )
			);
		}

		public function admin_page() {


			if ( lupr_envo_extra_is_activated() ) {
				return;
			}
			?>

			<div class="notice notice-info lupr-notice-nux">

				<div class="notice-content">
					<?php if ( !lupr_envo_extra_is_activated() && current_user_can( 'install_plugins' ) && current_user_can( 'activate_plugins' ) ) : ?>
						<h2>
							<?php
							/* translators: %s: Theme name */
							printf( esc_html__( 'Thank you for installing %s.', 'lupr' ), '<strong>Lupr</strong>' );
							?>
						</h2>
						<p>
							<?php
							/* translators: %s: Plugin name string */
							printf( esc_html__( 'To take full advantage of all the features this theme has to offer, please install and activate the %s plugin.', 'lupr' ), '<strong>Envo Extra</strong>' );
							?>
						</p>
						<p><?php Lupr_Plugin_Install::install_plugin_button( 'envo-extra', 'envo-extra.php', 'Envo Extra', array( 'lupr-nux-button' ), __( 'Activated', 'lupr' ), __( 'Activate', 'lupr' ), __( 'Install', 'lupr' ) ); ?></p>
					<?php endif; ?>


				</div>
			</div>
			<?php
		}

		/**
		 * AJAX dismiss notice.
		 *
		 * @since 2.2.0
		 */
		public function dismiss_nux() {
			$nonce = !empty( $_POST[ 'nonce' ] ) ? sanitize_text_field( wp_unslash( $_POST[ 'nonce' ] ) ) : false;

			if ( !$nonce || !wp_verify_nonce( $nonce, 'lupr_notice_dismiss' ) || !current_user_can( 'manage_options' ) ) {
				die();
			}

			update_option( 'lupr_notify_dismissed', true );
		}

	}

	endif;

return new Lupr_Notify_Admin();
