<?php


define( 'LUPR_VERSION', wp_get_theme()->get( 'Version' ) );

/**
 * Add theme support for block styles and editor style.
 */
function lupr_setup() {
	add_editor_style( './assets/css/block-styles.css' );

	$styled_blocks = [ 'button', 'latest-comments', 'latest-posts', 'quote' ];
	foreach ( $styled_blocks as $block_name ) {
		$args = array(
			'handle' => "lupr-$block_name",
			'src'    => get_theme_file_uri( "assets/css/blocks-css/$block_name.min.css" ),
			'path'   => get_theme_file_path( "assets/css/blocks-css/$block_name.min.css" ),
		);
		wp_enqueue_block_style( "core/$block_name", $args );
	}

}
add_action( 'after_setup_theme', 'lupr_setup' );

/**
 * Enqueue the CSS files.
 */
function lupr_styles() {
	wp_enqueue_style(
		'lupr-style',
		get_stylesheet_uri(),
		[],
		LUPR_VERSION
	);
	wp_enqueue_style(
		'lupr-block-styles',
		get_theme_file_uri( 'assets/css/block-styles.css' ),
		[],
		LUPR_VERSION
	);
}
add_action( 'wp_enqueue_scripts', 'lupr_styles' );

// Block style examples.
require_once get_theme_file_path( 'include/register-block-styles.php' );

// Setup block patterns
require_once get_theme_file_path( '/include/register-block-patterns.php' );

if ( !function_exists( 'lupr_envo_extra_is_activated' ) ) {

	/**
	 * Query Lupr extra activation
	 */
	function lupr_envo_extra_is_activated() {
		return defined( 'ENVO_EXTRA_CURRENT_VERSION' ) ? true : false;
	}

}

/**
 * Register Theme Info Page
 */
require_once( trailingslashit(get_template_directory()) . 'lib/lupr-dashboard.php' );
if ( is_admin() ) {
	require_once( trailingslashit( get_template_directory() ) . 'lib/lupr-plugin-install.php' );
}

/**
 * Customizer options
 */
require_once( trailingslashit(get_template_directory()) . 'lib/customizer-recommend.php' );