<?php

namespace DMS\Includes\Frontend;

use DMS\Includes\Data_Objects\Mapping_Value;
use DMS\Includes\Utils\Helper;
use WP_Query;

class Mapper_Factory {

	/**
	 * Create Mapper instance by mapping value
	 *
	 * @param Mapping_Value $mapping_value Mapping value instance
	 * @param WP_Query $query WP_Query instance
	 *
	 * @return mixed|null
	 */
	public function make( Mapping_Value $mapping_value, WP_Query $query) {
		if (Helper::get_shop_page_association() === $mapping_value->object_id && $mapping_value->object_type === 'post') {
			$mapping_type = 'Shop';
		} else {
			$mapping_type = ucfirst( $mapping_value->object_type );
		}
		$class        = 'DMS\\Includes\\Frontend\\Mapping_Objects\\' . $mapping_type . '_Mapper';
		if ( class_exists( $class ) ) {
			return (new $class( $mapping_value, $query ));
		}
		return null;
	}
}