<?php

/**
 * The header for our theme
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package home_decor_store
 */

$home_decor_store_menu_text_transform = get_theme_mod( 'home_decor_store_menu_text_transform', 'capitalize' );
$home_decor_store_menu_text_transform_css = ( $home_decor_store_menu_text_transform !== 'capitalize' ) ? 'text-transform: ' . $home_decor_store_menu_text_transform . ';' : '';
$home_decor_store_menu_text_color = get_theme_mod('home_decor_store_menu_text_color', '#5d5d5d'); 
$home_decor_store_sub_menu_text_color = get_theme_mod('home_decor_store_sub_menu_text_color', 'var(--background-color-white)'); 
?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>

<body <?php body_class(get_theme_mod('home_decor_store_website_layout', false) ? 'site-boxed--layout' : ''); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site asterthemes-site-wrapper">
<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'home-decor-store' ); ?></a>
    <?php if (get_theme_mod('home_decor_store_enable_preloader', false)) : ?>
        <div id="loader" class="<?php echo esc_attr(get_theme_mod('home_decor_store_preloader_style', 'style1')); ?>">
            <div class="loader-container">
                <div id="preloader">
                    <?php 
                    $preloader_style = get_theme_mod('home_decor_store_preloader_style', 'style1');
                    if ($preloader_style === 'style1') : ?>
                        <!-- STYLE 1 -->
                        <img src="<?php echo esc_url(get_template_directory_uri() . '/resource/loader.gif'); ?>" alt="<?php esc_attr_e('Loading...', 'home-decor-store'); ?>">
                    <?php elseif ($preloader_style === 'style2') : ?>
                        <!-- STYLE 2 -->
                        <div class="dot"></div>
                    <?php elseif ($preloader_style === 'style3') : ?>
                        <!-- STYLE 3 -->
                        <div class="bars">
                            <div class="bar"></div>
                            <div class="bar"></div>
                            <div class="bar"></div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endif; ?>
<header id="masthead" class="site-header">
	<div class="header-main-wrapper">
        <div class="bottom-header-outer-wrapper">
            <div class="bottom-header-part">
                <div class="asterthemes-wrapper">
                    <div class="bottom-header-part-wrapper">
                        <div class="bottom-header-left-part header-nav">
                            <div class="toggle-btn">
                                <a href="#" id="sidebar-pop"><i class="fas fa-bars"></i></a>
                            </div>
                            <div class="toggle-sidebar">
                                <div class="close-btn"><a href="#maincontent"><i class="fas fa-window-close"></i></a>
                                </div>
                                <div class="site-branding">
                                    <?php
                                    // Check if the 'Enable Site Logo' setting is true.
                                    if ( get_theme_mod( 'home_decor_store_enable_site_logo', true ) ) {
                                        if ( has_custom_logo() ) { ?>
                                            <div class="site-logo">
                                                <?php the_custom_logo(); ?>
                                            </div>
                                        <?php } else { ?>
                                            <div class="site-logo">
                                                <!-- Fallback logo if no custom logo is set -->
                                                <a href="<?php echo esc_url(home_url('/')); ?>" rel="home">
                                                    <img src="<?php echo esc_url(get_template_directory_uri() . '/resource/img/logo.png'); ?>" alt="<?php bloginfo('name'); ?>">
                                                </a>
                                            </div>
                                        <?php }
                                    } ?>
                                    <div class="site-identity">
                                        <?php
                                        $home_decor_store_site_title_size = get_theme_mod('home_decor_store_site_title_size', 30);

                                        if (get_theme_mod('home_decor_store_enable_site_title_setting', false)) {
                                            if (is_front_page() && is_home()) : ?>
                                                <h1 class="site-title" style="font-size: <?php echo esc_attr($home_decor_store_site_title_size); ?>px;">
                                                    <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
                                                </h1>
                                            <?php else : ?>
                                                <p class="site-title" style="font-size: <?php echo esc_attr($home_decor_store_site_title_size); ?>px;">
                                                    <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
                                                </p>
                                            <?php endif;
                                        }

                                        if (get_theme_mod('home_decor_store_enable_tagline_setting', false)) :
                                            $home_decor_store_description = get_bloginfo('description', 'display');
                                            if ($home_decor_store_description || is_customize_preview()) : ?>
                                                <p class="site-description"><?php echo esc_html($home_decor_store_description); ?></p>
                                            <?php endif;
                                        endif;
                                        ?>
                                    </div>
                                </div>
                                <?php if ( get_theme_mod( 'home_decor_store_enable_search_icon', true ) === true ) { ?>
                                    <span class="head-search">
                                        <?php echo get_search_form(); ?>
                                    </span> 
                                <?php }?>
                                <div class="socail-search">
                                    <div class="social-icons">
                                        <?php
                                        if ( has_nav_menu( 'social' ) ) {
                                            wp_nav_menu(
                                                array(
                                                    'menu_class'     => 'menu social-links',
                                                    'link_before'    => '<span class="screen-reader-text">',
                                                    'link_after'     => '</span>',
                                                    'theme_location' => 'social',
                                                )
                                            );
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <div class="navigation-part hello <?php echo esc_attr( get_theme_mod( 'home_decor_store_enable_sticky_header', false ) ? 'sticky-header' : '' ); ?>">
                                <nav id="site-navigation" class="main-navigation">
                                    <button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                    </button>
                                    <div class="main-navigation-links" style="<?php echo esc_attr( $home_decor_store_menu_text_transform_css ); ?>">
                                        <?php
                                            wp_nav_menu(
                                                array(
                                                    'theme_location' => 'primary',
                                                )
                                            );
                                        ?>
                                    </div>
                                    <style>
                                        /* Main Menu Links */
                                        .main-navigation ul li a, .menu a {
                                            color: <?php echo esc_attr($home_decor_store_menu_text_color); ?>;
                                        }

                                        /* Submenu Links */
                                        .main-navigation ul.children a, 
                                        .home .main-navigation ul.children a, 
                                        .main-navigation ul.menu li .sub-menu a, 
                                        .home .main-navigation ul ul a {
                                            color: <?php echo esc_attr($home_decor_store_sub_menu_text_color); ?>;
                                        }
                                    </style>
                                </nav>
                            </div>
                        </div>
                        <div class="bottom-header-middle-part">
                            <div class="site-branding">
                                <?php
                                // Check if the 'Enable Site Logo' setting is true.
                                if ( get_theme_mod( 'home_decor_store_enable_site_logo', true ) ) {
                                    if ( has_custom_logo() ) { ?>
                                        <div class="site-logo">
                                            <?php the_custom_logo(); ?>
                                        </div>
                                    <?php } else { ?>
                                        <div class="site-logo">
                                            <!-- Fallback logo if no custom logo is set -->
                                            <a href="<?php echo esc_url(home_url('/')); ?>" rel="home">
                                                <img src="<?php echo esc_url(get_template_directory_uri() . '/resource/img/logo.png'); ?>" alt="<?php bloginfo('name'); ?>">
                                            </a>
                                        </div>
                                    <?php }
                                } ?>
                                <div class="site-identity">
                                    <?php
                                    $home_decor_store_site_title_size = get_theme_mod('home_decor_store_site_title_size', 30);

                                    if (get_theme_mod('home_decor_store_enable_site_title_setting', false)) {
                                        if (is_front_page() && is_home()) : ?>
                                            <h1 class="site-title" style="font-size: <?php echo esc_attr($home_decor_store_site_title_size); ?>px;">
                                                <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
                                            </h1>
                                        <?php else : ?>
                                            <p class="site-title" style="font-size: <?php echo esc_attr($home_decor_store_site_title_size); ?>px;">
                                                <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
                                            </p>
                                        <?php endif;
                                    }

                                    if (get_theme_mod('home_decor_store_enable_tagline_setting', false)) :
                                        $home_decor_store_description = get_bloginfo('description', 'display');
                                        if ($home_decor_store_description || is_customize_preview()) : ?>
                                            <p class="site-description"><?php echo esc_html($home_decor_store_description); ?></p>
                                        <?php endif;
                                    endif;
                                    ?>
                                </div>
                            </div>
                            </div>
                        <div class="bottom-header-right-part">
                            <?php if ( get_theme_mod( 'home_decor_store_enable_search_icon', true ) === true ) { ?>
                                <span class="head-search">
                                    <?php echo get_search_form(); ?>
                                </span> 
                            <?php }?>
                            <?php $home_decor_store_header_wishlist_url = get_theme_mod( 'home_decor_store_header_wishlist_url'); ?>
                            <?php if ( ! empty( $home_decor_store_header_wishlist_url ) ) { ?>
                                <span class="head-wishlist">
                                    <a href="<?php echo esc_url( $home_decor_store_header_wishlist_url ) ?>">
                                        <i class="<?php echo esc_attr( get_theme_mod( 'home_decor_store_User_wish_icon_c', 'far fa-heart' ) ); ?>"></i></a>
                                </span>
                            <?php }?>
                            <?php if(class_exists('woocommerce')){ ?>
                                <div class="user-account">
                                    <?php if ( is_user_logged_in() ) { ?>
                                        <a href="<?php echo esc_url( get_permalink( get_option('woocommerce_myaccount_page_id') ) ); ?>" title="<?php esc_attr_e('My Account','home-decor-store'); ?>">
                                            <i class="<?php echo esc_attr( get_theme_mod( 'home_decor_store_User_Log_icon_c', 'fas fa-sign-out-alt' ) ); ?>"></i></a>
                                    <?php } 
                                    else { ?>
                                        <a href="<?php echo esc_url( get_permalink( get_option('woocommerce_myaccount_page_id') ) ); ?>" title="<?php esc_attr_e('Login / Register','home-decor-store'); ?>">
                                            <i class="<?php echo esc_attr( get_theme_mod( 'home_decor_store_User_cart_icon_c', 'fas fa-user' ) ); ?>"></i></a>
                                    <?php } ?>
                                </div>
                            <?php }?>
                            <?php if ( class_exists( 'woocommerce' ) ) {?>
                                <a class="cart-customlocation" href="<?php if(function_exists('wc_get_cart_url')){ echo esc_url(wc_get_cart_url()); } ?>" title="<?php esc_attr_e( 'View Shopping Cart','home-decor-store' ); ?>"><i class="<?php echo esc_attr( get_theme_mod( 'home_decor_store_shopping_cart_icon_c', 'fas fa-shopping-basket' ) ); ?>"></i> <span class="cart-item-box"><?php echo esc_html(wp_kses_data( WC()->cart->get_cart_contents_count() ));?></span></a>
                            <?php }?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>
<?php
    if ( ! is_front_page() || is_home() ) {
        if ( is_front_page() ) {
            require get_template_directory() . '/sections/sections.php';
            home_decor_store_homepage_sections();

        }
	?>
    <?php
        if (!is_front_page() || is_home()) {
            get_template_part('page-header');
        }
    ?>
	<div id="content" class="site-content">
		<div class="asterthemes-wrapper">
			<div class="asterthemes-page">
			<?php } ?>