<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! home_decor_store_has_page_header() ) {
    return;
}

$home_decor_store_classes = array( 'page-header' );
$home_decor_store_style = home_decor_store_page_header_style();

if ( $home_decor_store_style ) {
    $home_decor_store_classes[] = $home_decor_store_style . '-page-header';
}

$home_decor_store_visibility = get_theme_mod( 'home_decor_store_page_header_visibility', 'all-devices' );

if ( 'hide-all-devices' === $home_decor_store_visibility ) {
    // Don't show the header at all
    return;
}

if ( 'hide-tablet' === $home_decor_store_visibility ) {
    $home_decor_store_classes[] = 'hide-on-tablet';
} elseif ( 'hide-mobile' === $home_decor_store_visibility ) {
    $home_decor_store_classes[] = 'hide-on-mobile';
} elseif ( 'hide-tablet-mobile' === $home_decor_store_visibility ) {
    $home_decor_store_classes[] = 'hide-on-tablet-mobile';
}

$home_decor_store_PAGE_TITLE_background_color = get_theme_mod('home_decor_store_page_title_background_color_setting', '');

// Get the toggle switch value
$home_decor_store_background_image_enabled = get_theme_mod('home_decor_store_page_header_style', true);

// Add background image to the header if enabled
$home_decor_store_background_image = get_theme_mod( 'home_decor_store_page_header_background_image', '' );
$home_decor_store_background_height = get_theme_mod( 'home_decor_store_page_header_image_height', '200' );
$home_decor_store_inline_style = '';

if ( $home_decor_store_background_image_enabled && ! empty( $home_decor_store_background_image ) ) {
    $home_decor_store_inline_style .= 'background-image: url(' . esc_url( $home_decor_store_background_image ) . '); ';
    $home_decor_store_inline_style .= 'height: ' . esc_attr( $home_decor_store_background_height ) . 'px; ';
    $home_decor_store_inline_style .= 'background-size: cover; ';
    $home_decor_store_inline_style .= 'background-position: center center; ';

    // Add the unique class if the background image is set
    $home_decor_store_classes[] = 'has-background-image';
}

$home_decor_store_classes = implode( ' ', $home_decor_store_classes );
$home_decor_store_heading = get_theme_mod( 'home_decor_store_page_header_heading_tag', 'h1' );
$home_decor_store_heading = apply_filters( 'home_decor_store_page_header_heading', $home_decor_store_heading );

?>

<?php do_action( 'home_decor_store_before_page_header' ); ?>

<header class="<?php echo esc_attr( $home_decor_store_classes ); ?>" style="<?php echo esc_attr( $home_decor_store_inline_style ); ?> background-color: <?php echo esc_attr($home_decor_store_PAGE_TITLE_background_color); ?>;">

    <?php do_action( 'home_decor_store_before_page_header_inner' ); ?>

    <div class="asterthemes-wrapper page-header-inner">

        <?php if ( home_decor_store_has_page_header() ) : ?>

            <<?php echo esc_attr( $home_decor_store_heading ); ?> class="page-header-title">
                <?php echo wp_kses_post( home_decor_store_get_page_title() ); ?>
            </<?php echo esc_attr( $home_decor_store_heading ); ?>>

        <?php endif; ?>

        <?php if ( function_exists( 'home_decor_store_breadcrumb' ) ) : ?>
            <?php home_decor_store_breadcrumb(); ?>
        <?php endif; ?>

    </div><!-- .page-header-inner -->

    <?php do_action( 'home_decor_store_after_page_header_inner' ); ?>

</header><!-- .page-header -->

<?php do_action( 'home_decor_store_after_page_header' ); ?>