<?php
if ( ! get_theme_mod( 'home_decor_store_enable_banner_section', true ) ) {
	return;
}

$home_decor_store_slider_content_ids  = array();
$home_decor_store_slider_content_type = get_theme_mod( 'home_decor_store_banner_slider_content_type', 'post' );

for ( $i = 1; $i <= 3; $i++ ) {
	$home_decor_store_slider_content_ids[] = get_theme_mod( 'home_decor_store_banner_slider_content_' . $home_decor_store_slider_content_type . '_' . $i );
}

// Get the category for the banner slider from theme mods or a default category
$home_decor_store_banner_slider_category = get_theme_mod('home_decor_store_banner_slider_category', 'Banner');

// Modify query to fetch posts from a specific category
$home_decor_store_banner_slider_args = array(
    'post_type'           => $home_decor_store_slider_content_type,
    'post__in'            => array_filter( $home_decor_store_slider_content_ids ),
    'orderby'             => 'post__in',
    'posts_per_page'      => absint(3),
    'ignore_sticky_posts' => true,
);

// Apply category filter only if content type is 'post'
if ( 'post' === $home_decor_store_slider_content_type && ! empty( $home_decor_store_banner_slider_category ) ) {
    $home_decor_store_banner_slider_args['category_name'] = $home_decor_store_banner_slider_category;
}

$home_decor_store_banner_slider_args = apply_filters( 'home_decor_store_banner_section_args', $home_decor_store_banner_slider_args );

home_decor_store_render_banner_section( $home_decor_store_banner_slider_args );

/**
 * Render Banner Section.
 */
function home_decor_store_render_banner_section( $home_decor_store_banner_slider_args ) {     ?>

	<section id="home_decor_store_banner_section" class="banner-section banner-style-1">
		<?php
		if ( is_customize_preview() ) :
			home_decor_store_section_link( 'home_decor_store_banner_section' );
		endif;
		?>
		<div class="banner-section-wrapper">
			<?php
			$home_decor_store_query = new WP_Query( $home_decor_store_banner_slider_args );
			if ( $home_decor_store_query->have_posts() ) :
				?>
				<div class="asterthemes-banner-wrapper banner-slider home-decor-store-carousel-navigation" data-slick='{"autoplay": false }'>
					<?php
					$i = 1;
					while ( $home_decor_store_query->have_posts() ) :
						$home_decor_store_query->the_post();
						$home_decor_store_button_label = get_theme_mod( 'home_decor_store_banner_button_label_' . $i, '' );
						$home_decor_store_button_link  = get_theme_mod( 'home_decor_store_banner_button_link_' . $i, '' );
						$home_decor_store_button_link  = ! empty( $home_decor_store_button_link ) ? $home_decor_store_button_link : get_the_permalink();
						?>
						<div class="banner-single-outer">
							<div class="banner-single">
								<div class="banner-img">
									<?php the_post_thumbnail( 'full' ); ?>
								</div>
								<div class="banner-caption">
									<div class="asterthemes-wrapper">
										<div class="banner-catption-wrapper">
											<div class="mag-post-excerpt">
												<?php the_excerpt(); ?>
											</div>
											<h1 class="banner-caption-title">
												<?php the_title(); ?>
											</h1>
											<?php if ( ! empty( $home_decor_store_button_label ) ) { ?>
												<div class="banner-slider-btn">
													<a href="<?php echo esc_url( $home_decor_store_button_link ); ?>" class="asterthemes-button"><?php echo esc_html( $home_decor_store_button_label ); ?></a>
												</div>
											<?php } ?>
										</div>
									</div>
								</div>
							</div>
						</div>
						<?php
						$i++;
					endwhile;
					wp_reset_postdata();
					?>
				</div>
				<?php
			endif;
			?>
		</div>
	</section>
	<?php
}