<?php

if ( ! get_theme_mod( 'home_decor_store_enable_service_section', false ) ) {
  return;
}

$home_decor_store_content_ids  = array();
$home_decor_store_content_type = get_theme_mod( 'home_decor_store_service_content_type', 'post' );

for ( $home_decor_store_i = 1; $home_decor_store_i <= 8; $home_decor_store_i++ ) {
  $home_decor_store_content_ids[] = get_theme_mod( 'home_decor_store_service_content_' . $home_decor_store_content_type . '_' . $home_decor_store_i );
}

// Get the category for the services slider from theme mods or a default category
$home_decor_store_services_category = get_theme_mod('home_decor_store_services_category', 'services');

// Modify query to fetch posts from a specific category
$home_decor_store_services_args = array(
    'post_type'           => $home_decor_store_content_type,
    'post__in'            => array_filter( $home_decor_store_content_ids ),
    'orderby'             => 'post__in',
    'posts_per_page'      => absint(4),
    'ignore_sticky_posts' => true,
);

// Apply category filter only if content type is 'post'
if ( 'post' === $home_decor_store_content_type && ! empty( $home_decor_store_services_category ) ) {
    $home_decor_store_services_args['category_name'] = $home_decor_store_services_category;
}

$home_decor_store_services_args = apply_filters( 'home_decor_store_service_section_args', $home_decor_store_services_args );

home_decor_store_render_service_section( $home_decor_store_services_args );

/**
 * Render Service Section.
 */
function home_decor_store_render_service_section( $home_decor_store_services_args ) { ?>

  <section id="home_decor_store_service_section" class="asterthemes-frontpage-section service-section service-style-1">
    <?php
    if ( is_customize_preview() ) :
      home_decor_store_section_link( 'home_decor_store_service_section' );
    endif;

    $home_decor_store_trending_product_heading = get_theme_mod( 'home_decor_store_trending_product_heading');
      $home_decor_store_trending_product_content = get_theme_mod( 'home_decor_store_trending_product_content');
    ?>
    <div class="asterthemes-wrapper">
      
      <div class="product-contact-inner">
        <?php if ( ! empty( $home_decor_store_trending_product_heading ) ) { ?>
          <h3><?php echo esc_html( $home_decor_store_trending_product_heading ); ?></h3>
        <?php } ?>
        <?php if ( ! empty( $home_decor_store_trending_product_content ) ) { ?>
          <p><?php echo esc_html( $home_decor_store_trending_product_content ); ?></p>
        <?php } ?>
      </div>
      <div class="video-main-box">
        <?php 
        $home_decor_store_query = new WP_Query( $home_decor_store_services_args );
        if ( $home_decor_store_query->have_posts() ) :
          ?>
          <div class="section-body">
            <div class="service-section-wrapper">
              <?php
              $home_decor_store_i = 1;
              while ( $home_decor_store_query->have_posts() ) :
                $home_decor_store_query->the_post();
                ?>
                <div class="service-single">
                  <div class="service-image">
                    <?php the_post_thumbnail( 'full' ); ?>
                  </div>
                  <div class="service-title">
                    <h3>
                      <a href="<?php the_permalink(); ?>">
                        <?php the_title(); ?>
                      </a>
                    </h3>
                  </div>
                </div>
                <?php
                $home_decor_store_i++;
              endwhile;
              wp_reset_postdata();
              ?>
            </div>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </section>
  <?php
}