<?php
/**
 * Sample implementation of the Custom Header feature
 *
 * @link https://developer.wordpress.org/themes/functionality/custom-headers/
 *
 * @package home_decor_store
 */

function home_decor_store_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'home_decor_store_custom_header_args', array(
		'default-text-color'     => 'fff',
		'header-text' 			 =>	false,
		'width'                  => 1360,
		'height'                 => 110,
		'flex-width'         	=> true,
        'flex-height'        	=> true,
		'wp-head-callback'       => 'home_decor_store_header_style',
	) ) );
}

add_action( 'after_setup_theme', 'home_decor_store_custom_header_setup' );

if ( ! function_exists( 'home_decor_store_header_style' ) ) :

add_action( 'wp_enqueue_scripts', 'home_decor_store_header_style' );
function home_decor_store_header_style() {
	if ( get_header_image() ) :
	$home_decor_store_custom_css = "
        header.site-header .header-main-wrapper .bottom-header-outer-wrapper .bottom-header-part{
			background-image:url('".esc_url(get_header_image())."') !important;
			background-position: center top;
		}";
	   	wp_add_inline_style( 'home-decor-store-style', $home_decor_store_custom_css );
	endif;
}
endif;