<?php

/**
 * Banner Section
 *
 * @package home_decor_store
 */

$wp_customize->add_section(
	'home_decor_store_banner_section',
	array(
		'panel'    => 'home_decor_store_front_page_options',
		'title'    => esc_html__( 'Banner Section', 'home-decor-store' ),
		'priority' => 10,
	)
);

// Banner Section - Enable Section.
$wp_customize->add_setting(
	'home_decor_store_enable_banner_section',
	array(
		'default'           => true,
		'sanitize_callback' => 'home_decor_store_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Home_Decor_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'home_decor_store_enable_banner_section',
		array(
			'label'    => esc_html__( 'Enable Banner Section', 'home-decor-store' ),
			'section'  => 'home_decor_store_banner_section',
			'settings' => 'home_decor_store_enable_banner_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'home_decor_store_enable_banner_section',
		array(
			'selector' => '#home_decor_store_banner_section .section-link',
			'settings' => 'home_decor_store_enable_banner_section',
		)
	);
}

// Banner Section - Banner Slider Content Type.
$wp_customize->add_setting(
	'home_decor_store_banner_slider_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'home_decor_store_sanitize_select',
	)
);

$wp_customize->add_control(
	'home_decor_store_banner_slider_content_type',
	array(
		'label'           => esc_html__( 'Select Banner Slider Content Type', 'home-decor-store' ),
		'section'         => 'home_decor_store_banner_section',
		'settings'        => 'home_decor_store_banner_slider_content_type',
		'type'            => 'select',
		'active_callback' => 'home_decor_store_is_banner_slider_section_enabled',
		'choices'         => array(
			'page' => esc_html__( 'Page', 'home-decor-store' ),
			'post' => esc_html__( 'Post', 'home-decor-store' ),
		),
	)
);

// Banner Slider Category Setting.
$wp_customize->add_setting('home_decor_store_banner_slider_category', array(
	'default'           => 'banner',
	'sanitize_callback' => 'sanitize_text_field',
));

// Add custom control for Banner Slider Category with conditional visibility.
$wp_customize->add_control(new Home_Decor_Store_Category_Dropdown_Control($wp_customize, 'home_decor_store_banner_slider_category', array(
	'label'    => __('Select Banner Category', 'home-decor-store'),
	'section'  => 'home_decor_store_banner_section',
	'settings' => 'home_decor_store_banner_slider_category',
	'active_callback' => function() use ($wp_customize) {
		return $wp_customize->get_setting('home_decor_store_banner_slider_content_type')->value() === 'post';
	},
)));

for ( $home_decor_store_i = 1; $home_decor_store_i <= 3; $home_decor_store_i++ ) {

	// Banner Section - Select Banner Post.
	$wp_customize->add_setting(
		'home_decor_store_banner_slider_content_post_' . $home_decor_store_i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'home_decor_store_banner_slider_content_post_' . $home_decor_store_i,
		array(
			/* translators: %d: Post Count. */
			'label'           => sprintf( esc_html__( 'Select Post %d', 'home-decor-store' ), $home_decor_store_i ),
			'description'     => sprintf( esc_html__( 'Kindly :- Select a Post based on the category selected in the upper settings', 'home-decor-store' ), $home_decor_store_i ),
			'section'         => 'home_decor_store_banner_section',
			'settings'        => 'home_decor_store_banner_slider_content_post_' . $home_decor_store_i,
			'active_callback' => 'home_decor_store_is_banner_slider_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => home_decor_store_get_post_choices(),
		)
	);

	// Banner Section - Select Banner Page.
	$wp_customize->add_setting(
		'home_decor_store_banner_slider_content_page_' . $home_decor_store_i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'home_decor_store_banner_slider_content_page_' . $home_decor_store_i,
		array(
			/* translators: %d: Page Count. */
			'label'           => sprintf( esc_html__( 'Select Page %d', 'home-decor-store' ), $home_decor_store_i ),
			'section'         => 'home_decor_store_banner_section',
			'settings'        => 'home_decor_store_banner_slider_content_page_' . $home_decor_store_i,
			'active_callback' => 'home_decor_store_is_banner_slider_section_and_content_type_page_enabled',
			'type'            => 'select',
			'choices'         => home_decor_store_get_page_choices(),
		)
	);

	// Banner Section - Button Label.
	$wp_customize->add_setting(
		'home_decor_store_banner_button_label_' . $home_decor_store_i,
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'home_decor_store_banner_button_label_' . $home_decor_store_i,
		array(
			/* translators: %d: Button Label Count. */
			'label'           => sprintf( esc_html__( 'Button Label %d', 'home-decor-store' ), $home_decor_store_i ),
			'section'         => 'home_decor_store_banner_section',
			'settings'        => 'home_decor_store_banner_button_label_' . $home_decor_store_i,
			'type'            => 'text',
			'active_callback' => 'home_decor_store_is_banner_slider_section_enabled',
		)
	);

	// Banner Section - Button Link.
	$wp_customize->add_setting(
		'home_decor_store_banner_button_link_' . $home_decor_store_i,
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_url_raw',
		)
	);

	$wp_customize->add_control(
		'home_decor_store_banner_button_link_' . $home_decor_store_i,
		array(
			/* translators: %d: Button Link Count. */
			'label'           => sprintf( esc_html__( 'Button Link %d', 'home-decor-store' ), $home_decor_store_i ),
			'section'         => 'home_decor_store_banner_section',
			'settings'        => 'home_decor_store_banner_button_link_' . $home_decor_store_i,
			'type'            => 'url',
			'active_callback' => 'home_decor_store_is_banner_slider_section_enabled',
		)
	);
}