<?php

/**
 * Service Section
 *
 * @package home_decor_store
 */

$wp_customize->add_section(
	'home_decor_store_services_section',
	array(
		'panel'    => 'home_decor_store_front_page_options',
		'title'    => esc_html__( 'Services Section', 'home-decor-store' ),
		'priority' => 10,
	)
);

// Service Section - Enable Section.
$wp_customize->add_setting(
	'home_decor_store_enable_service_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'home_decor_store_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Home_Decor_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'home_decor_store_enable_service_section',
		array(
			'label'    => esc_html__( 'Enable Services Section', 'home-decor-store' ),
			'section'  => 'home_decor_store_services_section',
			'settings' => 'home_decor_store_enable_service_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'home_decor_store_enable_service_section',
		array(
			'selector' => '#home_decor_store_service_section .section-link',
			'settings' => 'home_decor_store_enable_service_section',
		)
	);
}

// Service Section - Button Label.
$wp_customize->add_setting(
	'home_decor_store_trending_product_heading',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'home_decor_store_trending_product_heading',
	array(
		'label'           => esc_html__( 'Heading', 'home-decor-store' ),
		'section'         => 'home_decor_store_services_section',
		'settings'        => 'home_decor_store_trending_product_heading',
		'type'            => 'text',
		'active_callback' => 'home_decor_store_is_service_section_enabled',
	)
);

// Service Section - Button Label.
$wp_customize->add_setting(
	'home_decor_store_trending_product_content',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'home_decor_store_trending_product_content',
	array(
		'label'           => esc_html__( 'Content', 'home-decor-store' ),
		'section'         => 'home_decor_store_services_section',
		'settings'        => 'home_decor_store_trending_product_content',
		'type'            => 'text',
		'active_callback' => 'home_decor_store_is_service_section_enabled',
	)
);

// Services Section - Content Type.
$wp_customize->add_setting(
	'home_decor_store_service_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'home_decor_store_sanitize_select',
	)
);

$wp_customize->add_control(
	'home_decor_store_service_content_type',
	array(
		'label'           => esc_html__( 'Select Content Type', 'home-decor-store' ),
		'section'         => 'home_decor_store_services_section',
		'settings'        => 'home_decor_store_service_content_type',
		'type'            => 'select',
		'active_callback' => 'home_decor_store_is_service_section_enabled',
		'choices'         => array(
			'page' => esc_html__( 'Page', 'home-decor-store' ),
			'post' => esc_html__( 'Post', 'home-decor-store' ),
		),
	)
);

// Services Category Setting.
$wp_customize->add_setting('home_decor_store_services_category', array(
	'default'           => 'services',
	'sanitize_callback' => 'sanitize_text_field',
));

// Add custom control for Services Category with conditional visibility.
$wp_customize->add_control(new Home_Decor_Store_Category_Dropdown_Control($wp_customize, 'home_decor_store_services_category', array(
	'label'    => __('Select Services Category', 'home-decor-store'),
	'section'  => 'home_decor_store_services_section',
	'settings' => 'home_decor_store_services_category',
	'active_callback' => function() use ($wp_customize) {
		return $wp_customize->get_setting('home_decor_store_service_content_type')->value() === 'post';
	},
)));


for ( $home_decor_store_i = 1; $home_decor_store_i <= 8; $home_decor_store_i++ ) {
	
	// Service Section - Select Post.
	$wp_customize->add_setting(
		'home_decor_store_service_content_post_' . $home_decor_store_i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'home_decor_store_service_content_post_' . $home_decor_store_i,
		array(
			'label'           => esc_html__( 'Select Post ', 'home-decor-store' ) . $home_decor_store_i,
			'description'     => sprintf( esc_html__( 'Kindly :- Select a Post based on the category selected in the upper settings', 'home-decor-store' ), $home_decor_store_i ),
			'section'         => 'home_decor_store_services_section',
			'settings'        => 'home_decor_store_service_content_post_' . $home_decor_store_i,
			'active_callback' => 'home_decor_store_is_service_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => home_decor_store_get_post_choices(),
		)
	);

	// Service Section - Select Page.
	$wp_customize->add_setting(
		'home_decor_store_service_content_page_' . $home_decor_store_i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'home_decor_store_service_content_page_' . $home_decor_store_i,
		array(
			'label'           => esc_html__( 'Select Page ', 'home-decor-store' ) . $home_decor_store_i,
			'section'         => 'home_decor_store_services_section',
			'settings'        => 'home_decor_store_service_content_page_' . $home_decor_store_i,
			'active_callback' => 'home_decor_store_is_service_section_and_content_type_page_enabled',
			'type'            => 'select',
			'choices'         => home_decor_store_get_page_choices(),
		)
	);
}