<?php

function home_decor_store_sanitize_select( $home_decor_store_input, $home_decor_store_setting ) {
	$home_decor_store_input = sanitize_key( $home_decor_store_input );
	$home_decor_store_choices = $home_decor_store_setting->manager->get_control( $home_decor_store_setting->id )->choices;
	return ( array_key_exists( $home_decor_store_input, $home_decor_store_choices ) ? $home_decor_store_input : $home_decor_store_setting->default );
}

function home_decor_store_sanitize_switch( $home_decor_store_input ) {
	if ( true === $home_decor_store_input ) {
		return true;
	} else {
		return false;
	}
}

function home_decor_store_sanitize_google_fonts( $home_decor_store_input, $home_decor_store_setting ) {
	$home_decor_store_choices = $home_decor_store_setting->manager->get_control( $home_decor_store_setting->id )->choices;
	return ( array_key_exists( $home_decor_store_input, $home_decor_store_choices ) ? $home_decor_store_input : $home_decor_store_setting->default );
}
/**
 * Sanitize HTML input.
 *
 * @param string $home_decor_store_input HTML input to sanitize.
 * @return string Sanitized HTML.
 */
function home_decor_store_sanitize_html( $home_decor_store_input ) {
    return wp_kses_post( $home_decor_store_input );
}

/**
 * Sanitize URL input.
 *
 * @param string $home_decor_store_input URL input to sanitize.
 * @return string Sanitized URL.
 */
function home_decor_store_sanitize_url( $home_decor_store_input ) {
    return esc_url_raw( $home_decor_store_input );
}
// Sanitize Scroll Top Position
function home_decor_store_sanitize_scroll_top_position( $home_decor_store_input ) {
    $home_decor_store_valid_positions = array( 'bottom-right', 'bottom-left', 'bottom-center' );
    if ( in_array( $home_decor_store_input, $home_decor_store_valid_positions ) ) {
        return $home_decor_store_input;
    } else {
        return 'bottom-right'; // Default to bottom-right if invalid value
    }
}

function home_decor_store_sanitize_choices( $home_decor_store_input, $home_decor_store_setting ) {
    global $wp_customize; 
    $home_decor_store_control = $wp_customize->get_control( $home_decor_store_setting->id ); 
    if ( array_key_exists( $home_decor_store_input, $home_decor_store_control->choices ) ) {
        return $home_decor_store_input;
    } else {
        return $home_decor_store_setting->default;
    }
}

function home_decor_store_sanitize_range_value( $home_decor_store_number, $home_decor_store_setting ) {

	// Ensure input is an absolute integer.
	$home_decor_store_number = absint( $home_decor_store_number );

	// Get the input attributes associated with the setting.
	$home_decor_store_atts = $home_decor_store_setting->manager->get_control( $home_decor_store_setting->id )->input_attrs;

	// Get minimum number in the range.
	$home_decor_store_min = ( isset( $home_decor_store_atts['min'] ) ? $home_decor_store_atts['min'] : $home_decor_store_number );

	// Get maximum number in the range.
	$home_decor_store_max = ( isset( $home_decor_store_atts['max'] ) ? $home_decor_store_atts['max'] : $home_decor_store_number );

	// Get step.
	$home_decor_store_step = ( isset( $home_decor_store_atts['step'] ) ? $home_decor_store_atts['step'] : 1 );

	// If the number is within the valid range, return it; otherwise, return the default.
	return ( $home_decor_store_min <= $home_decor_store_number && $home_decor_store_number <= $home_decor_store_max && is_int( $home_decor_store_number / $home_decor_store_step ) ? $home_decor_store_number : $home_decor_store_setting->default );
}