<?php

/**
 * Excerpt
 *
 * @package home_decor_store
 */

$wp_customize->add_section(
	'home_decor_store_excerpt_options',
	array(
		'panel' => 'home_decor_store_theme_options',
		'title' => esc_html__( 'Excerpt', 'home-decor-store' ),
	)
);

// Excerpt - Excerpt Length.
$wp_customize->add_setting(
	'home_decor_store_excerpt_length',
	array(
		'default'           => 20,
		'sanitize_callback' => 'absint',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_control(
	'home_decor_store_excerpt_length',
	array(
		'label'       => esc_html__( 'Excerpt Length (no. of words)', 'home-decor-store' ),
		'section'     => 'home_decor_store_excerpt_options',
		'settings'    => 'home_decor_store_excerpt_length',
		'type'        => 'number',
		'input_attrs' => array(
			'min'  => 10,
			'max'  => 200,
			'step' => 1,
		),
	)
);