<?php

/**
 * Footer Options
 *
 * @package home_decor_store
 */

$wp_customize->add_section(
	'home_decor_store_footer_options',
	array(
		'panel' => 'home_decor_store_theme_options',
		'title' => esc_html__( 'Footer Options', 'home-decor-store' ),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'home_decor_store_footer_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Home_Decor_Store_Separator_Custom_Control( $wp_customize, 'home_decor_store_footer_separators', array(
	'label' => __( 'Footer Settings', 'home-decor-store' ),
	'section' => 'home_decor_store_footer_options',
	'settings' => 'home_decor_store_footer_separators',
)));

// Footer Section - Enable Section.
$wp_customize->add_setting(
	'home_decor_store_enable_footer_section',
	array(
		'default'           => true,
		'sanitize_callback' => 'home_decor_store_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Home_Decor_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'home_decor_store_enable_footer_section',
		array(
			'label'    => esc_html__( 'Show / Hide Footer', 'home-decor-store' ),
			'section'  => 'home_decor_store_footer_options',
			'settings' => 'home_decor_store_enable_footer_section',
		)
	)
);

// column // 
$wp_customize->add_setting(
	'home_decor_store_footer_widget_column',
	array(
        'default'			=> '4',
		'capability'     	=> 'edit_theme_options',
		'sanitize_callback' => 'home_decor_store_sanitize_select',
		
	)
);	

$wp_customize->add_control(
	'home_decor_store_footer_widget_column',
	array(
	    'label'   		=> __('Select Widget Column','home-decor-store'),
		'description' => __('Note: Default footer widgets are shown. Add your preferred widgets in (Appearance > Widgets > Footer) to see changes.', 'home-decor-store'),
	    'section' 		=> 'home_decor_store_footer_options',
		'type'			=> 'select',
		'choices'        => 
		array(
			'' => __( 'None', 'home-decor-store' ),
			'1' => __( '1 Column', 'home-decor-store' ),
			'2' => __( '2 Column', 'home-decor-store' ),
			'3' => __( '3 Column', 'home-decor-store' ),
			'4' => __( '4 Column', 'home-decor-store' )
		) 
	) 
);


// Footer Background Color Setting
$wp_customize->add_setting('home_decor_store_footer_background_color_setting', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color',
));

$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'home_decor_store_footer_background_color_setting', array(
    'label' => __('Footer Background Color', 'home-decor-store'),
    'section' => 'home_decor_store_footer_options',
)));

// Footer Background Image Setting
$wp_customize->add_setting('home_decor_store_footer_background_image_setting', array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
));

$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'home_decor_store_footer_background_image_setting', array(
    'label' => __('Footer Background Image', 'home-decor-store'),
    'section' => 'home_decor_store_footer_options',
)));

// Footer Background Attachment
$wp_customize->add_setting(
	'home_decor_store_footer_image_attachment_setting',
	array(
		'default'=> 'scroll',
		'sanitize_callback' => 'home_decor_store_sanitize_choices'
	)
);

$wp_customize->add_control(
	'home_decor_store_footer_image_attachment_setting',
	array(
		'type' => 'select',
		'label' => __('Footer Background Attatchment','home-decor-store'),
		'choices' => array(
			'fixed' => __('fixed','home-decor-store'),
			'scroll' => __('scroll','home-decor-store'),
		),
		'section'=> 'home_decor_store_footer_options',
  	)
);


// Footer Heading Alignment
$wp_customize->add_setting(
	'home_decor_store_footer_header_align',
	array(
		'default' 			=> 'left',
		'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control(
	'home_decor_store_footer_header_align',
	array(
		'label' => __('Footer Heading Alignment ','home-decor-store'),
		'section' => 'home_decor_store_footer_options',
		'type'			=> 'select',
		'choices' => 
		array(
			'left' => __('Left','home-decor-store'),
			'right' => __('Right','home-decor-store'),
			'center' => __('Center','home-decor-store'),
		),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'home_decor_store_copyright_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Home_Decor_Store_Separator_Custom_Control( $wp_customize, 'home_decor_store_copyright_separators', array(
	'label' => __( 'Copyright Settings', 'home-decor-store' ),
	'section' => 'home_decor_store_footer_options',
	'settings' => 'home_decor_store_copyright_separators',
)));

// Copyright Section - Enable Section.
$wp_customize->add_setting(
	'home_decor_store_enable_copyright_section',
	array(
		'default'           => true,
		'sanitize_callback' => 'home_decor_store_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Home_Decor_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'home_decor_store_enable_copyright_section',
		array(
			'label'    => esc_html__( 'Show / Hide Copyright', 'home-decor-store' ),
			'section'  => 'home_decor_store_footer_options',
			'settings' => 'home_decor_store_enable_copyright_section',
		)
	)
);

$wp_customize->add_setting(
	'home_decor_store_footer_copyright_text',
	array(
		'default'           => '',
		'sanitize_callback' => 'wp_kses_post',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_control(
	'home_decor_store_footer_copyright_text',
	array(
		'label'    => esc_html__( 'Copyright Text', 'home-decor-store' ),
		'section'  => 'home_decor_store_footer_options',
		'settings' => 'home_decor_store_footer_copyright_text',
		'type'     => 'textarea',
	)
);

$wp_customize->add_setting(
	'home_decor_store_footer_copyright_text',
	array(
		'sanitize_callback' => 'wp_kses_post',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_setting('footer_text_transform', array(
    'default' => 'capitalize',
    'sanitize_callback' => 'sanitize_text_field',
));

// Add Footer Heading Text Transform Control
$wp_customize->add_control('footer_text_transform', array(
    'label' => __('Footer Heading Text Transform', 'home-decor-store'),
    'section' => 'home_decor_store_footer_options',
    'settings' => 'footer_text_transform',
    'type' => 'select',
    'choices' => array(
        'none' => __('None', 'home-decor-store'),
        'capitalize' => __('Capitalize', 'home-decor-store'),
        'uppercase' => __('Uppercase', 'home-decor-store'),
        'lowercase' => __('Lowercase', 'home-decor-store'),
    ),
));


$wp_customize->add_setting(
	'home_decor_store_footer_copyright_text',
	array(
		'sanitize_callback' => 'wp_kses_post',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_control(
	'home_decor_store_footer_copyright_text',
	array(
		'label'    => esc_html__( 'Copyright Text', 'home-decor-store' ),
		'section'  => 'home_decor_store_footer_options',
		'settings' => 'home_decor_store_footer_copyright_text',
		'type'     => 'textarea',
	)
);

//Copyright Alignment
$wp_customize->add_setting(
	'home_decor_store_footer_bottom_align',
	array(
		'default' 			=> 'center',
		'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control(
	'home_decor_store_footer_bottom_align',
	array(
		'label' => __('Copyright Alignment ','home-decor-store'),
		'section' => 'home_decor_store_footer_options',
		'type'			=> 'select',
		'choices' => 
		array(
			'left' => __('Left','home-decor-store'),
			'right' => __('Right','home-decor-store'),
			'center' => __('Center','home-decor-store'),
		),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'home_decor_store_scroll_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Home_Decor_Store_Separator_Custom_Control( $wp_customize, 'home_decor_store_scroll_separators', array(
	'label' => __( 'Scroll Top Settings', 'home-decor-store' ),
	'section' => 'home_decor_store_footer_options',
	'settings' => 'home_decor_store_scroll_separators',
)));

// Footer Options - Scroll Top.
$wp_customize->add_setting(
	'home_decor_store_scroll_top',
	array(
		'sanitize_callback' => 'home_decor_store_sanitize_switch',
		'default'           => true,
	)
);

$wp_customize->add_control(
	new Home_Decor_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'home_decor_store_scroll_top',
		array(
			'label'   => esc_html__( 'Enable Scroll Top Button', 'home-decor-store' ),
			'section' => 'home_decor_store_footer_options',
		)
	)
);


// icon // 
$wp_customize->add_setting(
	'home_decor_store_scroll_btn_icon',
	array(
        'default' => 'fas fa-chevron-up',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Home_Decor_Store_Change_Icon_Control($wp_customize, 
	'home_decor_store_scroll_btn_icon',
	array(
	    'label'   		=> __('Scroll Top Icon','home-decor-store'),
	    'section' 		=> 'home_decor_store_footer_options',
		'iconset' => 'fa',
	))  
);
$wp_customize->add_setting( 'home_decor_store_scroll_top_position', array(
    'default'           => 'bottom-right',
    'sanitize_callback' => 'home_decor_store_sanitize_scroll_top_position',
) );

// Add control for Scroll Top Button Position
$wp_customize->add_control( 'home_decor_store_scroll_top_position', array(
    'label'    => __( 'Scroll Top Position', 'home-decor-store' ),
    'section'  => 'home_decor_store_footer_options',
    'settings' => 'home_decor_store_scroll_top_position',
    'type'     => 'select',
    'choices'  => array(
        'bottom-right' => __( 'Bottom Right', 'home-decor-store' ),
        'bottom-left'  => __( 'Bottom Left', 'home-decor-store' ),
        'bottom-center'=> __( 'Bottom Center', 'home-decor-store' ),
    ),
) );

$wp_customize->add_setting( 'home_decor_store_scroll_top_shape', array(
	'default'           => 'box',
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'home_decor_store_scroll_top_shape', array(
	'label'    => __( 'Scroll to Top Button Shape', 'home-decor-store' ),
	'section'  => 'home_decor_store_footer_options',
	'settings' => 'home_decor_store_scroll_top_shape',
	'type'     => 'radio',
	'choices'  => array(
		'box'        => __( 'Box', 'home-decor-store' ),
		'curved-box' => __( 'Curved Box', 'home-decor-store' ),
		'circle'     => __( 'Circle', 'home-decor-store' ),
	),
) );