<?php

/**
 * Pige Title Options
 *
 * @package home_decor_store
 */

$wp_customize->add_section(
	'home_decor_store_page_title_options',
	array(
		'panel' => 'home_decor_store_theme_options',
		'title' => esc_html__( 'Page Title', 'home-decor-store' ),
	)
);

$wp_customize->add_setting(
    'home_decor_store_page_header_visibility',
    array(
        'default'           => 'all-devices',
        'sanitize_callback' => 'home_decor_store_sanitize_select',
    )
);

$wp_customize->add_control(
    new WP_Customize_Control(
        $wp_customize,
        'home_decor_store_page_header_visibility',
        array(
            'label'    => esc_html__( 'Page Header Visibility', 'home-decor-store' ),
            'type'     => 'select',
            'section'  => 'home_decor_store_page_title_options',
            'settings' => 'home_decor_store_page_header_visibility',
            'priority' => 10,
            'choices'  => array(
                'all-devices'        => esc_html__( 'Show on all devices', 'home-decor-store' ),
                'hide-tablet'        => esc_html__( 'Hide on Tablet', 'home-decor-store' ),
                'hide-mobile'        => esc_html__( 'Hide on Mobile', 'home-decor-store' ),
                'hide-tablet-mobile' => esc_html__( 'Hide on Tablet & Mobile', 'home-decor-store' ),
                'hide-all-devices'   => esc_html__( 'Hide on all devices', 'home-decor-store' ),
            ),
        )
    )
);


$wp_customize->add_setting( 'home_decor_store_page_title_background_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Home_Decor_Store_Separator_Custom_Control( $wp_customize, 'home_decor_store_page_title_background_separator', array(
	'label' => __( 'Page Title BG Image & Color Setting', 'home-decor-store' ),
	'section' => 'home_decor_store_page_title_options',
	'settings' => 'home_decor_store_page_title_background_separator',
)));


$wp_customize->add_setting(
	'home_decor_store_page_header_style',
	array(
		'sanitize_callback' => 'home_decor_store_sanitize_switch',
		'default'           => False,
	)
);

$wp_customize->add_control(
	new Home_Decor_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'home_decor_store_page_header_style',
		array(
			'label'   => esc_html__('Page Title Background Image', 'home-decor-store'),
			'section' => 'home_decor_store_page_title_options',
		)
	)
);

$wp_customize->add_setting( 'home_decor_store_page_header_background_image', array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'home_decor_store_page_header_background_image', array(
    'label'    => __( 'Background Image', 'home-decor-store' ),
    'section'  => 'home_decor_store_page_title_options',
	'description' => __('Choose either a background image or a color. If a background image is selected, the background color will not be visible.', 'home-decor-store'),
    'settings' => 'home_decor_store_page_header_background_image',
	'active_callback' => 'home_decor_store_is_pagetitle_bcakground_image_enabled',
)));


$wp_customize->add_setting('home_decor_store_page_header_image_height', array(
	'default'           => 200,
	'sanitize_callback' => 'home_decor_store_sanitize_range_value',
));

$wp_customize->add_control(new Home_Decor_Store_Customize_Range_Control($wp_customize, 'home_decor_store_page_header_image_height', array(
		'label'       => __('Image Height', 'home-decor-store'),
		'section'     => 'home_decor_store_page_title_options',
		'settings'    => 'home_decor_store_page_header_image_height',
		'active_callback' => 'home_decor_store_is_pagetitle_bcakground_image_enabled',
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 1000,
			'step' => 5,
		),
)));


$wp_customize->add_setting('home_decor_store_page_title_background_color_setting', array(
    'default' => '#f5f5f5',
    'sanitize_callback' => 'sanitize_hex_color',
));

$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'home_decor_store_page_title_background_color_setting', array(
    'label' => __('Page Title Background Color', 'home-decor-store'),
    'section' => 'home_decor_store_page_title_options',
)));

$wp_customize->add_setting('home_decor_store_pagetitle_height', array(
    'default'           => 50,
    'sanitize_callback' => 'home_decor_store_sanitize_range_value',
));

$wp_customize->add_control(new Home_Decor_Store_Customize_Range_Control($wp_customize, 'home_decor_store_pagetitle_height', array(
    'label'       => __('Set Height', 'home-decor-store'),
    'description' => __('This setting controls the page title height when no background image is set. If a background image is set, this setting will not apply.', 'home-decor-store'),
    'section'     => 'home_decor_store_page_title_options',
    'settings'    => 'home_decor_store_pagetitle_height',
    'input_attrs' => array(
        'min'  => 0,
        'max'  => 300,
        'step' => 5,
    ),
)));

$wp_customize->add_setting( 'home_decor_store_page_title_style_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Home_Decor_Store_Separator_Custom_Control( $wp_customize, 'home_decor_store_page_title_style_separator', array(
	'label' => __( 'Page Title Styling Setting', 'home-decor-store' ),
	'section' => 'home_decor_store_page_title_options',
	'settings' => 'home_decor_store_page_title_style_separator',
)));


$wp_customize->add_setting( 'home_decor_store_page_header_heading_tag', array(
	'default'   => 'h1',
	'sanitize_callback' => 'home_decor_store_sanitize_select',
) );

$wp_customize->add_control( 'home_decor_store_page_header_heading_tag', array(
	'label'   => __( 'Page Title Heading Tag', 'home-decor-store' ),
	'section' => 'home_decor_store_page_title_options',
	'type'    => 'select',
	'choices' => array(
		'h1' => __( 'H1', 'home-decor-store' ),
		'h2' => __( 'H2', 'home-decor-store' ),
		'h3' => __( 'H3', 'home-decor-store' ),
		'h4' => __( 'H4', 'home-decor-store' ),
		'h5' => __( 'H5', 'home-decor-store' ),
		'h6' => __( 'H6', 'home-decor-store' ),
		'p' => __( 'p', 'home-decor-store' ),
		'a' => __( 'a', 'home-decor-store' ),
		'div' => __( 'div', 'home-decor-store' ),
		'span' => __( 'span', 'home-decor-store' ),
	),
) );


$wp_customize->add_setting('home_decor_store_page_header_layout', array(
	'default' => 'left',
	'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control('home_decor_store_page_header_layout', array(
	'label' => __('Style', 'home-decor-store'),
	'section' => 'home_decor_store_page_title_options',
	'description' => __('"Flex Layout Style" wont work below 600px (mobile media)', 'home-decor-store'),
	'settings' => 'home_decor_store_page_header_layout',
	'type' => 'radio',
	'choices' => array(
		'left' => __('Classic', 'home-decor-store'),
		'right' => __('Aligned Right', 'home-decor-store'),
		'center' => __('Centered Focus', 'home-decor-store'),
		'flex' => __('Flex Layout', 'home-decor-store'),
	),
));