<?php

/**
 * Sidebar Position
 *
 * @package home_decor_store
 */

$wp_customize->add_section(
	'home_decor_store_sidebar_position',
	array(
		'title' => esc_html__( 'Sidebar Position', 'home-decor-store' ),
		'panel' => 'home_decor_store_theme_options',
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'home_decor_store_global_sidebar_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Home_Decor_Store_Separator_Custom_Control( $wp_customize, 'home_decor_store_global_sidebar_separator', array(
	'label' => __( 'Global Sidebar Position', 'home-decor-store' ),
	'section' => 'home_decor_store_sidebar_position',
	'settings' => 'home_decor_store_global_sidebar_separator',
)));


// Sidebar Position - Global Sidebar Position.
$wp_customize->add_setting(
	'home_decor_store_sidebar_position',
	array(
		'sanitize_callback' => 'home_decor_store_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'home_decor_store_sidebar_position',
	array(
		'label'   => esc_html__( 'Select Sidebar Position', 'home-decor-store' ),
		'section' => 'home_decor_store_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'home-decor-store' ),
			'left-sidebar'  => esc_html__( 'Left Sidebar', 'home-decor-store' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'home-decor-store' ),
		),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'home_decor_store_post_sidebar_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Home_Decor_Store_Separator_Custom_Control( $wp_customize, 'home_decor_store_post_sidebar_separator', array(
	'label' => __( 'Post Sidebar Position', 'home-decor-store' ),
	'section' => 'home_decor_store_sidebar_position',
	'settings' => 'home_decor_store_post_sidebar_separator',
)));

// Sidebar Position - Post Sidebar Position.
$wp_customize->add_setting(
	'home_decor_store_post_sidebar_position',
	array(
		'sanitize_callback' => 'home_decor_store_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'home_decor_store_post_sidebar_position',
	array(
		'label'   => esc_html__( 'Select Sidebar Position', 'home-decor-store' ),
		'section' => 'home_decor_store_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'home-decor-store' ),
			'left-sidebar'  => esc_html__( 'Left Sidebar', 'home-decor-store' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'home-decor-store' ),
		),
	)
);



// Add Separator Custom Control
$wp_customize->add_setting( 'home_decor_store_page_sidebar_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Home_Decor_Store_Separator_Custom_Control( $wp_customize, 'home_decor_store_page_sidebar_separator', array(
	'label' => __( 'Page Sidebar Position', 'home-decor-store' ),
	'section' => 'home_decor_store_sidebar_position',
	'settings' => 'home_decor_store_page_sidebar_separator',
)));

// Sidebar Position - Page Sidebar Position.
$wp_customize->add_setting(
	'home_decor_store_page_sidebar_position',
	array(
		'sanitize_callback' => 'home_decor_store_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'home_decor_store_page_sidebar_position',
	array(
		'label'   => esc_html__( 'Select Sidebar Position', 'home-decor-store' ),
		'section' => 'home_decor_store_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'home-decor-store' ),
			'left-sidebar'  => esc_html__( 'Left Sidebar', 'home-decor-store' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'home-decor-store' ),
		),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'home_decor_store_sidebar_width_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Home_Decor_Store_Separator_Custom_Control( $wp_customize, 'home_decor_store_sidebar_width_separator', array(
	'label' => __( 'Sidebar Width Setting', 'home-decor-store' ),
	'section' => 'home_decor_store_sidebar_position',
	'settings' => 'home_decor_store_sidebar_width_separator',
)));


$wp_customize->add_setting( 'home_decor_store_sidebar_width', array(
	'default'           => '30',
	'sanitize_callback' => 'home_decor_store_sanitize_range_value',
) );

$wp_customize->add_control(new Home_Decor_Store_Customize_Range_Control($wp_customize, 'home_decor_store_sidebar_width', array(
	'section'     => 'home_decor_store_sidebar_position',
	'label'       => __( 'Adjust Sidebar Width', 'home-decor-store' ),
	'description' => __( 'Adjust the width of the sidebar.', 'home-decor-store' ),
	'input_attrs' => array(
		'min'  => 10,
		'max'  => 50,
		'step' => 1,
	),
)));

$wp_customize->add_setting( 'home_decor_store_sidebar_widget_font_size', array(
    'default'           => 24,
    'sanitize_callback' => 'absint',
) );

// Add control for site title size
$wp_customize->add_control( 'home_decor_store_sidebar_widget_font_size', array(
    'type'        => 'number',
    'section'     => 'home_decor_store_sidebar_position',
    'label'       => __( 'Sidebar Widgets Heading Font Size ', 'home-decor-store' ),
    'input_attrs' => array(
        'min'  => 10,
        'max'  => 100,
        'step' => 1,
    ),
));