<?php

/**
 * Single Post Options
 *
 * @package home_decor_store
 */

$wp_customize->add_section(
	'home_decor_store_single_post_options',
	array(
		'title' => esc_html__( 'Single Post Options', 'home-decor-store' ),
		'panel' => 'home_decor_store_theme_options',
	)
);


// Post Options - Show / Hide Date.
$wp_customize->add_setting(
	'home_decor_store_single_post_hide_date',
	array(
		'default'           => true,
		'sanitize_callback' => 'home_decor_store_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Home_Decor_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'home_decor_store_single_post_hide_date',
		array(
			'label'   => esc_html__( 'Show / Hide Date', 'home-decor-store' ),
			'section' => 'home_decor_store_single_post_options',
		)
	)
);

// Post Options - Show / Hide Author.
$wp_customize->add_setting(
	'home_decor_store_single_post_hide_author',
	array(
		'default'           => true,
		'sanitize_callback' => 'home_decor_store_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Home_Decor_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'home_decor_store_single_post_hide_author',
		array(
			'label'   => esc_html__( 'Show / Hide Author', 'home-decor-store' ),
			'section' => 'home_decor_store_single_post_options',
		)
	)
);

// Post Options - Show / Hide Comments.
$wp_customize->add_setting(
	'home_decor_store_single_post_hide_comments',
	array(
		'default'           => true,
		'sanitize_callback' => 'home_decor_store_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Home_Decor_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'home_decor_store_single_post_hide_comments',
		array(
			'label'   => esc_html__( 'Show / Hide Comments', 'home-decor-store' ),
			'section' => 'home_decor_store_single_post_options',
		)
	)
);

// Post Options - Show / Hide Time.
$wp_customize->add_setting(
	'home_decor_store_single_post_hide_time',
	array(
		'default'           => true,
		'sanitize_callback' => 'home_decor_store_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Home_Decor_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'home_decor_store_single_post_hide_time',
		array(
			'label'   => esc_html__( 'Show / Hide Time', 'home-decor-store' ),
			'section' => 'home_decor_store_single_post_options',
		)
	)
);

// Post Options - Show / Hide Category.
$wp_customize->add_setting(
	'home_decor_store_single_post_hide_category',
	array(
		'default'           => true,
		'sanitize_callback' => 'home_decor_store_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Home_Decor_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'home_decor_store_single_post_hide_category',
		array(
			'label'   => esc_html__( 'Show / Hide Category', 'home-decor-store' ),
			'section' => 'home_decor_store_single_post_options',
		)
	)
);

// Post Options - Show / Hide Tag.
$wp_customize->add_setting(
	'home_decor_store_post_hide_tags',
	array(
		'default'           => true,
		'sanitize_callback' => 'home_decor_store_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Home_Decor_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'home_decor_store_post_hide_tags',
		array(
			'label'   => esc_html__( 'Show / Hide Tag', 'home-decor-store' ),
			'section' => 'home_decor_store_single_post_options',
		)
	)
);

// Post Options - Comment Title.
$wp_customize->add_setting(
	'home_decor_store_blog_post_comment_title',
	array(
		'default'=> 'Leave a Reply',
		'sanitize_callback'	=> 'sanitize_text_field'
	)
);

$wp_customize->add_control(
	'home_decor_store_blog_post_comment_title',
	array(
		'label'	=> __('Comment Title','home-decor-store'),
		'input_attrs' => array(
			'placeholder' => __( 'Leave a Reply', 'home-decor-store' ),
		),
		'section'=> 'home_decor_store_single_post_options',
		'type'=> 'text'
	)
);