<?php

/**
 * Header Options
 *
 * @package home_decor_store
 */
// ---------------------------------------- GENERAL OPTIONBS ----------------------------------------------------


// ---------------------------------------- PRELOADER ----------------------------------------------------


$wp_customize->add_section(
	'home_decor_store_general_options',
	array(
		'panel' => 'home_decor_store_theme_options',
		'title' => esc_html__( 'General Options', 'home-decor-store' ),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'home_decor_store_preloader_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Home_Decor_Store_Separator_Custom_Control( $wp_customize, 'home_decor_store_preloader_separator', array(
	'label' => __( 'Enable / Disable Site Preloader Section', 'home-decor-store' ),
	'section' => 'home_decor_store_general_options',
	'settings' => 'home_decor_store_preloader_separator',
) ) );


// General Options - Enable Preloader.
$wp_customize->add_setting(
	'home_decor_store_enable_preloader',
	array(
		'sanitize_callback' => 'home_decor_store_sanitize_switch',
		'default'           => false,
	)
);

$wp_customize->add_control(
	new Home_Decor_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'home_decor_store_enable_preloader',
		array(
			'label'   => esc_html__( 'Enable Preloader', 'home-decor-store' ),
			'section' => 'home_decor_store_general_options',
		)
	)
);

// Preloader Style Setting
$wp_customize->add_setting(
    'home_decor_store_preloader_style',
    array(
        'default'           => 'style1',
        'sanitize_callback' => 'sanitize_text_field',
    )
);

$wp_customize->add_control(
    'home_decor_store_preloader_style',
    array(
        'type'     => 'select',
        'label'    => esc_html__('Select Preloader Styles', 'home-decor-store'),
		'active_callback' => 'home_decor_store_is_preloader_style',
        'section'  => 'home_decor_store_general_options',
        'choices'  => array(
            'style1' => esc_html__('Style 1', 'home-decor-store'),
            'style2' => esc_html__('Style 2', 'home-decor-store'),
            'style3' => esc_html__('Style 3', 'home-decor-store'),
        ),
    )
);


// Preloader Background Color Setting
$wp_customize->add_setting(
	'home_decor_store_preloader_background_color_setting',
	 array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize, 'home_decor_store_preloader_background_color_setting', 
		array(
			'label' => __('Preloader Background Color', 'home-decor-store'),
			'active_callback' => 'home_decor_store_is_preloader_style',
			'section' => 'home_decor_store_general_options',
		)
	)
);

// Preloader Background Image Setting
$wp_customize->add_setting(
	'home_decor_store_preloader_background_image_setting', 
	array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize, 'home_decor_store_preloader_background_image_setting',
		 array(
			'label' => __('Preloader Background Image', 'home-decor-store'),
			'active_callback' => 'home_decor_store_is_preloader_style',
			'section' => 'home_decor_store_general_options',
		)
	)
);

// ---------------------------------------- PAGINATION ----------------------------------------------------


// Add Separator Custom Control
$wp_customize->add_setting( 'home_decor_store_pagination_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Home_Decor_Store_Separator_Custom_Control( $wp_customize, 'home_decor_store_pagination_separator', array(
	'label' => __( 'Enable / Disable Pagination Section', 'home-decor-store' ),
	'section' => 'home_decor_store_general_options',
	'settings' => 'home_decor_store_pagination_separator',
) ) );

// Pagination - Enable Pagination.
$wp_customize->add_setting(
	'home_decor_store_enable_pagination',
	array(
		'default'           => true,
		'sanitize_callback' => 'home_decor_store_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Home_Decor_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'home_decor_store_enable_pagination',
		array(
			'label'    => esc_html__( 'Enable Pagination', 'home-decor-store' ),
			'section'  => 'home_decor_store_general_options',
			'settings' => 'home_decor_store_enable_pagination',
			'type'     => 'checkbox',
		)
	)
);

// Pagination - Pagination Type.
$wp_customize->add_setting(
	'home_decor_store_pagination_type',
	array(
		'default'           => 'default',
		'sanitize_callback' => 'home_decor_store_sanitize_select',
	)
);

$wp_customize->add_control(
	'home_decor_store_pagination_type',
	array(
		'label'           => esc_html__( 'Pagination Type', 'home-decor-store' ),
		'section'         => 'home_decor_store_general_options',
		'settings'        => 'home_decor_store_pagination_type',
		'active_callback' => 'home_decor_store_is_pagination_enabled',
		'type'            => 'select',
		'choices'         => array(
			'default' => __( 'Default (Older/Newer)', 'home-decor-store' ),
			'numeric' => __( 'Numeric', 'home-decor-store' ),
		),
	)
);




// ---------------------------------------- BREADCRUMB ----------------------------------------------------


// Add Separator Custom Control
$wp_customize->add_setting( 'home_decor_store_breadcrumb_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Home_Decor_Store_Separator_Custom_Control( $wp_customize, 'home_decor_store_breadcrumb_separators', array(
	'label' => __( 'Enable / Disable Breadcrumb Section', 'home-decor-store' ),
	'section' => 'home_decor_store_general_options',
	'settings' => 'home_decor_store_breadcrumb_separators',
)));


// Breadcrumb - Enable Breadcrumb.
$wp_customize->add_setting(
	'home_decor_store_enable_breadcrumb',
	array(
		'sanitize_callback' => 'home_decor_store_sanitize_switch',
		'default'           => true,
	)
);

$wp_customize->add_control(
	new Home_Decor_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'home_decor_store_enable_breadcrumb',
		array(
			'label'   => esc_html__( 'Enable Breadcrumb', 'home-decor-store' ),
			'section' => 'home_decor_store_general_options',
		)
	)
);

// Breadcrumb - Separator.
$wp_customize->add_setting(
	'home_decor_store_breadcrumb_separator',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '/',
	)
);

$wp_customize->add_control(
	'home_decor_store_breadcrumb_separator',
	array(
		'label'           => esc_html__( 'Separator', 'home-decor-store' ),
		'active_callback' => 'home_decor_store_is_breadcrumb_enabled',
		'section'         => 'home_decor_store_general_options',
	)
);


// ---------------------------------------- Website layout ----------------------------------------------------


// Add Separator Custom Control
$wp_customize->add_setting( 'home_decor_store_layuout_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Home_Decor_Store_Separator_Custom_Control( $wp_customize, 'home_decor_store_layuout_separator', array(
	'label' => __( 'Website Layout Setting', 'home-decor-store' ),
	'section' => 'home_decor_store_general_options',
	'settings' => 'home_decor_store_layuout_separator',
)));


$wp_customize->add_setting(
	'home_decor_store_website_layout',
	array(
		'sanitize_callback' => 'home_decor_store_sanitize_switch',
		'default'           => false,
	)
);

$wp_customize->add_control(
	new Home_Decor_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'home_decor_store_website_layout',
		array(
			'label'   => esc_html__('Boxed Layout', 'home-decor-store'),
			'section' => 'home_decor_store_general_options',
		)
	)
);


$wp_customize->add_setting('home_decor_store_layout_width_margin', array(
	'default'           => 50,
	'sanitize_callback' => 'home_decor_store_sanitize_range_value',
));

$wp_customize->add_control(new Home_Decor_Store_Customize_Range_Control($wp_customize, 'home_decor_store_layout_width_margin', array(
		'label'       => __('Set Width', 'home-decor-store'),
		'description' => __('Adjust the width around the website layout by moving the slider. Use this setting to customize the appearance of your site to fit your design preferences.', 'home-decor-store'),
		'section'     => 'home_decor_store_general_options',
		'settings'    => 'home_decor_store_layout_width_margin',
		'active_callback' => 'home_decor_store_is_layout_enabled',
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 130,
			'step' => 1,
		),
)));



// ---------------------------------------- HEADER OPTIONS ----------------------------------------------------	

$wp_customize->add_section(
	'home_decor_store_header_options',
	array(
		'panel' => 'home_decor_store_theme_options',
		'title' => esc_html__( 'Header Options', 'home-decor-store' ),
	)
);


// Add setting for sticky header
$wp_customize->add_setting(
	'home_decor_store_enable_sticky_header',
	array(
		'sanitize_callback' => 'home_decor_store_sanitize_switch',
		'default'           => false,
	)
);

// Add control for sticky header setting
$wp_customize->add_control(
	new Home_Decor_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'home_decor_store_enable_sticky_header',
		array(
			'label'   => esc_html__( 'Enable Sticky Header', 'home-decor-store' ),
			'section' => 'home_decor_store_header_options',
		)
	)
);

// Header Options - Header Wishlist Url.
$wp_customize->add_setting(
	'home_decor_store_header_wishlist_url',
	array(
		'default'           => '#',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'home_decor_store_header_wishlist_url',
	array(
		'label'           => esc_html__( 'Wishlist Url', 'home-decor-store' ),
		'section'         => 'home_decor_store_header_options',
		'type'            => 'url',
	)
);

// Header Options - Enable Search Icon.
$wp_customize->add_setting(
	'home_decor_store_enable_search_icon',
	array(
		'sanitize_callback' => 'home_decor_store_sanitize_switch',
		'default'           => true,
	)
);

$wp_customize->add_control(
	new Home_Decor_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'home_decor_store_enable_search_icon',
		array(
			'label'   => esc_html__( 'Enable Search Icon', 'home-decor-store' ),
			'section' => 'home_decor_store_header_options',
		)
	)
);

// icon // 
$wp_customize->add_setting(
	'home_decor_store_shopping_cart_icon_c',
	array(
        'default' => 'fas fa-shopping-basket',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Home_Decor_Store_Change_Icon_Control($wp_customize, 
	'home_decor_store_shopping_cart_icon_c',
	array(
	    'label'   		=> __('Shopping Cart Icon','home-decor-store'),
	    'section' 		=> 'home_decor_store_header_options',
		'iconset' => 'fa',
	))  
);
$wp_customize->add_setting(
	'home_decor_store_User_cart_icon_c',
	array(
        'default' => 'fas fa-user',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Home_Decor_Store_Change_Icon_Control($wp_customize, 
	'home_decor_store_User_cart_icon_c',
	array(
	    'label'   		=> __('User Icon','home-decor-store'),
	    'section' 		=> 'home_decor_store_header_options',
		'iconset' => 'fa',
	))  
);
$wp_customize->add_setting(
	'home_decor_store_User_Log_icon_c',
	array(
        'default' => 'fas fa-sign-out-alt',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Home_Decor_Store_Change_Icon_Control($wp_customize, 
	'home_decor_store_User_Log_icon_c',
	array(
	    'label'   		=> __('Logout Icon','home-decor-store'),
	    'section' 		=> 'home_decor_store_header_options',
		'iconset' => 'fa',
	))  
);
$wp_customize->add_setting(
	'home_decor_store_User_wish_icon_c',
	array(
        'default' => 'far fa-heart',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Home_Decor_Store_Change_Icon_Control($wp_customize, 
	'home_decor_store_User_wish_icon_c',
	array(
	    'label'   		=> __('Wishlist Icon','home-decor-store'),
	    'section' 		=> 'home_decor_store_header_options',
		'iconset' => 'fa',
	))  
);

// Add Separator Custom Control
$wp_customize->add_setting( 'home_decor_store_menu_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Home_Decor_Store_Separator_Custom_Control( $wp_customize, 'home_decor_store_menu_separator', array(
	'label' => __( 'Menu Settings', 'home-decor-store' ),
	'section' => 'home_decor_store_header_options',
	'settings' => 'home_decor_store_menu_separator',
)));

$wp_customize->add_setting( 'home_decor_store_menu_font_size', array(
    'default'           => 15,
    'sanitize_callback' => 'absint',
) );

// Add control for site title size
$wp_customize->add_control( 'home_decor_store_menu_font_size', array(
    'type'        => 'number',
    'section'     => 'home_decor_store_header_options',
    'label'       => __( 'Menu Font Size ', 'home-decor-store' ),
    'input_attrs' => array(
        'min'  => 10,
        'max'  => 100,
        'step' => 1,
    ),
));

$wp_customize->add_setting( 'home_decor_store_menu_text_transform', array(
    'default'           => 'none', // Default value for text transform
    'sanitize_callback' => 'sanitize_text_field',
) );

// Add control for menu text transform
$wp_customize->add_control( 'home_decor_store_menu_text_transform', array(
    'type'     => 'select',
    'section'  => 'home_decor_store_header_options', // Adjust the section as needed
    'label'    => __( 'Menu Text Transform', 'home-decor-store' ),
    'choices'  => array(
        'none'       => __( 'None', 'home-decor-store' ),
        'capitalize' => __( 'Capitalize', 'home-decor-store' ),
        'uppercase'  => __( 'Uppercase', 'home-decor-store' ),
        'lowercase'  => __( 'Lowercase', 'home-decor-store' ),
    ),
) );

// Menu Text Color 
$wp_customize->add_setting(
	'home_decor_store_menu_text_color', 
	array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize, 
		'home_decor_store_menu_text_color', 
		array(
			'label' => __('Menu Color', 'home-decor-store'),
			'section' => 'home_decor_store_header_options',
		)
	)
);

// Sub Menu Text Color 
$wp_customize->add_setting(
	'home_decor_store_sub_menu_text_color', 
	array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize, 
		'home_decor_store_sub_menu_text_color', 
		array(
			'label' => __('Sub Menu Color', 'home-decor-store'),
			'section' => 'home_decor_store_header_options',
		)
	)
);

// ----------------------------------------SITE IDENTITY----------------------------------------------------

// Site Logo - Enable Setting.
$wp_customize->add_setting(
	'home_decor_store_enable_site_logo',
	array(
		'default'           => true, // Default is to display the logo.
		'sanitize_callback' => 'home_decor_store_sanitize_switch', // Sanitize using a custom switch function.
	)
);

$wp_customize->add_control(
	new Home_Decor_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'home_decor_store_enable_site_logo',
		array(
			'label'    => esc_html__( 'Enable Site Logo', 'home-decor-store' ),
			'section'  => 'title_tagline', // Section to add this control.
			'settings' => 'home_decor_store_enable_site_logo',
		)
	)
);

// Site Title - Enable Setting.
$wp_customize->add_setting(
	'home_decor_store_enable_site_title_setting',
	array(
		'default'           => false,
		'sanitize_callback' => 'home_decor_store_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Home_Decor_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'home_decor_store_enable_site_title_setting',
		array(
			'label'    => esc_html__( 'Enable Site Title', 'home-decor-store' ),
			'section'  => 'title_tagline',
			'settings' => 'home_decor_store_enable_site_title_setting',
		)
	)
);

// Tagline - Enable Setting.
$wp_customize->add_setting(
	'home_decor_store_enable_tagline_setting',
	array(
		'default'           => false,
		'sanitize_callback' => 'home_decor_store_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Home_Decor_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'home_decor_store_enable_tagline_setting',
		array(
			'label'    => esc_html__( 'Enable Tagline', 'home-decor-store' ),
			'section'  => 'title_tagline',
			'settings' => 'home_decor_store_enable_tagline_setting',
		)
	)
);

$wp_customize->add_setting( 'home_decor_store_site_title_size', array(
    'default'           => 30, // Default font size in pixels
    'sanitize_callback' => 'absint', // Sanitize the input as a positive integer
) );

// Add control for site title size
$wp_customize->add_control( 'home_decor_store_site_title_size', array(
    'type'        => 'number',
    'section'     => 'title_tagline', // You can change this section to your preferred section
    'label'       => __( 'Site Title Font Size ', 'home-decor-store' ),
    'input_attrs' => array(
        'min'  => 10,
        'max'  => 100,
        'step' => 1,
    ),
) );

$wp_customize->add_setting('home_decor_store_site_logo_width', array(
    'default'           => 200,
    'sanitize_callback' => 'home_decor_store_sanitize_range_value',
));

$wp_customize->add_control(new Home_Decor_Store_Customize_Range_Control($wp_customize, 'home_decor_store_site_logo_width', array(
    'label'       => __('Adjust Site Logo Width', 'home-decor-store'),
    'description' => __('This setting controls the Width of Site Logo', 'home-decor-store'),
    'section'     => 'title_tagline',
    'settings'    => 'home_decor_store_site_logo_width',
    'input_attrs' => array(
        'min'  => 0,
        'max'  => 400,
        'step' => 5,
    ),
)));