<?php

/**
 * Typography settings
 *
 * @package home_decor_store
 */

// Typography settings
$wp_customize->add_section(
    'home_decor_store_typography_setting',
    array(
        'panel' => 'home_decor_store_theme_options',
        'title' => esc_html__( 'Typography settings', 'home-decor-store' ),
    )
);

$wp_customize->add_setting(
    'home_decor_store_site_title_font',
    array(
        'default'           => 'Raleway',
        'sanitize_callback' => 'home_decor_store_sanitize_google_fonts',
    )
);

$wp_customize->add_control(
    'home_decor_store_site_title_font',
    array(
        'label'    => esc_html__( 'Site Title Font Family', 'home-decor-store' ),
        'section'  => 'home_decor_store_typography_setting',
        'settings' => 'home_decor_store_site_title_font',
        'type'     => 'select',
        'choices'  => home_decor_store_get_all_google_font_families(),
    )
);

// Typography - Site Description Font.
$wp_customize->add_setting(
	'home_decor_store_site_description_font',
	array(
		'default'           => 'Raleway',
		'sanitize_callback' => 'home_decor_store_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'home_decor_store_site_description_font',
	array(
		'label'    => esc_html__( 'Site Description Font Family', 'home-decor-store' ),
		'section'  => 'home_decor_store_typography_setting',
		'settings' => 'home_decor_store_site_description_font',
		'type'     => 'select',
		'choices'  => home_decor_store_get_all_google_font_families(),
	)
);

// Typography - Header Font.
$wp_customize->add_setting(
	'home_decor_store_header_font',
	array(
		'default'           => 'Cardo',
		'sanitize_callback' => 'home_decor_store_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'home_decor_store_header_font',
	array(
		'label'    => esc_html__( 'Heading Font Family', 'home-decor-store' ),
		'section'  => 'home_decor_store_typography_setting',
		'settings' => 'home_decor_store_header_font',
		'type'     => 'select',
		'choices'  => home_decor_store_get_all_google_font_families(),
	)
);

// Typography - Body Font.
$wp_customize->add_setting(
	'home_decor_store_content_font',
	array(
		'default'           => 'Quicksand',
		'sanitize_callback' => 'home_decor_store_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'home_decor_store_content_font',
	array(
		'label'    => esc_html__( 'Content Font Family', 'home-decor-store' ),
		'section'  => 'home_decor_store_typography_setting',
		'settings' => 'home_decor_store_content_font',
		'type'     => 'select',
		'choices'  => home_decor_store_get_all_google_font_families(),
	)
);
