<?php

/**
 * WooCommerce Settings
 *
 * @package home_decor_store
 */

$wp_customize->add_section(
	'home_decor_store_woocommerce_settings',
	array(
		'panel' => 'home_decor_store_theme_options',
		'title' => esc_html__( 'WooCommerce Settings', 'home-decor-store' ),
	)
);

//WooCommerce - Products per page.
$wp_customize->add_setting( 'home_decor_store_products_per_page', array(
    'default'           => 9,
    'sanitize_callback' => 'absint',
));

$wp_customize->add_control( 'home_decor_store_products_per_page', array(
    'type'        => 'number',
    'section'     => 'home_decor_store_woocommerce_settings',
    'label'       => __( 'Products Per Page', 'home-decor-store' ),
    'input_attrs' => array(
        'min'  => 0,
        'max'  => 50,
        'step' => 1,
    ),
));

//WooCommerce - Products per row.
$wp_customize->add_setting( 'home_decor_store_products_per_row', array(
    'default'           => '3',
    'sanitize_callback' => 'home_decor_store_sanitize_choices',
) );

$wp_customize->add_control( 'home_decor_store_products_per_row', array(
    'label'    => __( 'Products Per Row', 'home-decor-store' ),
    'section'  => 'home_decor_store_woocommerce_settings',
    'settings' => 'home_decor_store_products_per_row',
    'type'     => 'select',
    'choices'  => array(
        '2' => '2',
		'3' => '3',
		'4' => '4',
    ),
) );

//WooCommerce - Show / Hide Related Product.
$wp_customize->add_setting(
	'home_decor_store_related_product_show_hide',
	array(
		'default'           => true,
		'sanitize_callback' => 'home_decor_store_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Home_Decor_Store_Toggle_Switch_Custom_Control(
		$wp_customize,
		'home_decor_store_related_product_show_hide',
		array(
			'label'   => esc_html__( 'Show / Hide Related product', 'home-decor-store' ),
			'section' => 'home_decor_store_woocommerce_settings',
		)
	)
);

//WooCommerce - Product Sale Position.
$wp_customize->add_setting(
	'home_decor_store_product_sale_position', 
	array(
		'default' => 'left',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'home_decor_store_product_sale_position', 
	array(
		'label' => __('Product Sale Position', 'home-decor-store'),
		'section' => 'home_decor_store_woocommerce_settings',
		'settings' => 'home_decor_store_product_sale_position',
		'type' => 'radio',
		'choices' => 
	array(
		'left' => __('Left', 'home-decor-store'),
		'right' => __('Right', 'home-decor-store'),
	),
));