<?php

/**
 * Dynamic CSS
 */
function home_decor_store_dynamic_css() {
	$home_decor_store_primary_color = get_theme_mod( 'primary_color', '#ba7b57' );

	$home_decor_store_site_title_font       = get_theme_mod( 'home_decor_store_site_title_font', 'Raleway' );
	$home_decor_store_site_description_font = get_theme_mod( 'home_decor_store_site_description_font', 'Raleway' );
	$home_decor_store_header_font           = get_theme_mod( 'home_decor_store_header_font', 'Cardo' );
	$home_decor_store_content_font             = get_theme_mod( 'home_decor_store_content_font', 'Quicksand' );

	// Enqueue Google Fonts
	$home_decor_store_fonts_url = home_decor_store_get_fonts_url();
	if ( ! empty( $home_decor_store_fonts_url ) ) {
		wp_enqueue_style( 'home-decor-store-google-fonts', esc_url( $home_decor_store_fonts_url ), array(), null );
	}

	$home_decor_store_custom_css  = '';
	$home_decor_store_custom_css .= '
    /* Color */
    :root {
        --primary-color: ' . esc_attr( $home_decor_store_primary_color ) . ';
        --header-text-color: ' . esc_attr( '#' . get_header_textcolor() ) . ';
    }
    ';

	$home_decor_store_custom_css .= '
    /* Typography */
    :root {
        --font-heading: "' . esc_attr( $home_decor_store_header_font ) . '", serif;
        --font-main: -apple-system, BlinkMacSystemFont, "' . esc_attr( $home_decor_store_content_font ) . '", "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif;
    }

    body,
	button, input, select, optgroup, textarea, p {
        font-family: "' . esc_attr( $home_decor_store_content_font ) . '", serif;
	}

	.site-identity p.site-title, h1.site-title a, h1.site-title, p.site-title a, .site-branding h1.site-title a {
        font-family: "' . esc_attr( $home_decor_store_site_title_font ) . '", serif;
	}
    
	p.site-description {
        font-family: "' . esc_attr( $home_decor_store_site_description_font ) . '", serif !important;
	}
    ';

	wp_add_inline_style( 'home-decor-store-style', $home_decor_store_custom_css );
}
add_action( 'wp_enqueue_scripts', 'home_decor_store_dynamic_css', 99 );