<?php

/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package home_decor_store
 */


 function home_decor_store_customize_css() {
    ?>
    <style type="text/css">
        :root {
            --primary-color: <?php echo esc_html( get_theme_mod( 'primary_color', '#ba7b57' ) ); ?>;
        }
    </style>
    <?php
}
add_action( 'wp_head', 'home_decor_store_customize_css' );



function home_decor_store_enqueue_selected_fonts() {
    $home_decor_store_fonts_url = home_decor_store_get_fonts_url();
    if (!empty($home_decor_store_fonts_url)) {
        wp_enqueue_style('home-decor-store-google-fonts', $home_decor_store_fonts_url, array(), null);
    }
}
add_action('wp_enqueue_scripts', 'home_decor_store_enqueue_selected_fonts');

function home_decor_store_layout_customizer_css() {
    $home_decor_store_margin = get_theme_mod('home_decor_store_layout_width_margin', 50);
    ?>
    <style type="text/css">
        body.site-boxed--layout #page  {
            margin: 0 <?php echo esc_attr($home_decor_store_margin); ?>px;
        }
    </style>
    <?php
}
add_action('wp_head', 'home_decor_store_layout_customizer_css');

function home_decor_store_blog_layout_customizer_css() {
    // Retrieve the blog layout option
    $home_decor_store_blog_layout_option = get_theme_mod('home_decor_store_blog_layout_option_setting', 'Left');

    // Initialize custom CSS variable
    $home_decor_store_custom_css = '';

    // Generate custom CSS based on the layout option
    if ($home_decor_store_blog_layout_option === 'Default') {
        $home_decor_store_custom_css .= '.mag-post-detail { text-align: center; }';
    } elseif ($home_decor_store_blog_layout_option === 'Left') {
        $home_decor_store_custom_css .= '.mag-post-detail { text-align: left; }';
    } elseif ($home_decor_store_blog_layout_option === 'Right') {
        $home_decor_store_custom_css .= '.mag-post-detail { text-align: right; }';
    }

    // Output the combined CSS
    ?>
    <style type="text/css">
        <?php echo wp_kses($home_decor_store_custom_css, array( 'style' => array(), 'text-align' => array() )); ?>
    </style>
    <?php
}
add_action('wp_head', 'home_decor_store_blog_layout_customizer_css');

// Featured Image Dimension
function home_decor_store_custom_featured_image_css() {
    $home_decor_store_dimension = get_theme_mod('home_decor_store_blog_post_featured_image_dimension', 'default');
    $home_decor_store_width = get_theme_mod('home_decor_store_blog_post_featured_image_custom_width', '');
    $home_decor_store_height = get_theme_mod('home_decor_store_blog_post_featured_image_custom_height', '');
    
    if ($home_decor_store_dimension === 'custom' && $home_decor_store_width && $home_decor_store_height) {
        $home_decor_store_custom_css = "body:not(.single-post) .mag-post-single .mag-post-img img { width: {$home_decor_store_width}px !important; height: {$home_decor_store_height}px !important; }";
        wp_add_inline_style('home-decor-store-style', $home_decor_store_custom_css);
    }
}
add_action('wp_enqueue_scripts', 'home_decor_store_custom_featured_image_css');

function home_decor_store_sidebar_width_customizer_css() {
    $home_decor_store_sidebar_width = get_theme_mod('home_decor_store_sidebar_width', '30');
    ?>
    <style type="text/css">
        .right-sidebar .asterthemes-wrapper .asterthemes-page {
            grid-template-columns: auto <?php echo esc_attr($home_decor_store_sidebar_width); ?>%;
        }
        .left-sidebar .asterthemes-wrapper .asterthemes-page {
            grid-template-columns: <?php echo esc_attr($home_decor_store_sidebar_width); ?>% auto;
        }
    </style>
    <?php
}
add_action('wp_head', 'home_decor_store_sidebar_width_customizer_css');

if ( ! function_exists( 'home_decor_store_get_page_title' ) ) {
    function home_decor_store_get_page_title() {
        $home_decor_store_title = '';

        if (is_404()) {
            $home_decor_store_title = esc_html__('Page Not Found', 'home-decor-store');
        } elseif (is_search()) {
            $home_decor_store_title = esc_html__('Search Results for: ', 'home-decor-store') . esc_html(get_search_query());
        } elseif (is_home() && !is_front_page()) {
            $home_decor_store_title = esc_html__('Blogs', 'home-decor-store');
        } elseif (function_exists('is_shop') && is_shop()) {
            $home_decor_store_title = esc_html__('Shop', 'home-decor-store');
        } elseif (is_page()) {
            $home_decor_store_title = get_the_title();
        } elseif (is_single()) {
            $home_decor_store_title = get_the_title();
        } elseif (is_archive()) {
            $home_decor_store_title = get_the_archive_title();
        } else {
            $home_decor_store_title = get_the_archive_title();
        }

        return apply_filters('home_decor_store_page_title', $home_decor_store_title);
    }
}

if ( ! function_exists( 'home_decor_store_has_page_header' ) ) {
    function home_decor_store_has_page_header() {
        // Default to true (display header)
        $home_decor_store_return = true;

        // Custom conditions for disabling the header
        if ('hide-all-devices' === get_theme_mod('home_decor_store_page_header_visibility', 'all-devices')) {
            $home_decor_store_return = false;
        }

        // Apply filters and return
        return apply_filters('home_decor_store_display_page_header', $home_decor_store_return);
    }
}

if ( ! function_exists( 'home_decor_store_page_header_style' ) ) {
    function home_decor_store_page_header_style() {
        $home_decor_store_style = get_theme_mod('home_decor_store_page_header_style', 'default');
        return apply_filters('home_decor_store_page_header_style', $home_decor_store_style);
    }
}

function home_decor_store_page_title_customizer_css() {
    $home_decor_store_layout_option = get_theme_mod('home_decor_store_page_header_layout', 'left');
    ?>
    <style type="text/css">
        .asterthemes-wrapper.page-header-inner {
            <?php if ($home_decor_store_layout_option === 'flex') : ?>
                display: flex;
                justify-content: space-between;
                align-items: center;
            <?php else : ?>
                text-align: <?php echo esc_attr($home_decor_store_layout_option); ?>;
            <?php endif; ?>
        }
    </style>
    <?php
}
add_action('wp_head', 'home_decor_store_page_title_customizer_css');

function home_decor_store_pagetitle_height_css() {
    $home_decor_store_height = get_theme_mod('home_decor_store_pagetitle_height', 50);
    ?>
    <style type="text/css">
        header.page-header {
            padding: <?php echo esc_attr($home_decor_store_height); ?>px 0;
        }
    </style>
    <?php
}
add_action('wp_head', 'home_decor_store_pagetitle_height_css');

function add_custom_script_in_footer() {
    if ( get_theme_mod( 'home_decor_store_enable_sticky_header', false ) ) {
        ?>
        <script>
            jQuery(document).ready(function($) {
                $(window).on('scroll', function() {
                    var scroll = $(window).scrollTop();
                    if (scroll > 0) {
                        $('.navigation-part.hello').addClass('is-sticky');
                    } else {
                        $('.navigation-part.hello').removeClass('is-sticky');
                    }
                });
            });
        </script>
        <?php
    }
}
add_action( 'wp_footer', 'add_custom_script_in_footer' );

function home_decor_store_site_logo_width() {
    $home_decor_store_site_logo_width = get_theme_mod('home_decor_store_site_logo_width', 200);
    ?>
    <style type="text/css">
        .site-logo img {
            max-width: <?php echo esc_attr($home_decor_store_site_logo_width); ?>px;
        }
    </style>
    <?php
}
add_action('wp_head', 'home_decor_store_site_logo_width');

function home_decor_store_menu_font_size_css() {
    $home_decor_store_menu_font_size = get_theme_mod('home_decor_store_menu_font_size', 15);
    ?>
    <style type="text/css">
        .main-navigation a {
            font-size: <?php echo esc_attr($home_decor_store_menu_font_size); ?>px;
        }
    </style>
    <?php
}
add_action('wp_head', 'home_decor_store_menu_font_size_css');

function home_decor_store_sidebar_widget_font_size_css() {
    $home_decor_store_sidebar_widget_font_size = get_theme_mod('home_decor_store_sidebar_widget_font_size', 24);
    ?>
    <style type="text/css">
        h2.wp-block-heading,aside#secondary .widgettitle,aside#secondary .widget-title {
            font-size: <?php echo esc_attr($home_decor_store_sidebar_widget_font_size); ?>px;
        }
    </style>
    <?php
}
add_action('wp_head', 'home_decor_store_sidebar_widget_font_size_css');

// Woocommerce Related Products Settings
function home_decor_store_related_product_css() {
    $home_decor_store_related_product_show_hide = get_theme_mod('home_decor_store_related_product_show_hide', true);

    if ( $home_decor_store_related_product_show_hide != true) {
        ?>
        <style type="text/css">
            .related.products {
                display: none;
            }
        </style>
        <?php
    }
}
add_action('wp_head', 'home_decor_store_related_product_css');

// Woocommerce Product Sale Position 
function home_decor_store_product_sale_position_customizer_css() {
    $home_decor_store_layout_option = get_theme_mod('home_decor_store_product_sale_position', 'left');
    ?>
    <style type="text/css">
        .woocommerce ul.products li.product .onsale{
            <?php if ($home_decor_store_layout_option === 'left') : ?>
                right: auto;
                left: 0px;
            <?php else : ?>
                left: auto;
                right: 0px;
            <?php endif; ?>
        }
    </style>
    <?php
}
add_action('wp_head', 'home_decor_store_product_sale_position_customizer_css'); 

//Copyright Alignment
function home_decor_store_footer_copyright_alignment_css() {
    $home_decor_store_footer_bottom_align = get_theme_mod( 'home_decor_store_footer_bottom_align', 'center' );   
    ?>
    <style type="text/css">
        .site-footer .site-footer-bottom .site-footer-bottom-wrapper {
            justify-content: <?php echo esc_attr( $home_decor_store_footer_bottom_align ); ?> 
        }

        /* Mobile Specific */
        @media screen and (max-width: 575px) {
            .site-footer .site-footer-bottom .site-footer-bottom-wrapper {
                justify-content: center;
                text-align:center;
            }
        }
    </style>
    <?php
}
add_action( 'wp_head', 'home_decor_store_footer_copyright_alignment_css' );

// Preloader Background Color Setting
function home_decor_store_preloader_background_colors_css() {
    $home_decor_store_preloader_background_color_setting = get_theme_mod('home_decor_store_preloader_background_color_setting', '');
        // Only output CSS if a color is set
        if (empty($home_decor_store_preloader_background_color_setting)) {
            return;
        }
    ?>
    <style type="text/css">
        #loader {
            background-color: <?php echo esc_attr($home_decor_store_preloader_background_color_setting); ?>;
        }
    </style>
    <?php
}
add_action('wp_head', 'home_decor_store_preloader_background_colors_css');

// Preloader Background Image Setting
function home_decor_store_preloader_background_image_css() {
    $home_decor_store_preloader_background_image_setting = get_theme_mod('home_decor_store_preloader_background_image_setting', '');
        // Only output CSS if the background image is set
        if (empty($home_decor_store_preloader_background_image_setting)) {
            return;
        }
    ?>
    <style type="text/css">
        #loader {
            background-image: url('<?php echo esc_url($home_decor_store_preloader_background_image_setting); ?>');
            background-size: cover;
            background-repeat: no-repeat;
            background-position: center;
        }
    </style>
    <?php
}
add_action('wp_head', 'home_decor_store_preloader_background_image_css');

//Footer Heading Alignment
function home_decor_store_footer_heading_alignment_css() {
    $home_decor_store_footer_header_align = get_theme_mod( 'home_decor_store_footer_header_align', 'left' );   
    ?>
    <style type="text/css">
        .site-footer h4, footer#colophon h2.wp-block-heading, footer#colophon .widgettitle, footer#colophon .widget-title {
            text-align: <?php echo esc_attr( $home_decor_store_footer_header_align ); ?> 
        }
    </style>
    <?php
}
add_action( 'wp_head', 'home_decor_store_footer_heading_alignment_css' );