<?php
function home_decor_store_get_all_google_fonts() {
    $home_decor_store_webfonts_json = get_template_directory() . '/theme-library/google-webfonts.json';
    if ( ! file_exists( $home_decor_store_webfonts_json ) ) {
        return array();
    }

    $home_decor_store_fonts_json_data = file_get_contents( $home_decor_store_webfonts_json );
    if ( false === $home_decor_store_fonts_json_data ) {
        return array();
    }

    $home_decor_store_all_fonts = json_decode( $home_decor_store_fonts_json_data, true );
    if ( json_last_error() !== JSON_ERROR_NONE ) {
        return array();
    }

    $home_decor_store_google_fonts = array();
    foreach ( $home_decor_store_all_fonts as $home_decor_store_font ) {
        $home_decor_store_google_fonts[ $home_decor_store_font['family'] ] = array(
            'family'   => $home_decor_store_font['family'],
            'variants' => $home_decor_store_font['variants'],
        );
    }
    return $home_decor_store_google_fonts;
}


function home_decor_store_get_all_google_font_families() {
    $home_decor_store_google_fonts  = home_decor_store_get_all_google_fonts();
    $home_decor_store_font_families = array();
    foreach ( $home_decor_store_google_fonts as $home_decor_store_font ) {
        $home_decor_store_font_families[ $home_decor_store_font['family'] ] = $home_decor_store_font['family'];
    }
    return $home_decor_store_font_families;
}

function home_decor_store_get_fonts_url() {
    $home_decor_store_fonts_url = '';
    $home_decor_store_fonts     = array();

    $home_decor_store_all_fonts = home_decor_store_get_all_google_fonts();

    if ( ! empty( get_theme_mod( 'home_decor_store_site_title_font', 'Raleway' ) ) ) {
        $home_decor_store_fonts[] = get_theme_mod( 'home_decor_store_site_title_font', 'Raleway' );
    }

    if ( ! empty( get_theme_mod( 'home_decor_store_site_description_font', 'Raleway' ) ) ) {
        $home_decor_store_fonts[] = get_theme_mod( 'home_decor_store_site_description_font', 'Raleway' );
    }

    if ( ! empty( get_theme_mod( 'home_decor_store_header_font', 'Epilogue' ) ) ) {
        $home_decor_store_fonts[] = get_theme_mod( 'home_decor_store_header_font', 'Epilogue' );
    }

    if ( ! empty( get_theme_mod( 'home_decor_store_content_font', 'Raleway' ) ) ) {
        $home_decor_store_fonts[] = get_theme_mod( 'home_decor_store_content_font', 'Raleway' );
    }

    $home_decor_store_fonts = array_unique( $home_decor_store_fonts );

    foreach ( $home_decor_store_fonts as $home_decor_store_font ) {
        $home_decor_store_variants      = $home_decor_store_all_fonts[ $home_decor_store_font ]['variants'];
        $home_decor_store_font_family[] = $home_decor_store_font . ':' . implode( ',', $home_decor_store_variants );
    }

    $home_decor_store_query_args = array(
        'family' => urlencode( implode( '|', $home_decor_store_font_family ) ),
    );

    if ( ! empty( $home_decor_store_font_family ) ) {
        $home_decor_store_fonts_url = add_query_arg( $home_decor_store_query_args, 'https://fonts.googleapis.com/css' );
    }

    return $home_decor_store_fonts_url;
}