<?php

/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package home_decor_store
 */

function home_decor_store_body_classes( $home_decor_store_classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$home_decor_store_classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'sidebar-1' ) ) {
		$home_decor_store_classes[] = 'no-sidebar';
	}

	$home_decor_store_classes[] = home_decor_store_sidebar_layout();

	return $home_decor_store_classes;
}
add_filter( 'body_class', 'home_decor_store_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function home_decor_store_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'home_decor_store_pingback_header' );


/**
 * Get all posts for customizer Post content type.
 */
function home_decor_store_get_post_choices() {
	$home_decor_store_choices = array( '' => esc_html__( '--Select--', 'home-decor-store' ) );
	$home_decor_store_args    = array( 'numberposts' => -1 );
	$home_decor_store_posts   = get_posts( $home_decor_store_args );

	foreach ( $home_decor_store_posts as $home_decor_store_post ) {
		$home_decor_store_id             = $home_decor_store_post->ID;
		$home_decor_store_title          = $home_decor_store_post->post_title;
		$home_decor_store_choices[ $home_decor_store_id ] = $home_decor_store_title;
	}

	return $home_decor_store_choices;
}

/**
 * Get all pages for customizer Page content type.
 */
function home_decor_store_get_page_choices() {
	$home_decor_store_choices = array( '' => esc_html__( '--Select--', 'home-decor-store' ) );
	$home_decor_store_pages   = get_pages();

	foreach ( $home_decor_store_pages as $home_decor_store_page ) {
		$home_decor_store_choices[ $home_decor_store_page->ID ] = $home_decor_store_page->post_title;
	}

	return $home_decor_store_choices;
}

/**
 * Get all categories for customizer Category content type.
 */
function home_decor_store_get_post_cat_choices() {
	$home_decor_store_choices = array( '' => esc_html__( '--Select--', 'home-decor-store' ) );
	$home_decor_store_cats    = get_categories();

	foreach ( $home_decor_store_cats as $home_decor_store_cat ) {
		$home_decor_store_choices[ $home_decor_store_cat->term_id ] = $home_decor_store_cat->name;
	}

	return $home_decor_store_choices;
}

/**
 * Get all donation forms for customizer form content type.
 */
function home_decor_store_get_post_donation_form_choices() {
	$home_decor_store_choices = array( '' => esc_html__( '--Select--', 'home-decor-store' ) );
	$home_decor_store_posts   = get_posts(
		array(
			'post_type'   => 'give_forms',
			'numberposts' => -1,
		)
	);
	foreach ( $home_decor_store_posts as $home_decor_store_post ) {
		$home_decor_store_choices[ $home_decor_store_post->ID ] = $home_decor_store_post->post_title;
	}
	return $home_decor_store_choices;
}

if ( ! function_exists( 'home_decor_store_excerpt_length' ) ) :
	/**
	 * Excerpt length.
	 */
	function home_decor_store_excerpt_length( $home_decor_store_length ) {
		if ( is_admin() ) {
			return $home_decor_store_length;
		}

		return get_theme_mod( 'home_decor_store_excerpt_length', 20 );
	}
endif;
add_filter( 'excerpt_length', 'home_decor_store_excerpt_length', 999 );

if ( ! function_exists( 'home_decor_store_excerpt_more' ) ) :
	/**
	 * Excerpt more.
	 */
	function home_decor_store_excerpt_more( $home_decor_store_more ) {
		if ( is_admin() ) {
			return $home_decor_store_more;
		}

		return '&hellip;';
	}
endif;
add_filter( 'excerpt_more', 'home_decor_store_excerpt_more' );

if ( ! function_exists( 'home_decor_store_sidebar_layout' ) ) {
	/**
	 * Get sidebar layout.
	 */
	function home_decor_store_sidebar_layout() {
		$home_decor_store_sidebar_position      = get_theme_mod( 'home_decor_store_sidebar_position', 'right-sidebar' );
		$home_decor_store_sidebar_position_post = get_theme_mod( 'home_decor_store_post_sidebar_position', 'right-sidebar' );
		$home_decor_store_sidebar_position_page = get_theme_mod( 'home_decor_store_page_sidebar_position', 'right-sidebar' );

		if ( is_single() ) {
			$home_decor_store_sidebar_position = $home_decor_store_sidebar_position_post;
		} elseif ( is_page() ) {
			$home_decor_store_sidebar_position = $home_decor_store_sidebar_position_page;
		}

		return $home_decor_store_sidebar_position;
	}
}

if ( ! function_exists( 'home_decor_store_is_sidebar_enabled' ) ) {
	/**
	 * Check if sidebar is enabled.
	 */
	function home_decor_store_is_sidebar_enabled() {
		$home_decor_store_sidebar_position      = get_theme_mod( 'home_decor_store_sidebar_position', 'right-sidebar' );
		$home_decor_store_sidebar_position_post = get_theme_mod( 'home_decor_store_post_sidebar_position', 'right-sidebar' );
		$home_decor_store_sidebar_position_page = get_theme_mod( 'home_decor_store_page_sidebar_position', 'right-sidebar' );

		$home_decor_store_sidebar_enabled = true;
		if ( is_home() || is_archive() || is_search() ) {
			if ( 'no-sidebar' === $home_decor_store_sidebar_position ) {
				$home_decor_store_sidebar_enabled = false;
			}
		} elseif ( is_single() ) {
			if ( 'no-sidebar' === $home_decor_store_sidebar_position || 'no-sidebar' === $home_decor_store_sidebar_position_post ) {
				$home_decor_store_sidebar_enabled = false;
			}
		} elseif ( is_page() ) {
			if ( 'no-sidebar' === $home_decor_store_sidebar_position || 'no-sidebar' === $home_decor_store_sidebar_position_page ) {
				$home_decor_store_sidebar_enabled = false;
			}
		}
		return $home_decor_store_sidebar_enabled;
	}
}

if ( ! function_exists( 'home_decor_store_get_homepage_sections ' ) ) {
	/**
	 * Returns homepage sections.
	 */
	function home_decor_store_get_homepage_sections() {
		$home_decor_store_sections = array(
			'banner'  => esc_html__( 'Banner Section', 'home-decor-store' ),
			'service' => esc_html__( 'home-decor-store Section', 'home-decor-store' ),
		);
		return $home_decor_store_sections;
	}
}

/**
 * Renders customizer section link
 */
function home_decor_store_section_link( $home_decor_store_section_id ) {
	$home_decor_store_section_name      = str_replace( 'home_decor_store_', ' ', $home_decor_store_section_id );
	$home_decor_store_section_name      = str_replace( '_', ' ', $home_decor_store_section_name );
	$home_decor_store_starting_notation = '#';
	?>
	<span class="section-link">
		<span class="section-link-title"><?php echo esc_html( $home_decor_store_section_name ); ?></span>
	</span>
	<style type="text/css">
		<?php echo $home_decor_store_starting_notation . $home_decor_store_section_id; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>:hover .section-link {
			visibility: visible;
		}
	</style>
	<?php
}

/**
 * Adds customizer section link css
 */
function home_decor_store_section_link_css() {
	if ( is_customize_preview() ) {
		?>
		<style type="text/css">
			.section-link {
				visibility: hidden;
				background-color: black;
				position: relative;
				top: 80px;
				z-index: 99;
				left: 40px;
				color: #fff;
				text-align: center;
				font-size: 20px;
				border-radius: 10px;
				padding: 20px 10px;
				text-transform: capitalize;
			}

			.section-link-title {
				padding: 0 10px;
			}

			.banner-section {
				position: relative;
			}

			.banner-section .section-link {
				position: absolute;
				top: 100px;
			}
		</style>
		<?php
	}
}
add_action( 'wp_head', 'home_decor_store_section_link_css' );

/**
 * Breadcrumb.
 */
function home_decor_store_breadcrumb( $home_decor_store_args = array() ) {
	if ( ! get_theme_mod( 'home_decor_store_enable_breadcrumb', true ) ) {
		return;
	}

	$home_decor_store_args = array(
		'show_on_front' => false,
		'show_title'    => true,
		'show_browse'   => false,
	);
	breadcrumb_trail( $home_decor_store_args );
}
add_action( 'home_decor_store_breadcrumb', 'home_decor_store_breadcrumb', 10 );

/**
 * Add separator for breadcrumb trail.
 */
function home_decor_store_breadcrumb_trail_print_styles() {
	$home_decor_store_breadcrumb_separator = get_theme_mod( 'home_decor_store_breadcrumb_separator', '/' );

	$home_decor_store_style = '
		.trail-items li::after {
			content: "' . $home_decor_store_breadcrumb_separator . '";
		}'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

	$home_decor_store_style = apply_filters( 'home_decor_store_breadcrumb_trail_inline_style', trim( str_replace( array( "\r", "\n", "\t", '  ' ), '', $home_decor_store_style ) ) );

	if ( $home_decor_store_style ) {
		echo "\n" . '<style type="text/css" id="breadcrumb-trail-css">' . $home_decor_store_style . '</style>' . "\n"; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}
}
add_action( 'wp_head', 'home_decor_store_breadcrumb_trail_print_styles' );

/**
 * Pagination for archive.
 */
function home_decor_store_render_posts_pagination() {
	$home_decor_store_is_pagination_enabled = get_theme_mod( 'home_decor_store_enable_pagination', true );
	if ( $home_decor_store_is_pagination_enabled ) {
		$home_decor_store_pagination_type = get_theme_mod( 'home_decor_store_pagination_type', 'default' );
		if ( 'default' === $home_decor_store_pagination_type ) :
			the_posts_navigation();
		else :
			the_posts_pagination();
		endif;
	}
}
add_action( 'home_decor_store_posts_pagination', 'home_decor_store_render_posts_pagination', 10 );

/**
 * Pagination for single post.
 */
function home_decor_store_render_post_navigation() {
	the_post_navigation(
		array(
			'prev_text' => '<span>&#10229;</span> <span class="nav-title">%title</span>',
			'next_text' => '<span class="nav-title">%title</span> <span>&#10230;</span>',
		)
	);
}
add_action( 'home_decor_store_post_navigation', 'home_decor_store_render_post_navigation' );

/**
 * Adds footer copyright text.
 */

function home_decor_store_output_footer_copyright_content() {
    $home_decor_store_theme_data = wp_get_theme();
    $home_decor_store_copyright_text = get_theme_mod('home_decor_store_footer_copyright_text');

    if (!empty($home_decor_store_copyright_text)) {
        $home_decor_store_text = $home_decor_store_copyright_text;
    } else {
        $home_decor_store_default_text = '<a href="'. esc_url(__('https://asterthemes.com/products/free-decor-wordpress-theme','home-decor-store')) . '" target="_blank"> ' . esc_html($home_decor_store_theme_data->get('Name')) . '</a>' . '&nbsp;' . esc_html__('by', 'home-decor-store') . '&nbsp;<a target="_blank" href="' . esc_url($home_decor_store_theme_data->get('AuthorURI')) . '">' . esc_html(ucwords($home_decor_store_theme_data->get('Author'))) . '</a>';
		/* translators: %s: WordPress.org URL */
        $home_decor_store_default_text .= sprintf(esc_html__(' | Powered by %s', 'home-decor-store'), '<a href="' . esc_url(__('https://wordpress.org/', 'home-decor-store')) . '" target="_blank">WordPress</a>. ');

        $home_decor_store_text = $home_decor_store_default_text;
    }
    ?>
    <span><?php echo wp_kses_post($home_decor_store_text); ?></span>
    <?php
}
add_action('home_decor_store_footer_copyright', 'home_decor_store_output_footer_copyright_content');

/**
 * GET START FUNCTION
 */

function home_decor_store_getpage_css($hook) {
	wp_enqueue_script( 'home-decor-store-admin-script', get_template_directory_uri() . '/resource/js/home-decor-store-admin-notice-script.js', array( 'jquery' ) );
    wp_localize_script( 'home-decor-store-admin-script', 'home_decor_store_ajax_object',
        array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
    );
    wp_enqueue_style( 'home-decor-store-notice-style', get_template_directory_uri() . '/resource/css/notice.css' );
}

add_action( 'admin_enqueue_scripts', 'home_decor_store_getpage_css' );


add_action('wp_ajax_home_decor_store_dismissable_notice', 'home_decor_store_dismissable_notice');
	function home_decor_store_switch_theme() {
	    delete_user_meta(get_current_user_id(), 'home_decor_store_dismissable_notice');
	}
	add_action('after_switch_theme', 'home_decor_store_switch_theme');
	function home_decor_store_dismissable_notice() {
	    update_user_meta(get_current_user_id(), 'home_decor_store_dismissable_notice', true);
	    die();
	}

function home_decor_store_deprecated_hook_admin_notice() {
    global $home_decor_store_pagenow;
    
    // Check if the current page is the one where you don't want the notice to appear
    if ( $home_decor_store_pagenow === 'themes.php' && isset( $_GET['page'] ) && $_GET['page'] === 'home-decor-store-getting-started' ) {
        return;
    }

    $home_decor_store_dismissed = get_user_meta( get_current_user_id(), 'home_decor_store_dismissable_notice', true );
    if ( !$home_decor_store_dismissed) { ?>
        <div class="getstrat updated notice notice-success is-dismissible notice-get-started-class">
            <div class="at-admin-content" >
                <h2><?php esc_html_e('Welcome to Home Decor Store', 'home-decor-store'); ?></h2>
                <p><?php _e('Explore the features of our Pro Theme and take your Home Decor to the next level.', 'home-decor-store'); ?></p>
                <p ><?php _e('Get Started With Theme By Clicking On Getting Started.', 'home-decor-store'); ?><p>
                <div style="display: flex; justify-content: center;">
                    <a class="admin-notice-btn button button-primary button-hero" href="<?php echo esc_url( admin_url( 'themes.php?page=home-decor-store-getting-started' )); ?>"><?php esc_html_e( 'Get started', 'home-decor-store' ) ?></a>
                    <a  class="admin-notice-btn button button-primary button-hero" target="_blank" href="https://demo.asterthemes.com/home-decor-store"><?php esc_html_e('View Demo', 'home-decor-store') ?></a>
                    <a  class="admin-notice-btn button button-primary button-hero" target="_blank" href="https://asterthemes.com/products/home-decor-wordpress-theme"><?php esc_html_e('Buy Now', 'home-decor-store') ?></a>
                    <a  class="admin-notice-btn button button-primary button-hero" target="_blank" href="https://demo.asterthemes.com/docs/home-decor-store-free"><?php esc_html_e('Free Doc', 'home-decor-store') ?></a>
                </div>
            </div>
            <div class="at-admin-image">
                <img style="width: 100%;max-width: 320px;line-height: 40px;display: inline-block;vertical-align: top;border: 2px solid #ddd;border-radius: 4px;" src="<?php echo esc_url(get_stylesheet_directory_uri()) .'/screenshot.png'; ?>" />
            </div>
        </div>
    <?php }
}

add_action( 'admin_notices', 'home_decor_store_deprecated_hook_admin_notice' );

//Admin Notice For Getstart
function home_decor_store_ajax_notice_handler() {
    if ( isset( $_POST['type'] ) ) {
        $type = sanitize_text_field( wp_unslash( $_POST['type'] ) );
        update_option( 'dismissed-' . $type, TRUE );
    }
}	

if ( ! function_exists( 'home_decor_store_footer_widget' ) ) :
	function home_decor_store_footer_widget() {
		$home_decor_store_footer_widget_column = get_theme_mod('home_decor_store_footer_widget_column','4');

		$home_decor_store_column_class = '';
		if ($home_decor_store_footer_widget_column == '1') {
			$home_decor_store_column_class = 'one-column';
		} elseif ($home_decor_store_footer_widget_column == '2') {
			$home_decor_store_column_class = 'two-columns';
		} elseif ($home_decor_store_footer_widget_column == '3') {
			$home_decor_store_column_class = 'three-columns';
		} else {
			$home_decor_store_column_class = 'four-columns';
		}
	
		if($home_decor_store_footer_widget_column !== ''): 
		?>
		<div class="dt_footer-widgets <?php echo esc_attr($home_decor_store_column_class); ?>">
			<div class="footer-widgets-column">
				<?php
				$footer_widgets_active = false;

				// Loop to check if any footer widget is active
				for ($i = 1; $i <= $home_decor_store_footer_widget_column; $i++) {
					if (is_active_sidebar('home-decor-store-footer-widget-' . $i)) {
						$footer_widgets_active = true;
						break;
					}
				}

				if ($footer_widgets_active) {
					// Display active footer widgets
					for ($i = 1; $i <= $home_decor_store_footer_widget_column; $i++) {
						if (is_active_sidebar('home-decor-store-footer-widget-' . $i)) : ?>
							<div class="footer-one-column">
								<?php dynamic_sidebar('home-decor-store-footer-widget-' . $i); ?>
							</div>
						<?php endif;
					}
				} else {
				?>
				<div class="footer-one-column default-widgets">
					<aside id="search-2" class="widget widget_search default_footer_search">
						<div class="widget-header">
							<h4 class="widget-title"><?php esc_html_e('Search Here', 'home-decor-store'); ?></h4>
						</div>
						<?php get_search_form(); ?>
					</aside>
				</div>
				<div class="footer-one-column default-widgets">
					<aside id="recent-posts-2" class="widget widget_recent_entries">
						<h2 class="widget-title"><?php esc_html_e('Recent Posts', 'home-decor-store'); ?></h2>
						<ul>
							<?php
							$recent_posts = wp_get_recent_posts(array(
								'numberposts' => 5,
								'post_status' => 'publish',
							));
							foreach ($recent_posts as $post) {
								echo '<li><a href="' . esc_url(get_permalink($post['ID'])) . '">' . esc_html($post['post_title']) . '</a></li>';
							}
							wp_reset_query();
							?>
						</ul>
					</aside>
				</div>
				<div class="footer-one-column default-widgets">
					<aside id="recent-comments-2" class="widget widget_recent_comments">
						<h2 class="widget-title"><?php esc_html_e('Recent Comments', 'home-decor-store'); ?></h2>
						<ul>
							<?php
							$recent_comments = get_comments(array(
								'number' => 5,
								'status' => 'approve',
							));
							foreach ($recent_comments as $comment) {
								echo '<li><a href="' . esc_url(get_comment_link($comment)) . '">' .
									/* translators: %s: details. */
									sprintf(esc_html__('Comment on %s', 'home-decor-store'), get_the_title($comment->comment_post_ID)) .
									'</a></li>';
							}
							?>
						</ul>
					</aside>
				</div>
				<div class="footer-one-column default-widgets">
					<aside id="calendar-2" class="widget widget_calendar">
						<h2 class="widget-title"><?php esc_html_e('Calendar', 'home-decor-store'); ?></h2>
						<?php get_calendar(); ?>
					</aside>
				</div>
			</div>
			<?php } ?>
		</div>
		<?php
		endif;
	}
	endif;
add_action( 'home_decor_store_footer_widget', 'home_decor_store_footer_widget' );

function home_decor_store_footer_text_transform_css() {
    $home_decor_store_footer_text_transform = get_theme_mod('footer_text_transform', 'none');
    ?>
    <style type="text/css">
        .site-footer h4,footer#colophon h2.wp-block-heading,footer#colophon .widgettitle,footer#colophon .widget-title {
            text-transform: <?php echo esc_html($home_decor_store_footer_text_transform); ?>;
        }
    </style>
    <?php
}
add_action('wp_head', 'home_decor_store_footer_text_transform_css');