<?php
/**
 * Getting Started Page.
 *
 * @package home_decor_store
 */


if( ! function_exists( 'home_decor_store_getting_started_menu' ) ) :
/**
 * Adding Getting Started Page in admin menu
 */
function home_decor_store_getting_started_menu(){	
	add_theme_page(
		__( 'Getting Started', 'home-decor-store' ),
		__( 'Getting Started', 'home-decor-store' ),
		'manage_options',
		'home-decor-store-getting-started',
		'home_decor_store_getting_started_page'
	);
}
endif;
add_action( 'admin_menu', 'home_decor_store_getting_started_menu' );

if( ! function_exists( 'home_decor_store_getting_started_admin_scripts' ) ) :
/**
 * Load Getting Started styles in the admin
 */
function home_decor_store_getting_started_admin_scripts( $hook ){
	// Load styles only on our page
	if( 'appearance_page_home-decor-store-getting-started' != $hook ) return;

    wp_enqueue_style( 'home-decor-store-getting-started', get_template_directory_uri() . '/resource/css/getting-started.css', false, HOME_DECOR_STORE_THEME_VERSION );

    wp_enqueue_script( 'home-decor-store-getting-started', get_template_directory_uri() . '/resource/js/getting-started.js', array( 'jquery' ), HOME_DECOR_STORE_THEME_VERSION, true );
}
endif;
add_action( 'admin_enqueue_scripts', 'home_decor_store_getting_started_admin_scripts' );

if( ! function_exists( 'home_decor_store_getting_started_page' ) ) :
/**
 * Callback function for admin page.
*/
function home_decor_store_getting_started_page(){ 
	$home_decor_store_theme = wp_get_theme();?>
	<div class="wrap getting-started">
		<div class="intro-wrap">
			<div class="intro cointaner">
				<div class="intro-content">
					<h3><?php echo esc_html( 'Welcome to', 'home-decor-store' );?> <span class="theme-name"><?php echo esc_html( HOME_DECOR_STORE_THEME_NAME ); ?></span></h3>
					<p class="about-text">
						<?php
						// Remove last sentence of description.
						$home_decor_store_description = explode( '. ', $home_decor_store_theme->get( 'Description' ) );

						$home_decor_store_description = implode( '. ', $home_decor_store_description );

						echo esc_html( $home_decor_store_description . '' );
					?></p>
					<div class="btns-getstart">
						<a href="<?php echo esc_url( admin_url( 'customize.php' ) ); ?>"target="_blank" class="button button-primary"><?php esc_html_e( 'Customize', 'home-decor-store' ); ?></a>
						<a class="button button-primary" href="<?php echo esc_url( 'https://wordpress.org/support/theme/home-decor-store/reviews/#new-post' ); ?>" title="<?php esc_attr_e( 'Visit the Review', 'home-decor-store' ); ?>" target="_blank">
							<?php esc_html_e( 'Review', 'home-decor-store' ); ?>
						</a>
						<a class="button button-primary" href="<?php echo esc_url( 'https://wordpress.org/support/theme/home-decor-store' ); ?>" title="<?php esc_attr_e( 'Visit the Support', 'home-decor-store' ); ?>" target="_blank">
							<?php esc_html_e( 'Contact Support', 'home-decor-store' ); ?>
						</a>
					</div>
					<div class="btns-wizard">
						<a class="wizard" href="<?php echo esc_url( admin_url( 'themes.php?page=homedecorstore-wizard' ) ); ?>"target="_blank" class="button button-primary"><?php esc_html_e( 'One Click Demo Setup', 'home-decor-store' ); ?></a>
					</div>
				</div>
				<div class="intro-img">
					<img src="<?php echo esc_url(get_template_directory_uri()) .'/screenshot.png'; ?>" />
				</div>
				
			</div>
		</div>

		<div class="cointaner panels">
			<ul class="inline-list">
				<li class="current">
                    <a id="help" href="javascript:void(0);">
                        <?php esc_html_e( 'Getting Started', 'home-decor-store' ); ?>
                    </a>
                </li>
				<li>
                    <a id="free-pro-panel" href="javascript:void(0);">
                        <?php esc_html_e( 'Free Vs Pro', 'home-decor-store' ); ?>
                    </a>
                </li>
			</ul>
			<div id="panel" class="panel">
				<?php require get_template_directory() . '/theme-library/getting-started/tabs/help-panel.php'; ?>
				<?php require get_template_directory() . '/theme-library/getting-started/tabs/free-vs-pro-panel.php'; ?>
				<?php require get_template_directory() . '/theme-library/getting-started/tabs/link-panel.php'; ?>
			</div>
		</div>
	</div>
	<?php
}
endif;