<?php
/**
 * Help Panel.
 *
 * @package home_decor_store
 */
?>

<div id="help-panel" class="panel-left visible">
    <div id="#help-panel" class="steps">  
        <h4 class="c">
            <?php esc_html_e( 'Quick Setup for Home Page', 'home-decor-store' ); ?>
            <a href="<?php echo esc_url( 'https://demo.asterthemes.com/docs/home-decor-store-free' ); ?>" class="button button-primary" style="margin-left: 5px; margin-right: 10px;" target="_blank"><?php esc_html_e( 'Free Documentation', 'home-decor-store' ); ?></a>
        </h4>
        <hr class="quick-set">
        <p><?php esc_html_e( '1) Go to the dashboard. navigate to pages, add a new one, and label it "home" or whatever else you like.The page has now been created.', 'home-decor-store' ); ?></p>
        <p><?php esc_html_e( '2) Go back to the dashboard and then select Settings.', 'home-decor-store' ); ?></p>
        <p><?php esc_html_e( '3) Then Go to readings in the setting.', 'home-decor-store' ); ?></p>
        <p><?php esc_html_e( '4) There are 2 options your latest post or static page.', 'home-decor-store' ); ?></p>
        <p><?php esc_html_e( '5) Select static page and select from the dropdown you wish to use as your home page, save changes.', 'home-decor-store' ); ?></p>
        <p><?php esc_html_e( '6) You can set the home page in this manner.', 'home-decor-store' ); ?></p>
        <hr>
        <h4><?php esc_html_e( 'Setup Banner Section', 'home-decor-store' ); ?></h4>
        <hr class="quick-set">
        <p><?php esc_html_e( '1) Go to dashboard > Go to appereance > then Go to customizer.', 'home-decor-store' ); ?></p>
        <p><?php esc_html_e( '2) In Customizer > Go to Front Page Options > Go to Banner Section.', 'home-decor-store' ); ?></p>
        <p><?php esc_html_e( '3) For Setup Banner Section you have to create post in dashbord first.', 'home-decor-store' ); ?></p>
        <p><?php esc_html_e( '4) In Banner Section > Enable the Toggle button > and fill the following details.', 'home-decor-store' ); ?></p>
        <p><?php esc_html_e( '5) In this way you can set Banner Section.', 'home-decor-store' ); ?></p>
        <hr>
        <h4><?php esc_html_e( 'Setup Services Section', 'home-decor-store' ); ?></h4>
        <hr class="quick-set">
        <p><?php esc_html_e( '1) Go to dashboard > Go to plugin > add Woocommerce plugin.', 'home-decor-store' ); ?></p>
        <p><?php esc_html_e( '2) After installing plugin make products in it and give them particular category.', 'home-decor-store' ); ?></p>
        <p><?php esc_html_e( '3) In Customizer > Go to Front Page Options > Go to Services Section.', 'home-decor-store' ); ?></p>
        <p><?php esc_html_e( '4) In Services Section > Enable the Toggle button > and select the category whick you want display.', 'home-decor-store' ); ?></p>
        <p><?php esc_html_e( '5) In this way you can set Services Section.', 'home-decor-store' ); ?></p>
    </div>
    <hr>
    <div class="custom-setting">
        <h4><?php esc_html_e( 'Quick Customizer Settings', 'home-decor-store' ); ?></h4>
        <span><a href="<?php echo esc_url( admin_url( 'customize.php' ) ); ?>" target="_blank" class=""><?php esc_html_e( 'Customize', 'home-decor-store' ); ?></a></span>
    </div>
    <hr>
   <div class="setting-box">
        <div class="custom-links">
            <div class="icon-box">
                <span class="dashicons dashicons-admin-site-alt3"></span>
            </div>
            <h5><?php esc_html_e( 'Site Logo', 'home-decor-store' ); ?></h5>
            <a href="<?php echo esc_url( admin_url( 'customize.php?autofocus[control]=custom_logo' ) ); ?>" target="_blank" class=""><?php esc_html_e( 'Customize', 'home-decor-store' ); ?></a>
            
        </div>
        <div class="custom-links">
            <div class="icon-box">
                <span class="dashicons dashicons-color-picker"></span>
            </div>
            <h5><?php esc_html_e( 'Color', 'home-decor-store' ); ?></h5>
            <a href="<?php echo esc_url( admin_url( 'customize.php?autofocus[control]=primary_color' ) ); ?>" target="_blank" class=""><?php esc_html_e( 'Customize', 'home-decor-store' ); ?></a>
            
        </div>
        <div class="custom-links">
            <div class="icon-box">
                <span class="dashicons dashicons-screenoptions"></span>
            </div>
            <h5><?php esc_html_e( 'Theme Options', 'home-decor-store' ); ?></h5>
            <a href="<?php echo esc_url( admin_url( 'customize.php?autofocus[panel]=home_decor_store_theme_options' ) ); ?>"target="_blank" class=""><?php esc_html_e( 'Customize', 'home-decor-store' ); ?></a>
            
        </div>
    </div>
    <div class="setting-box">
        <div class="custom-links">
            <div class="icon-box">
                <span class="dashicons dashicons-format-image"></span>
            </div>
            <h5><?php esc_html_e( 'Header Image ', 'home-decor-store' ); ?></h5>
            <a href="<?php echo esc_url( admin_url( 'customize.php?autofocus[control]=header_image' ) ); ?>" target="_blank" class=""><?php esc_html_e( 'Customize', 'home-decor-store' ); ?></a>
            
        </div>
        <div class="custom-links">
            <div class="icon-box">
                <span class="dashicons dashicons-align-full-width"></span>
            </div>
            <h5><?php esc_html_e( 'Footer Options ', 'home-decor-store' ); ?></h5>
            <a href="<?php echo esc_url( admin_url( 'customize.php?autofocus[control]=home_decor_store_footer_copyright_text' ) ); ?>" target="_blank" class=""><?php esc_html_e( 'Customize', 'home-decor-store' ); ?></a>
            
        </div>
        <div class="custom-links">
            <div class="icon-box">
                <span class="dashicons dashicons-admin-page"></span>
            </div>
            <h5><?php esc_html_e( 'Front Page Options', 'home-decor-store' ); ?></h5>
            <a href="<?php echo esc_url( admin_url( 'customize.php?autofocus[panel]=home_decor_store_front_page_options' ) ); ?>" target="_blank" class=""><?php esc_html_e( 'Customize', 'home-decor-store' ); ?></a>
            
        </div>
    </div>
</div>


