<?php
/**
* Wizard
* @package Whizzie
* @since 1.0.0
*/

class Whizzie {
	protected $version = '1.1.0';
	protected $theme_name = '';
	protected $theme_title = '';
	protected $page_slug = '';
	protected $page_title = '';
	protected $config_steps = array();
	public $parent_slug;
	
	/**
	 * Constructor
	 * @param $config Configuration parameters
	 */
	public function __construct( $config ) {
		$this->set_vars( $config );
		$this->init();
	}

	/**
	 * Set variables based on configuration
	 * @param $config Configuration parameters
	 */
	public function set_vars( $config ) {
		if ( isset( $config['page_slug'] ) ) {
			$this->page_slug = esc_attr( $config['page_slug'] );
		}
		if ( isset( $config['page_title'] ) ) {
			$this->page_title = esc_attr( $config['page_title'] );
		}
		if ( isset( $config['steps'] ) ) {
			$this->config_steps = $config['steps'];
		}

		$current_theme = wp_get_theme();
		$this->theme_title = $current_theme->get( 'Name' );
		$this->theme_name = strtolower( preg_replace( '#[^a-zA-Z]#', '', $current_theme->get( 'Name' ) ) );
		$this->page_slug = apply_filters( $this->theme_name . '_theme_setup_wizard_page_slug', $this->theme_name . '-wizard' );
		$this->parent_slug = apply_filters( $this->theme_name . '_theme_setup_wizard_parent_slug', '' );
	}

	/*** Initialize hooks and actions ***/
	public function init() {
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_action( 'admin_menu', array( $this, 'menu_page' ) );
		add_action( 'wp_ajax_setup_widgets', array( $this, 'setup_widgets' ) );
	}
	
	public function enqueue_scripts() {
		wp_enqueue_style( 'theme-wizard-style', get_template_directory_uri() . '/theme-wizard/assets/css/theme-wizard-style.css');
		wp_register_script( 'theme-wizard-script', get_template_directory_uri() . '/theme-wizard/assets/js/theme-wizard-script.js', array( 'jquery' ));
		wp_localize_script(
			'theme-wizard-script',
			'home_decor_store_whizzie_params',
			array(
				'ajaxurl' => admin_url( 'admin-ajax.php' ),
				'verify_text' => esc_html( 'verifying', 'home-decor-store' )
			)
		);
		wp_enqueue_script( 'theme-wizard-script' );
	}

	public function menu_page() {
		add_theme_page( esc_html( $this->page_title ), esc_html( $this->page_title ), 'manage_options', $this->page_slug, array( $this, 'home_decor_store_setup_wizard' ) );
	}

	/*** Display the wizard page content ***/
	public function wizard_page() { ?>
		<div class="main-wrap">
			<div class="card whizzie-wrap">
				<ul class="whizzie-menu">
					<?php foreach ( $this->get_steps() as $step ) : ?>
						<li data-step="<?php echo esc_attr( $step['id'] ); ?>" class="step step-<?php echo esc_attr( $step['id'] ); ?>">
							<h2><?php echo esc_html( $step['title'] ); ?></h2>
							<?php $content = call_user_func( array( $this, $step['view'] ) ); ?>
							<?php if ( isset( $content['summary'] ) ) : ?>
								<div class="summary"><?php echo wp_kses_post( $content['summary'] ); ?></div>
							<?php endif; ?>
							<?php if ( isset( $content['detail'] ) ) : ?>
								<p><a href="#" class="more-info"><?php esc_html_e( 'More Info', 'home-decor-store' ); ?></a></p>
								<div class="detail"><?php echo wp_kses_post( $content['detail'] ); ?></div>
							<?php endif; ?>
							<?php if ( isset( $step['button_text'] ) && $step['button_text'] ) : ?>
								<div class="button-wrap"><a href="#" class="button button-primary do-it" data-callback="<?php echo esc_attr( $step['callback'] ); ?>" data-step="<?php echo esc_attr( $step['id'] ); ?>"><?php echo esc_html( $step['button_text'] ); ?></a></div>
							<?php endif; ?>
						</li>
					<?php endforeach; ?>
				</ul>
				<div class="step-loading"><span class="spinner"></span></div>
			</div>
		</div>
	<?php }

	/*** Setup wizard page content and options ***/
	public function home_decor_store_setup_wizard() { ?>
		<div class="wrapper-info get-stared-page-wrap">
			<div class="tab-sec theme-option-tab">
				<div id="demo_offer" class="tabcontent">
					<?php $this->wizard_page(); ?>
				</div>
			</div>
		</div>
	<?php }

	/**
	 * Get the steps for the wizard
	 * @return array
	 */
	public function get_steps() {
		$steps = array(
			'intro' => array(
				'id' => 'intro',
				'title' => __( 'Welcome to ', 'home-decor-store' ) . $this->theme_title,
				'view' => 'get_step_intro',
				'callback' => 'do_next_step',
				'button_text' => __( 'Start Now', 'home-decor-store' ),
				'can_skip' => false
			),
			'widgets' => array(
				'id' => 'widgets',
				'title' => __( 'Demo Importer', 'home-decor-store' ),
				'view' => 'get_step_widgets',
				'callback' => 'install_widgets',
				'button_text' => __( 'Import Demo', 'home-decor-store' ),
				'can_skip' => true
			),
			'done' => array(
				'id' => 'done',
				'title' => __( 'All Done', 'home-decor-store' ),
				'view' => 'get_step_done'
			)
		);

		return $steps;
	}

	/*** Display the content for the intro step ***/
	public function get_step_intro() { ?>
		<div class="summary">
			<p style="text-align: center;"><?php esc_html_e( 'Thank you for choosing our theme! We are excited to help you get started with your new website.', 'home-decor-store' ); ?></p>
			<p style="text-align: center;"><?php esc_html_e( 'To ensure you make the most of our theme, we recommend following the setup steps outlined here. This process will help you configure the theme to best suit your needs and preferences. Click on the "Start Now" button to begin the setup.', 'home-decor-store' ); ?></p>
		</div>
	<?php }

	/*** Display the content for the widgets step ***/
	public function get_step_widgets() { ?>
		<div class="summary">
			<p><?php esc_html_e('To get started, use the button below to import demo content and add widgets to your site. After installation, you can manage settings and customize your site using the Customizer. Enjoy your new theme!', 'home-decor-store'); ?></p>
		</div>
	<?php }

	/*** Display the content for the final step ***/
	public function get_step_done() { ?>
		<div id="aster-demo-setup-guid">
			<div class="aster-setup-menu">
				<h3><?php esc_html_e('Setup Navigation Menu','home-decor-store'); ?></h3>
				<p><?php esc_html_e('Follow the following Steps to Setup Menu','home-decor-store'); ?></p>
				<h4><?php esc_html_e('A) Create Pages','home-decor-store'); ?></h4>
				<ol>
					<li><?php esc_html_e('Go to Dashboard >> Pages >> Add New','home-decor-store'); ?></li>
					<li><?php esc_html_e('Enter Page Details And Save Changes','home-decor-store'); ?></li>
				</ol>
				<h4><?php esc_html_e('B) Add Pages To Menu','home-decor-store'); ?></h4>
				<ol>
					<li><?php esc_html_e('Go to Dashboard >> Appearance >> Menu','home-decor-store'); ?></li>
					<li><?php esc_html_e('Click On The Create Menu Option','home-decor-store'); ?></li>
					<li><?php esc_html_e('Select The Pages And Click On The Add to Menu Button','home-decor-store'); ?></li>
					<li><?php esc_html_e('Select Primary Menu From The Menu Setting','home-decor-store'); ?></li>
					<li><?php esc_html_e('Click On The Save Menu Button','home-decor-store'); ?></li>
				</ol>
			</div>
			<div class="aster-setup-widget">
				<h3><?php esc_html_e('Setup Footer Widgets','home-decor-store'); ?></h3>
				<p><?php esc_html_e('Follow the following Steps to Setup Footer Widgets','home-decor-store'); ?></p>
				<ol>
					<li><?php esc_html_e('Go to Dashboard >> Appearance >> Widgets','home-decor-store'); ?></li>
					<li><?php esc_html_e('Drag And Add The Widgets In The Footer Columns','home-decor-store'); ?></li>
				</ol>
			</div>
			<div style="display:flex; justify-content: center; margin-top: 20px; gap:20px">
				<div class="aster-setup-finish">
					<a target="_blank" href="<?php echo esc_url(home_url()); ?>" class="button button-primary">Visit Site</a>
				</div>
				<div class="aster-setup-finish">
					<a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>" class="button button-primary">Customize Your Demo</a>
				</div>
				<div class="aster-setup-finish">
					<a target="_blank" href="<?php echo esc_url( admin_url('themes.php?page=home-decor-store-getting-started') ); ?>" class="button button-primary">Getting Started</a>
				</div>
			</div>
		</div>
	<?php }


	//                      ------------- MENUS -----------------                    //

	public function home_decor_store_customizer_primary_menu(){

		// ------- Create Primary Menu --------
		$home_decor_store_menuname = $home_decor_store_themename . 'Primary Menu';
		$home_decor_store_bpmenulocation = 'primary';
		$home_decor_store_menu_exists = wp_get_nav_menu_object( $home_decor_store_menuname );

		if( !$home_decor_store_menu_exists){
			$home_decor_store_menu_id = wp_create_nav_menu($home_decor_store_menuname);
			$home_decor_store_parent_item = 
			wp_update_nav_menu_item($home_decor_store_menu_id, 0, array(
				'menu-item-title' =>  __('Home','home-decor-store'),
				'menu-item-classes' => 'home',
				'menu-item-url' => home_url( '/' ),
				'menu-item-status' => 'publish'));

			wp_update_nav_menu_item($home_decor_store_menu_id, 0, array(
				'menu-item-title' =>  __('Shop','home-decor-store'),
				'menu-item-classes' => 'shop',
				'menu-item-url' => get_permalink(get_page_by_title('shop')),
				'menu-item-status' => 'publish'));

			wp_update_nav_menu_item($home_decor_store_menu_id, 0, array(
				'menu-item-title' =>  __('Our Story','home-decor-store'),
				'menu-item-classes' => 'ourstory',
				'menu-item-url' => get_permalink(get_page_by_title('Our Story')),
				'menu-item-status' => 'publish'));

			wp_update_nav_menu_item($home_decor_store_menu_id, 0, array(
				'menu-item-title' =>  __('Blogs','home-decor-store'),
				'menu-item-classes' => 'blog',
				'menu-item-url' => get_permalink(get_page_by_title('Blogs')),
				'menu-item-status' => 'publish'));

			wp_update_nav_menu_item($home_decor_store_menu_id, 0, array(
				'menu-item-title' =>  __('Contact','home-decor-store'),
				'menu-item-classes' => 'contact',
				'menu-item-url' => get_permalink(get_page_by_title('Contact')),
				'menu-item-status' => 'publish'));

			if( !has_nav_menu( $home_decor_store_bpmenulocation ) ){
				$locations = get_theme_mod('nav_menu_locations');
				$locations[$home_decor_store_bpmenulocation] = $home_decor_store_menu_id;
				set_theme_mod( 'nav_menu_locations', $locations );
			}
		}
	}

	//                      ------------- /*** Imports demo content ***/ -----------------                    //

	public function setup_widgets() {

		// Create a front page and assigned the template
		$home_decor_store_home_title = 'Home';
		$home_decor_store_home_check = get_page_by_title($home_decor_store_home_title);
		$home_decor_store_home = array(
			'post_type' => 'page',
			'post_title' => $home_decor_store_home_title,
			'post_status' => 'publish',
			'post_author' => 1,
			'post_slug' => 'home'
		);
		$home_decor_store_home_id = wp_insert_post($home_decor_store_home);

		//Set the static front page
		$home_decor_store_home = get_page_by_title( 'Home' );
		update_option( 'page_on_front', $home_decor_store_home->ID );
		update_option( 'show_on_front', 'page' );


		// Create a posts page and assigned the template
		$home_decor_store_blog_title = 'Blogs';
		$home_decor_store_blog = get_page_by_title($home_decor_store_blog_title);

		if (!$home_decor_store_blog) {
			$home_decor_store_blog = array(
				'post_type' => 'page',
				'post_title' => $home_decor_store_blog_title,
				'post_status' => 'publish',
				'post_author' => 1,
				'post_name' => 'blog'
			);
			$home_decor_store_blog_id = wp_insert_post($home_decor_store_blog);

			if (is_wp_error($home_decor_store_blog_id)) {
				// Handle error
			}
		} else {
			$home_decor_store_blog_id = $home_decor_store_blog->ID;
		}
		// Set the posts page
		update_option('page_for_posts', $home_decor_store_blog_id);

		
		// Create a shop and assigned the template
		$home_decor_store_shop_title = 'Shop';
		$home_decor_store_shop_check = get_page_by_title($home_decor_store_shop_title);
		$home_decor_store_shop = array(
			'post_type' => 'page',
			'post_title' => $home_decor_store_shop_title,
			'post_content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>',
			'post_status' => 'publish',
			'post_author' => 1,
			'post_slug' => 'blog'
		);
		$home_decor_store_shop_id = wp_insert_post($home_decor_store_shop);

		
		// Create a Our Story and assigned the template
		$home_decor_store_ourstory_title = 'Our Story';
		$home_decor_store_ourstory_check = get_page_by_title($home_decor_store_ourstory_title);
		$home_decor_store_ourstory = array(
			'post_type' => 'page',
			'post_title' => $home_decor_store_ourstory_title,
			'post_content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>',
			'post_status' => 'publish',
			'post_author' => 1,
			'post_slug' => 'blog'
		);
		$home_decor_store_ourstory_id = wp_insert_post($home_decor_store_ourstory);

		
		// Create a contact and assigned the template
		$home_decor_store_contact_title = 'Contact';
		$home_decor_store_contact_check = get_page_by_title($home_decor_store_contact_title);
		$home_decor_store_contact = array(
			'post_type' => 'page',
			'post_title' => $home_decor_store_contact_title,
			'post_content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>',
			'post_status' => 'publish',
			'post_author' => 1,
			'post_slug' => 'blog'
		);
		$home_decor_store_contact_id = wp_insert_post($home_decor_store_contact);

		/*----------------------------------------- Header Button --------------------------------------------------*/

			set_theme_mod( 'home_decor_store_header_wishlist_url','#');
			

		// ------------------------------------------ Blogs for Sections --------------------------------------

			// ------------------------------------------ Blogs for Sections --------------------------------------

				// Create categories if not already created
				$home_decor_store_category_banner = wp_create_category('Banner');
				$home_decor_store_category_services = wp_create_category('Services');

				// Array of categories to assign to each set of posts
				$home_decor_store_categories = array($home_decor_store_category_banner, $home_decor_store_category_services);

				// Array of image URLs for the "Services" category
				$services_images = array(
					get_template_directory_uri() . '/resource/img/service1.png',
					get_template_directory_uri() . '/resource/img/service2.png',
					get_template_directory_uri() . '/resource/img/service3.png',
					get_template_directory_uri() . '/resource/img/service4.png'
				);

				// Loop to create posts
				for ($i = 1; $i <= 7; $i++) { // Adjusted to 7 posts in total
					$title = array(
						'TRANSFORMING SPACES, INSPIRING LIVES',
						'ELEVATE YOUR SPACE, ENRICH YOUR LIFE',
						'DESIGNING DREAMS, DEFINING SPACES',
						'Home Decor',
						'Furniture',
						'Kitchen',
						'Washroom'
					);

					$content = ' Exclusive, high-quality art at an affordable price.';

					// Determine category and post index to use for title
					$category_index = ($i <= 3) ? 0 : 1; // First 3 for Banner, next 4 for Services
					$post_title = $title[$i - 1]; // Adjust for zero-based index in title array

					// Create post object
					$my_post = array(
						'post_title'    => wp_strip_all_tags($post_title),
						'post_content'  => $content,
						'post_status'   => 'publish',
						'post_type'     => 'post',
						'post_category' => array($home_decor_store_categories[$category_index]), // Assign Banner to first 3, Services to next 4
					);

					// Insert the post into the database
					$post_id = wp_insert_post($my_post);

					// Determine the category and set image URLs based on category
					if ($category_index === 0) { // Banner category
						$banner_index = $i % 3 + 1; // Cycles through 1, 2, 3
							$home_decor_store_image_url = get_template_directory_uri() . "/resource/img/banner{$banner_index}.png";
							$home_decor_store_image_name = "banner{$banner_index}.png";
											} else { // Services category
						// Use different images for each post in Services category
						$service_image_index = $i - 4; // Get the correct index for the Services images array (4, 5, 6, 7 corresponds to 0, 1, 2, 3)
						$home_decor_store_image_url = $services_images[$service_image_index];
						$home_decor_store_image_name = basename($home_decor_store_image_url);
					}

					$home_decor_store_upload_dir = wp_upload_dir();
					$home_decor_store_image_data = file_get_contents($home_decor_store_image_url);
					$home_decor_store_unique_file_name = wp_unique_filename($home_decor_store_upload_dir['path'], $home_decor_store_image_name);
					$filename = basename($home_decor_store_unique_file_name);

					if (wp_mkdir_p($home_decor_store_upload_dir['path'])) {
						$file = $home_decor_store_upload_dir['path'] . '/' . $filename;
					} else {
						$file = $home_decor_store_upload_dir['basedir'] . '/' . $filename;
					}
					
					if ( ! function_exists( 'WP_Filesystem' ) ) {
						require_once( ABSPATH . 'wp-admin/includes/file.php' );
					}
					
					WP_Filesystem();
					global $wp_filesystem;
					
					if ( ! $wp_filesystem->put_contents( $file, $home_decor_store_image_data, FS_CHMOD_FILE ) ) {
						wp_die( 'Error saving file!' );
					}

					$wp_filetype = wp_check_filetype($filename, null);
					$attachment = array(
						'post_mime_type' => $wp_filetype['type'],
						'post_title'     => sanitize_file_name($filename),
						'post_content'   => '',
						'post_status'    => 'inherit'
					);

					$home_decor_store_attach_id = wp_insert_attachment($attachment, $file, $post_id);

					require_once(ABSPATH . 'wp-admin/includes/image.php');

					$home_decor_store_attach_data = wp_generate_attachment_metadata($home_decor_store_attach_id, $file);
					wp_update_attachment_metadata($home_decor_store_attach_id, $home_decor_store_attach_data);
					set_post_thumbnail($post_id, $home_decor_store_attach_id);
				}


		
		// ---------------------------------------- Slider --------------------------------------------------- //

			for($i=1; $i<=3; $i++) {
				set_theme_mod('home_decor_store_banner_button_label_'.$i,'Explore Now');
				set_theme_mod('home_decor_store_banner_button_link_'.$i,'');
			}

		// ---------------------------------------- Services --------------------------------------------------- //

			set_theme_mod('home_decor_store_trending_product_heading','Shop By Category');
			set_theme_mod('home_decor_store_trending_product_content','We’re pretty quick around here. We’ll have your canvases and-stretched within 4 business days & it’ll arrive on your doorstep just a few days later.');
			set_theme_mod('home_decor_store_enable_service_section',true);

		// ---------------------------------------- Footer section --------------------------------------------------- //	
		
			set_theme_mod('home_decor_store_footer_background_color_setting','#000000');
			
		// ---------------------------------------- Related post_tag --------------------------------------------------- //	
		
			set_theme_mod('home_decor_store_post_related_post_label','Related Posts');
			set_theme_mod('home_decor_store_related_posts_count','3');


		$this->home_decor_store_customizer_primary_menu();
	}
}