//POST METADATA ICONS
window.onload = function() {
    if (!document.querySelector(".wp-block-post-date__modified-date")) {
        var element = document.querySelector("svg#last-edit");
        if (element) {
            element.style.display = "none";
        }
    }
    if (!document.querySelector(".taxonomy-category")) {
        var categoryElement = document.querySelector("svg#category");
        if (categoryElement) {
            categoryElement.style.display = "none";
        }
    }
    if (!document.querySelector(".taxonomy-post_tag")) {
        var tagElement = document.querySelector("svg#tag");
        if (tagElement) {
            tagElement.style.display = "none";
        }
    }
};



//RESPONSIVE MENU
window.addEventListener('DOMContentLoaded', (event) => {
    // Select the elements
    const submenuContainers = document.querySelectorAll('.wp-block-navigation__submenu-container');
    const toggleButtons = document.querySelectorAll('button.wp-block-navigation__submenu-icon.wp-block-navigation-submenu__toggle');
    const toggleSVGs = document.querySelectorAll('.wp-block-navigation .wp-block-navigation__submenu-icon svg');
    // Function to check screen size and hide/show the submenu containers
    const checkScreenSize = () => {
        if (window.matchMedia('(max-width: 600px)').matches) {
            submenuContainers.forEach((submenuContainer) => {
                submenuContainer.style.display = 'none';
            });
        } else {
            submenuContainers.forEach((submenuContainer) => {
                submenuContainer.style.display = 'block';
            });
        }
    };
    // Call the function initially
    checkScreenSize();
    // Toggle the display of the submenu containers when the buttons are clicked
    toggleButtons.forEach((toggleButton, index) => {
        toggleButton.addEventListener('click', (event) => {
            event.stopPropagation(); // Prevent the event from propagating to the document
            if (window.matchMedia('(max-width: 600px)').matches) {
                if (submenuContainers[index].style.display === 'none' || submenuContainers[index].style.display === '') {
                    submenuContainers[index].style.display = 'block';
                    toggleSVGs[index].style.transform = 'rotate(180deg)'; // Rotate the SVG
                } else {
                    submenuContainers[index].style.display = 'none';
                    toggleSVGs[index].style.transform = 'rotate(0deg)'; // Reset the rotation
                }
            }
        });
    });
    // Check if the submenu contains the current page item and show it
    for (let i = 0; i < submenuContainers.length; i++) {
        if (submenuContainers[i].querySelector('.current-menu-item a[aria-current=page]')) {
            submenuContainers[i].style.display = 'block';
            if (window.matchMedia('(max-width: 600px)').matches) {
                toggleSVGs[i].style.transform = 'rotate(180deg)'; // Rotate the SVG
            }
        }
    }
});