<?php
/**
 * Mono functions and definitions
 *
 * @link https://wp-themes.com/monowp/
 *
 * @package Mono
 * @since Mono 1.0
*/



/*TRANSLATIONS*/
add_action( 'after_setup_theme', 'monowp_load_textdomain' );
function monowp_load_textdomain() {
	 load_theme_textdomain(
		 'monowp',
		 get_parent_theme_file_path( 'assets/languages' )
	);
}



/*STYLES & SCRIPTS*/
add_action( 'wp_enqueue_scripts', 'monowp_enqueue_styles' );
function monowp_enqueue_styles() {
	wp_enqueue_style( 
		'monowp-theme-styles',
		get_parent_theme_file_uri( 'assets/styles/monowp.min.css' )
	);
	if (class_exists('WooCommerce')) {
        wp_enqueue_style( 
            'monowp-woocommerce-styles',
            get_parent_theme_file_uri( 'assets/styles/monowp-woocommerce.min.css' )
        );
    }
	if (class_exists('Jetpack')) {
        wp_enqueue_style( 
            'monowp-jetpack-styles',
            get_parent_theme_file_uri( 'assets/styles/monowp-jetpack.min.css' )
        );
    }
}

add_action( 'after_setup_theme', 'monowp_setup' );
function monowp_setup() {
    $editor_styles = array(
        get_parent_theme_file_uri( 'assets/styles/editor.css' ),
        get_parent_theme_file_uri( 'assets/styles/monowp.min.css' ),
    );
    if ( class_exists( 'WooCommerce' ) ) {
        $editor_styles[] = get_parent_theme_file_uri( 'assets/styles/monowp-woocommerce.min.css' );
    }
    if ( class_exists( 'Jetpack' ) ) {
        $editor_styles[] = get_parent_theme_file_uri( 'assets/styles/monowp-jetpack.min.css' );
    }
    add_editor_style( $editor_styles );
}

add_action( 'wp_enqueue_scripts', 'monowp_enqueue_scripts' );
function monowp_enqueue_scripts() {
	wp_enqueue_script( 
		'monowp-scripts',
		get_parent_theme_file_uri( 'assets/scripts/monowp.min.js' ),
		array(),
		wp_get_theme()->get( 'Version' ),
		true
	);
}



/*BLOCK STYLE VARIATIONS*/
include get_parent_theme_file_path( 'includes/block-style-variations.php' );



/*BLOCK PATTERNS*/
include get_parent_theme_file_path( 'includes/block-patterns.php' );



/*ADMIN NOTICE*/
add_action('admin_notices', 'monowp_admin_notice');
function monowp_admin_notice() {
    $notice = '<p style="font-size:24px;"><b>' . __('Thank you for using Mono!', 'monowp') . '</b></p>';
    $notice .= '<p><span class="dashicons dashicons-sos"></span> ' . __('Need help?', 'monowp') . ' <a href="https://wordpress.org/support/theme/monowp/" target="_blank">' . __('Go to support', 'monowp') . '</a> ⬈</p>';
	$notice .= '<p><span class="dashicons dashicons-star-half"></span> ' . __('Got something to say?', 'monowp') . ' <a href="https://wordpress.org/support/theme/monowp/reviews/#new-post" target="_blank">' . __('Leave a review', 'monowp') . '</a> ⬈</p>';
	$notice .= '<p><span class="dashicons dashicons-flag"></span> ' . __('Add your language!', 'monowp') . ' <a href="https://translate.wordpress.org/projects/wp-themes/monowp" target="_blank">' . __('Translate this theme', 'monowp') . '</a> ⬈</p>';
	echo '<div class="notice notice-info is-dismissible">';
    echo $notice;
    echo '</div>';
}



/*ATTACHMENTS*/
add_filter( 'pre_option_wp_attachment_pages_enabled', '__return_true' );
add_filter( 'render_block_core/post-content', 'monowp_render_block', 10, 3 );
function monowp_render_block( $block_content, $block, $instance ) {
	if (
		empty( $instance->context['postId'] )
		|| ! is_attachment( $instance->context['postId'] )
	) {
		return $block_content;
	}
	$partials = [];
	$html     = '';
	foreach ( [ 'image', 'video', 'audio' ] as $type ) {
	if ( wp_attachment_is( $type, $instance->context['postId'] ) ) {
		$partials[] = "partials/attachment-media-{$type}.php";
		break;
		}
	}
	$partials[] = 'partials/attachment-media.php';
	ob_start();
	locate_template( $partials, true, false, [
	'post_id' => $instance->context['postId']
	] );
	$block_markup = ob_get_clean();
	if ( ! $block_markup ) {
	return $block_content;
	}
	foreach ( parse_blocks( $block_markup ) as $parsed_block ) {
		$html .= render_block( $parsed_block );
	}
	return $html . $block_content;
}
