<?php
add_action( 'init', 'monowp_register_patterns' );
function monowp_register_patterns() {

	/*Cover*/
	register_block_pattern( 'monowp/cover', array(
		'title'      => __( 'Cover', 'monowp' ),
		'categories' => array( 'featured', 'banner', 'call-to-action', 'header', 'text', 'media', 'buttons', 'columns' ),
		'description'=> 'Cover image section that covers the entire width, with a title, a paragraph, and a CTA button.',
		'source'     => 'theme',
		'content'    => '<!-- wp:cover {"url":"https://live.staticflickr.com/7058/6831122690_6771886419_b.jpg","hasParallax":true,"dimRatio":80,"overlayColor":"black","isUserOverlayColor":true,"minHeight":100,"minHeightUnit":"vh","metadata":{"categories":["featured","banner","call-to-action","header","text","media","call-to-action","text"],"patternName":"monowp/hero","name":"Hero"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50","right":"var:preset|spacing|50","left":"var:preset|spacing|50"}},"color":{"duotone":"var:preset|duotone|grayscale"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover alignfull has-parallax" style="padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50);min-height:100vh"><span aria-hidden="true" class="wp-block-cover__background has-black-background-color has-background-dim-80 has-background-dim"></span><div class="wp-block-cover__image-background has-parallax" style="background-position:50% 50%;background-image:url(https://live.staticflickr.com/7058/6831122690_6771886419_b.jpg)"></div><div class="wp-block-cover__inner-container"><!-- wp:heading {"textAlign":"center","style":{"typography":{"textTransform":"uppercase"}},"fontSize":"medium"} -->
<h2 class="wp-block-heading has-text-align-center has-medium-font-size" style="text-transform:uppercase">Monochrome theme design</h2>
<!-- /wp:heading -->
<!-- wp:heading {"textAlign":"center","level":1,"style":{"typography":{"fontStyle":"normal","fontWeight":"300"}},"fontSize":"x-large"} -->
<h1 class="wp-block-heading has-text-align-center has-x-large-font-size" style="font-style:normal;font-weight:300">A monochrome color design can work well with an elegant and minimalist style</h1>
<!-- /wp:heading -->
<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center">Use lots of white space and&nbsp;thin fonts, with a strong grid, sparse layout and restrained use of color.</p>
<!-- /wp:paragraph -->
<!-- wp:buttons {"style":{"typography":{"textTransform":"uppercase"}},"layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons" style="text-transform:uppercase"><!-- wp:button {"textAlign":"center","className":"is-style-outline"} -->
<div class="wp-block-button is-style-outline"><a class="wp-block-button__link has-text-align-center wp-element-button">Learn more</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div></div>
<!-- /wp:cover -->'
	) );

	/*CTA*/
	register_block_pattern( 'monowp/cta', array(
		'title'      => __( 'Call To Action', 'monowp' ),
		'categories' => array( 'featured', 'banner', 'call-to-action', 'header', 'text', 'media', 'buttons', 'columns' ),
		'description'=> 'Title, paragraph, two CTA buttons, and an image for a general CTA section.',
		'source'     => 'theme',
		'content'    => '<!-- wp:group {"metadata":{"categories":["featured","banner","call-to-action","header","text","media","call-to-action","text"],"patternName":"monowp/cta","name":"Call to Action"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50","left":"var:preset|spacing|50","right":"var:preset|spacing|50"},"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)"><!-- wp:columns {"verticalAlignment":"center","align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|50"}}}} -->
<div class="wp-block-columns alignwide are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","width":"50%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:50%"><!-- wp:heading {"style":{"typography":{"fontStyle":"normal","fontWeight":"300"}},"fontSize":"x-large"} -->
<h2 class="wp-block-heading has-x-large-font-size" style="font-style:normal;font-weight:300">A monochrome color design can work well with an elegant and minimalist style</h2>
<!-- /wp:heading -->
<!-- wp:paragraph -->
<p>〉 Use lots of white space and&nbsp;thin fonts.</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph -->
<p>〉 A strong grid, sparse layout and restrained use of color.</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph -->
<p>〉 These are the foundations of minimalist style!</p>
<!-- /wp:paragraph -->
<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"className":"is-style-fill"} -->
<div class="wp-block-button is-style-fill"><a class="wp-block-button__link wp-element-button">Learn more</a></div>
<!-- /wp:button -->
<!-- wp:button {"backgroundColor":"base","textColor":"contrast","className":"is-style-outline","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}}}} -->
<div class="wp-block-button is-style-outline"><a class="wp-block-button__link has-contrast-color has-base-background-color has-text-color has-background has-link-color wp-element-button">Discover ➔</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:column -->
<!-- wp:column {"verticalAlignment":"center","width":"50%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:50%"><!-- wp:image {"lightbox":{"enabled":false},"sizeSlug":"full","linkDestination":"none","className":"is-style-default","style":{"border":{"radius":"0px"},"shadow":"6px 6px 0px -3px rgba(255, 255, 255, 1), 6px 6px rgba(0, 0, 0, 1)"}} -->
<figure class="wp-block-image size-full has-custom-border is-style-default"><img src="https://live.staticflickr.com/4181/34595635911_bc5fe42884_b.jpg" alt="" style="border-radius:0px;box-shadow:6px 6px 0px -3px rgba(255, 255, 255, 1), 6px 6px rgba(0, 0, 0, 1)"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->'
	) );

	/*Banner*/
	register_block_pattern( 'monowp/banner', array(
		'title'      => __( 'Banner', 'monowp' ),
		'categories' => array( 'featured', 'text', 'media', 'columns', 'banner', 'about', 'portfolio' ),
		'description'=> 'Banner section with title, paragraph, and an image.',
		'source'     => 'theme',
		'content'    => '<!-- wp:group {"metadata":{"categories":["banner"],"patternName":"monowp/banner","name":"Banner"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50","left":"var:preset|spacing|50","right":"var:preset|spacing|50"},"margin":{"top":"0","bottom":"0"}}},"backgroundColor":"accent-5","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-accent-5-background-color has-background" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)"><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|50"}}}} -->
<div class="wp-block-columns alignwide"><!-- wp:column {"verticalAlignment":"center","width":"60%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:60%"><!-- wp:image {"lightbox":{"enabled":false},"aspectRatio":"4/3","scale":"cover","sizeSlug":"full","linkDestination":"none","className":"is-style-default","style":{"color":{"duotone":"var:preset|duotone|grayscale"},"shadow":"6px 6px 0px rgba(0, 0, 0, 0.2)"}} -->
<figure class="wp-block-image size-full is-style-default"><img src="https://live.staticflickr.com/128/387275733_655c137593_b.jpg" alt="" style="box-shadow:6px 6px 0px rgba(0, 0, 0, 0.2);aspect-ratio:4/3;object-fit:cover"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->
<!-- wp:column {"verticalAlignment":"center","width":"40%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:40%"><!-- wp:paragraph {"style":{"typography":{"textTransform":"uppercase"}},"fontSize":"medium"} -->
<p class="has-medium-font-size" style="text-transform:uppercase"><strong>Monochrome design mockup</strong></p>
<!-- /wp:paragraph -->
<!-- wp:heading {"style":{"typography":{"fontStyle":"normal","fontWeight":"300"}},"fontSize":"x-large"} -->
<h2 class="wp-block-heading has-x-large-font-size" style="font-style:normal;font-weight:300">A monochrome color design can work well with an elegant and minimalist style</h2>
<!-- /wp:heading -->
<!-- wp:separator {"backgroundColor":"extra"} -->
<hr class="wp-block-separator has-text-color has-extra-color has-alpha-channel-opacity has-extra-background-color has-background"/>
<!-- /wp:separator -->
<!-- wp:paragraph -->
<p><em>Use lots of white space and&nbsp;thin fonts. <br>A strong grid, sparse layout and restrained use of color.<br>These are the foundations of minimalist style!</em></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->'
	) );

	/*RSVP*/
	register_block_pattern( 'monowp/rsvp-cta', array(
		'title'      => __( 'RSVP', 'monowp' ),
		'categories' => array( 'featured', 'text', 'media', 'columns', 'video', 'call-to-action', 'header' ),
		'description'=> 'Large RSVP heading sideways, a description, a CTA button and a video.',
		'source'     => 'theme',
		'content'    => '<!-- wp:group {"metadata":{"categories":["featured","text","media","text","video","call-to-action","header"],"patternName":"monowp/rsvp","name":"Overview"},"align":"full","style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50","left":"var:preset|spacing|50","right":"var:preset|spacing|50"}},"dimensions":{"minHeight":"100vh"}},"backgroundColor":"accent-4","layout":{"type":"flex","orientation":"vertical","verticalAlignment":"center","justifyContent":"center","flexWrap":"nowrap"}} -->
<div class="wp-block-group alignfull has-accent-4-background-color has-background" style="min-height:100vh;margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)"><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|50"}}}} -->
<div class="wp-block-columns alignwide"><!-- wp:column {"verticalAlignment":"center","width":"40%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:40%"><!-- wp:group {"style":{"dimensions":{"minHeight":"100%"},"spacing":{"blockGap":"var:preset|spacing|50","margin":{"top":"0","bottom":"0"},"padding":{"right":"0","left":"0"}}},"layout":{"type":"default"}} -->
<div class="wp-block-group" style="min-height:100%;margin-top:0;margin-bottom:0;padding-right:0;padding-left:0"><!-- wp:paragraph {"align":"right","style":{"typography":{"textTransform":"uppercase","writingMode":"vertical-rl","fontSize":"201px","textDecoration":"none"},"elements":{"link":{"color":{"text":"var:preset|color|extra"}}}},"textColor":"extra"} -->
<p class="has-text-align-right has-extra-color has-text-color has-link-color" style="font-size:201px;text-decoration:none;text-transform:uppercase;writing-mode:vertical-rl"><strong>RSVP</strong></p>
<!-- /wp:paragraph -->
<!-- wp:separator {"backgroundColor":"extra"} -->
<hr class="wp-block-separator has-text-color has-extra-color has-alpha-channel-opacity has-extra-background-color has-background"/>
<!-- /wp:separator -->
<!-- wp:heading {"textAlign":"left","style":{"typography":{"fontStyle":"normal","fontWeight":"300"}},"fontSize":"x-large"} -->
<h2 class="wp-block-heading has-text-align-left has-x-large-font-size" style="font-style:normal;font-weight:300">A monochrome color design can&nbsp;work well with an elegant and minimalist&nbsp;style</h2>
<!-- /wp:heading -->
<!-- wp:paragraph {"align":"left"} -->
<p class="has-text-align-left">Use lots of white space and thin fonts.<br>A strong grid, sparse layout and restrained use of color.<br>These are the foundations of minimalist style!</p>
<!-- /wp:paragraph -->
<!-- wp:group {"style":{"spacing":{"padding":{"right":"0","left":"0"}}},"layout":{"type":"constrained","contentSize":"300px","justifyContent":"left"}} -->
<div class="wp-block-group" style="padding-right:0;padding-left:0"><!-- wp:paragraph {"align":"left","style":{"layout":{"selfStretch":"fixed","flexSize":"50%"},"typography":{"fontSize":"300px","lineHeight":"1"}}} -->
<p class="has-text-align-left" style="font-size:300px;line-height:1"><a href="#" style="text-decoration:none">➔</a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->
<!-- wp:column {"verticalAlignment":"center","width":"60%","style":{"shadow":"12px 12px 50px rgba(0, 0, 0, 0.4)"}} -->
<div class="wp-block-column is-vertically-aligned-center" style="box-shadow:12px 12px 50px rgba(0, 0, 0, 0.4);flex-basis:60%"><!-- wp:video -->
<figure class="wp-block-video"><video autoplay loop muted preload="auto" src="https://videos.pexels.com/video-files/8516672/8516672-uhd_1440_2560_30fps.mp4" playsinline></video></figure>
<!-- /wp:video --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->'
	) );

	/*Gallery*/
	register_block_pattern( 'monowp/gallery-grid', array(
		'title'      => __( 'Gallery', 'monowp' ),
		'categories' => array( 'featured', 'text', 'media', 'columns', 'gallery', 'portfolio' ),
		'description'=> 'Gallery section with a grid layout with 2 images.',
		'source'     => 'theme',
		'content'    => '<!-- wp:group {"metadata":{"categories":["featured","text","media","text","gallery","portfolio"],"patternName":"monowp/gallery","name":"Grid"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|50","right":"var:preset|spacing|50","bottom":"var:preset|spacing|50","left":"var:preset|spacing|50"},"margin":{"top":"0","bottom":"0"}},"elements":{"link":{"color":{"text":"var:preset|color|base-2"}}}},"backgroundColor":"black","textColor":"base-2","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-base-2-color has-black-background-color has-text-color has-background has-link-color" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)"><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|60"}}}} -->
<div class="wp-block-columns alignwide"><!-- wp:column {"verticalAlignment":"stretch","width":"60%","style":{"spacing":{"padding":{"right":"0"}}}} -->
<div class="wp-block-column is-vertically-aligned-stretch" style="padding-right:0;flex-basis:60%"><!-- wp:group {"style":{"dimensions":{"minHeight":"100%"}},"layout":{"type":"flex","orientation":"vertical","verticalAlignment":"space-between","justifyContent":"stretch"}} -->
<div class="wp-block-group" style="min-height:100%"><!-- wp:image {"lightbox":{"enabled":false},"sizeSlug":"large","linkDestination":"none","className":"is-style-default","style":{"layout":{"selfStretch":"fit","flexSize":null}}} -->
<figure class="wp-block-image size-large is-style-default"><img src="https://live.staticflickr.com/426/19765781730_597efafd35_b.jpg" alt=""/></figure>
<!-- /wp:image -->
<!-- wp:paragraph {"align":"left","style":{"elements":{"link":{"color":{"text":"#7f7f7f"}}},"typography":{"fontStyle":"normal","fontWeight":"400"},"color":{"text":"#7f7f7f"}},"fontSize":"medium"} -->
<p class="has-text-align-left has-text-color has-link-color has-medium-font-size" style="color:#7f7f7f;font-style:normal;font-weight:400">Lorem ipsum dolor sit amet, consectetur&nbsp;adipiscing elit. Pellentesque dapibus,&nbsp;neque consectetur imperdiet euismod,&nbsp;purus risus mattis purus, ac laoreet orci&nbsp;quam ac ante. Vivamus tristique laoreet&nbsp;ex, vel dapibus orci malesuada ut. Integer&nbsp;aliquet vestibulum metus vel efficitur.&nbsp;Vestibulum in dolor metus.</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"#7f7f7f"}}},"color":{"text":"#7f7f7f"}},"fontSize":"medium"} -->
<p class="has-text-color has-link-color has-medium-font-size" style="color:#7f7f7f">Nulla tincidunt faucibus enim, quis&nbsp;lacinia diam pellentesque et. Nullam&nbsp;eleifend placerat blandit. Fusce id&nbsp;sagittis justo. Phasellus tempus nec&nbsp;tellus et lobortis. In sed metus eget dui&nbsp;vehicula mollis nec in dui. Curabitur eu&nbsp;urna est. Cras lobortis mi ut accumsan&nbsp;euismod. Aliquam tincidunt ultrices&nbsp;efficitur.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->
<!-- wp:column {"width":"40%"} -->
<div class="wp-block-column" style="flex-basis:40%"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"align":"right","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"typography":{"textTransform":"uppercase"}},"textColor":"white","fontSize":"medium"} -->
<p class="has-text-align-right has-white-color has-text-color has-link-color has-medium-font-size" style="text-transform:uppercase"><strong>Monochrome design mockup</strong></p>
<!-- /wp:paragraph -->
<!-- wp:heading {"textAlign":"right","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"typography":{"fontStyle":"normal","fontWeight":"300"}},"textColor":"white","fontSize":"x-large"} -->
<h2 class="wp-block-heading has-text-align-right has-white-color has-text-color has-link-color has-x-large-font-size" style="font-style:normal;font-weight:300">A monochrome color design can&nbsp;work well with an elegant and minimalist&nbsp;style</h2>
<!-- /wp:heading -->
<!-- wp:spacer {"height":"var:preset|spacing|40","style":{"layout":[]}} -->
<div style="height:var(--wp--preset--spacing--40)" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->
<!-- wp:group {"layout":{"type":"default"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"align":"right","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white","fontSize":"medium"} -->
<p class="has-text-align-right has-white-color has-text-color has-link-color has-medium-font-size"><em>Use lots of white space and thin fonts. A strong grid, sparse layout and restrained use of color. These are the foundations of minimalist style!</em></p>
<!-- /wp:paragraph -->
<!-- wp:image {"lightbox":{"enabled":false},"sizeSlug":"large","linkDestination":"none","className":"is-style-default"} -->
<figure class="wp-block-image size-large is-style-default"><img src="https://live.staticflickr.com/5787/23053831356_1f7644fbe2_b.jpg" alt=""/></figure>
<!-- /wp:image --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->'
	) );

	/*Pricing*/
	register_block_pattern( 'monowp/pricing', array(
		'title'      => __( 'Pricing', 'monowp' ),
		'categories' => array( 'call-to-action', 'services' ),
		'description'=> 'Pricing section with a title, a paragraph and three pricing levels.',
		'source'     => 'theme',
		'content'    => '<!-- wp:group {"metadata":{"categories":["call-to-action","services"],"patternName":"monowp/pricing","name":"Pricing"},"align":"full","style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50","left":"var:preset|spacing|50","right":"var:preset|spacing|50"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)"><!-- wp:group {"align":"wide","style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50","left":"var:preset|spacing|40","right":"var:preset|spacing|40"}},"border":{"radius":"16px"}},"backgroundColor":"base-2","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide has-base-2-background-color has-background" style="border-radius:16px;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--40)"><!-- wp:columns {"verticalAlignment":"center","align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|50"}}}} -->
<div class="wp-block-columns alignwide are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","style":{"spacing":{"padding":{"right":"var:preset|spacing|30","left":"var:preset|spacing|30","top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}},"border":{"top":{"color":"var:preset|color|contrast-3","width":"0px","style":"none"},"right":{"style":"none","width":"0px"},"bottom":{"style":"none","width":"0px"},"left":{"style":"none","width":"0px"}},"shadow":"var:preset|shadow|mono"}} -->
<div class="wp-block-column is-vertically-aligned-center" style="border-top-color:var(--wp--preset--color--contrast-3);border-top-style:none;border-top-width:0px;border-right-style:none;border-right-width:0px;border-bottom-style:none;border-bottom-width:0px;border-left-style:none;border-left-width:0px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30);box-shadow:var(--wp--preset--shadow--mono)"><!-- wp:heading {"textAlign":"center","level":4,"style":{"spacing":{"padding":{"top":"1px"}}},"fontSize":"medium"} -->
<h4 class="wp-block-heading has-text-align-center has-medium-font-size" style="padding-top:1px"><em>Monochrome</em></h4>
<!-- /wp:heading -->
<!-- wp:heading {"textAlign":"center","level":5,"fontSize":"x-large"} -->
<h5 class="wp-block-heading has-text-align-center has-x-large-font-size">$0</h5>
<!-- /wp:heading -->
<!-- wp:spacer {"height":"var:preset|spacing|10"} -->
<div style="height:var(--wp--preset--spacing--10)" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->
<!-- wp:group {"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center">Monochrome color design</p>
<!-- /wp:paragraph -->
<!-- wp:separator {"className":"is-style-wide","backgroundColor":"contrast-3"} -->
<hr class="wp-block-separator has-text-color has-contrast-3-color has-alpha-channel-opacity has-contrast-3-background-color has-background is-style-wide"/>
<!-- /wp:separator -->
<!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast-2"}}}},"textColor":"contrast-2"} -->
<p class="has-text-align-center has-contrast-2-color has-text-color has-link-color"><s>White space and thin font</s></p>
<!-- /wp:paragraph -->
<!-- wp:separator {"className":"is-style-wide","backgroundColor":"contrast-3"} -->
<hr class="wp-block-separator has-text-color has-contrast-3-color has-alpha-channel-opacity has-contrast-3-background-color has-background is-style-wide"/>
<!-- /wp:separator -->
<!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast-2"}}}},"textColor":"contrast-2"} -->
<p class="has-text-align-center has-contrast-2-color has-text-color has-link-color"><s>Middle-shade between the foreground and background</s></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->
<!-- wp:spacer {"height":"var:preset|spacing|10"} -->
<div style="height:var(--wp--preset--spacing--10)" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->
<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons"><!-- wp:button {"width":100,"className":"is-style-outline","style":{"typography":{"textTransform":"uppercase"}}} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-outline" style="text-transform:uppercase"><a class="wp-block-button__link wp-element-button">Subscribe</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:column -->
<!-- wp:column {"verticalAlignment":"center","style":{"spacing":{"padding":{"right":"var:preset|spacing|50","left":"var:preset|spacing|50","top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}},"border":{"top":{"color":"var:preset|color|contrast-3","width":"0px","style":"none"},"right":{"style":"none","width":"0px"},"bottom":{"style":"none","width":"0px"},"left":{"style":"none","width":"0px"}},"shadow":"var:preset|shadow|mono"}} -->
<div class="wp-block-column is-vertically-aligned-center" style="border-top-color:var(--wp--preset--color--contrast-3);border-top-style:none;border-top-width:0px;border-right-style:none;border-right-width:0px;border-bottom-style:none;border-bottom-width:0px;border-left-style:none;border-left-width:0px;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50);box-shadow:var(--wp--preset--shadow--mono)"><!-- wp:heading {"textAlign":"center","level":4,"style":{"spacing":{"padding":{"top":"1px"}}},"fontSize":"medium"} -->
<h4 class="wp-block-heading has-text-align-center has-medium-font-size" style="padding-top:1px"><em>Design</em></h4>
<!-- /wp:heading -->
<!-- wp:heading {"textAlign":"center","level":5,"fontSize":"x-large"} -->
<h5 class="wp-block-heading has-text-align-center has-x-large-font-size">$2</h5>
<!-- /wp:heading -->
<!-- wp:spacer {"height":"var:preset|spacing|10"} -->
<div style="height:var(--wp--preset--spacing--10)" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->
<!-- wp:group {"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center">Monochrome color design</p>
<!-- /wp:paragraph -->
<!-- wp:separator {"className":"is-style-wide","backgroundColor":"contrast-3"} -->
<hr class="wp-block-separator has-text-color has-contrast-3-color has-alpha-channel-opacity has-contrast-3-background-color has-background is-style-wide"/>
<!-- /wp:separator -->
<!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast-2"}}}},"textColor":"contrast-2"} -->
<p class="has-text-align-center has-contrast-2-color has-text-color has-link-color">White space and thin font</p>
<!-- /wp:paragraph -->
<!-- wp:separator {"className":"is-style-wide","backgroundColor":"contrast-3"} -->
<hr class="wp-block-separator has-text-color has-contrast-3-color has-alpha-channel-opacity has-contrast-3-background-color has-background is-style-wide"/>
<!-- /wp:separator -->
<!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast-2"}}}},"textColor":"contrast-2"} -->
<p class="has-text-align-center has-contrast-2-color has-text-color has-link-color">Middle-shade between the foreground and background</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->
<!-- wp:spacer {"height":"var:preset|spacing|10"} -->
<div style="height:var(--wp--preset--spacing--10)" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->
<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons"><!-- wp:button {"width":100,"className":"is-style-fill","style":{"typography":{"textTransform":"uppercase"}}} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-fill" style="text-transform:uppercase"><a class="wp-block-button__link wp-element-button">Subscribe</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:column -->
<!-- wp:column {"verticalAlignment":"center","style":{"spacing":{"padding":{"right":"var:preset|spacing|30","left":"var:preset|spacing|30","top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}},"border":{"top":{"color":"var:preset|color|contrast-3","width":"0px","style":"none"},"right":{"style":"none","width":"0px"},"bottom":{"style":"none","width":"0px"},"left":{"style":"none","width":"0px"}},"shadow":"var:preset|shadow|mono"}} -->
<div class="wp-block-column is-vertically-aligned-center" style="border-top-color:var(--wp--preset--color--contrast-3);border-top-style:none;border-top-width:0px;border-right-style:none;border-right-width:0px;border-bottom-style:none;border-bottom-width:0px;border-left-style:none;border-left-width:0px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30);box-shadow:var(--wp--preset--shadow--mono)"><!-- wp:heading {"textAlign":"center","level":4,"style":{"spacing":{"padding":{"top":"1px"}}},"fontSize":"medium"} -->
<h4 class="wp-block-heading has-text-align-center has-medium-font-size" style="padding-top:1px"><em>Mockup</em></h4>
<!-- /wp:heading -->
<!-- wp:heading {"textAlign":"center","level":5,"fontSize":"x-large"} -->
<h5 class="wp-block-heading has-text-align-center has-x-large-font-size">$1</h5>
<!-- /wp:heading -->
<!-- wp:spacer {"height":"var:preset|spacing|10"} -->
<div style="height:var(--wp--preset--spacing--10)" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->
<!-- wp:group {"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center"> Monochrome color design</p>
<!-- /wp:paragraph -->
<!-- wp:separator {"className":"is-style-wide","backgroundColor":"contrast-3"} -->
<hr class="wp-block-separator has-text-color has-contrast-3-color has-alpha-channel-opacity has-contrast-3-background-color has-background is-style-wide"/>
<!-- /wp:separator -->
<!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast-2"}}}},"textColor":"contrast-2"} -->
<p class="has-text-align-center has-contrast-2-color has-text-color has-link-color">White space and thin font</p>
<!-- /wp:paragraph -->
<!-- wp:separator {"className":"is-style-wide","backgroundColor":"contrast-3"} -->
<hr class="wp-block-separator has-text-color has-contrast-3-color has-alpha-channel-opacity has-contrast-3-background-color has-background is-style-wide"/>
<!-- /wp:separator -->
<!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast-2"}}}},"textColor":"contrast-2"} -->
<p class="has-text-align-center has-contrast-2-color has-text-color has-link-color"><s>Middle-shade between the foreground and background</s></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->
<!-- wp:spacer {"height":"var:preset|spacing|10"} -->
<div style="height:var(--wp--preset--spacing--10)" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->
<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons"><!-- wp:button {"width":100,"className":"is-style-outline","style":{"typography":{"textTransform":"uppercase"}}} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-outline" style="text-transform:uppercase"><a class="wp-block-button__link wp-element-button">Subscribe</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->'
	) );

	/*Testimonial*/
	register_block_pattern( 'monowp/testimonial', array(
		'title'      => __( 'Testimonial', 'monowp' ),
		'categories' => array( 'testimonials', 'text' ),
		'description'=> 'Centered testimonial section with a avatar, name, and job title.',
		'source'     => 'theme',
		'content'    => '<!-- wp:group {"metadata":{"categories":["testimonials","text"],"patternName":"monowp/testimonial","name":"Testimonial"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|60","right":"var:preset|spacing|60"},"margin":{"top":"0","bottom":"0"}}},"backgroundColor":"black","textColor":"white","layout":{"type":"constrained","contentSize":""}} -->
<div class="wp-block-group alignfull has-white-color has-black-background-color has-text-color has-background" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60)"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white","fontSize":"medium"} -->
<p class="has-text-align-center has-white-color has-text-color has-link-color has-medium-font-size">★★★★★</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.2"}},"textColor":"white","fontSize":"x-large","fontFamily":"heading"} -->
<p class="has-text-align-center has-white-color has-text-color has-heading-font-family has-x-large-font-size" style="line-height:1.2"><em>“A monochrome color design can work well with an elegant and minimalist style.”</em></p>
<!-- /wp:paragraph -->
<!-- wp:spacer {"height":"var:preset|spacing|10"} -->
<div style="height:var(--wp--preset--spacing--10)" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->
<!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"center","flexWrap":"nowrap"}} -->
<div class="wp-block-group"><!-- wp:image {"width":"60px","aspectRatio":"1","scale":"cover","sizeSlug":"thumbnail","linkDestination":"none","align":"center","style":{"border":{"radius":"100px"}}} -->
<figure class="wp-block-image aligncenter size-thumbnail is-resized has-custom-border"><img alt="" style="border-radius:100px;aspect-ratio:1;object-fit:cover;width:60px"/></figure>
<!-- /wp:image -->
<!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|10","bottom":"0"}},"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white"} -->
<p class="has-text-align-center has-white-color has-text-color has-link-color" style="margin-top:var(--wp--preset--spacing--10);margin-bottom:0">Monochrome</p>
<!-- /wp:paragraph -->
<!-- wp:paragraph {"align":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"300"},"color":{"text":"#7F7F7F"}},"fontSize":"small"} -->
<p class="has-text-align-center has-text-color has-small-font-size" style="color:#7F7F7F;font-style:normal;font-weight:300">Design Mockup</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->'
	) );

	/*FAQ*/
	register_block_pattern( 'monowp/faq', array(
		'title'      => __( 'FAQ', 'monowp' ),
		'categories' => array( 'text', 'about', 'featured' ),
		'description'=> 'FAQ section with a large FAQ heading and list of toggle questions and answers.',
		'source'     => 'theme',
		'content'    => '<!-- wp:group {"metadata":{"categories":["text","about","featured"],"patternName":"monowp/faq","name":"FAQ"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50","left":"var:preset|spacing|50","right":"var:preset|spacing|50"},"margin":{"top":"0","bottom":"0"}},"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"backgroundColor":"black","textColor":"base","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-base-color has-black-background-color has-text-color has-background has-link-color" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)"><!-- wp:heading {"align":"wide","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"typography":{"fontSize":"10rem","letterSpacing":"-0.02em"}},"textColor":"white"} -->
<h2 class="wp-block-heading alignwide has-white-color has-text-color has-link-color" style="font-size:10rem;letter-spacing:-0.02em">FAQs</h2>
<!-- /wp:heading -->
<!-- wp:group {"align":"wide","layout":{"type":"default"}} -->
<div class="wp-block-group alignwide"><!-- wp:separator {"className":"is-style-wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}}},"backgroundColor":"white"} -->
<hr class="wp-block-separator has-text-color has-white-color has-alpha-channel-opacity has-white-background-color has-background is-style-wide" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30)"/>
<!-- /wp:separator -->
<!-- wp:heading {"level":3,"align":"wide","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white","fontSize":"large"} -->
<h3 class="wp-block-heading alignwide has-white-color has-text-color has-link-color has-large-font-size">A monochrome color design can&nbsp;work well with an elegant and minimalist&nbsp;style?</h3>
<!-- /wp:heading -->
<!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"elements":{"link":{"color":{"text":"#7f7f7f"}}},"color":{"text":"#7f7f7f"}}} -->
<p class="has-text-color has-link-color" style="color:#7f7f7f">Lorem ipsum dolor sit amet, consectetur&nbsp;adipiscing elit. Pellentesque dapibus,&nbsp;neque consectetur imperdiet euismod,&nbsp;purus risus mattis purus, ac laoreet orci&nbsp;quam ac ante. Vivamus tristique laoreet&nbsp;ex, vel dapibus orci malesuada ut. Integer&nbsp;aliquet vestibulum metus vel efficitur.&nbsp;Vestibulum in dolor metus.</p>
<!-- /wp:paragraph -->
<!-- wp:separator {"className":"is-style-wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}}},"backgroundColor":"white"} -->
<hr class="wp-block-separator has-text-color has-white-color has-alpha-channel-opacity has-white-background-color has-background is-style-wide" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30)"/>
<!-- /wp:separator -->
<!-- wp:heading {"level":3,"align":"wide","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white","fontSize":"large"} -->
<h3 class="wp-block-heading alignwide has-white-color has-text-color has-link-color has-large-font-size">Use lots of white space and&nbsp;thin fonts?</h3>
<!-- /wp:heading -->
<!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"elements":{"link":{"color":{"text":"#7f7f7f"}}},"color":{"text":"#7f7f7f"}}} -->
<p class="has-text-color has-link-color" style="color:#7f7f7f">Lorem ipsum dolor sit amet, consectetur&nbsp;adipiscing elit. Pellentesque dapibus,&nbsp;neque consectetur imperdiet euismod,&nbsp;purus risus mattis purus, ac laoreet orci&nbsp;quam ac ante. Vivamus tristique laoreet&nbsp;ex, vel dapibus orci malesuada ut. Integer&nbsp;aliquet vestibulum metus vel efficitur.&nbsp;Vestibulum in dolor metus.</p>
<!-- /wp:paragraph -->
<!-- wp:separator {"className":"is-style-wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}}},"backgroundColor":"white"} -->
<hr class="wp-block-separator has-text-color has-white-color has-alpha-channel-opacity has-white-background-color has-background is-style-wide" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30)"/>
<!-- /wp:separator -->
<!-- wp:heading {"level":3,"align":"wide","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white","fontSize":"large"} -->
<h3 class="wp-block-heading alignwide has-white-color has-text-color has-link-color has-large-font-size">A middle-shade between the&nbsp;foreground and background can&nbsp;help add some variety?</h3>
<!-- /wp:heading -->
<!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"elements":{"link":{"color":{"text":"#7f7f7f"}}},"color":{"text":"#7f7f7f"}}} -->
<p class="has-text-color has-link-color" style="color:#7f7f7f">Lorem ipsum dolor sit amet, consectetur&nbsp;adipiscing elit. Pellentesque dapibus,&nbsp;neque consectetur imperdiet euismod,&nbsp;purus risus mattis purus, ac laoreet orci&nbsp;quam ac ante. Vivamus tristique laoreet&nbsp;ex, vel dapibus orci malesuada ut. Integer&nbsp;aliquet vestibulum metus vel efficitur.&nbsp;Vestibulum in dolor metus.</p>
<!-- /wp:paragraph -->
<!-- wp:separator {"className":"is-style-wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}}},"backgroundColor":"white"} -->
<hr class="wp-block-separator has-text-color has-white-color has-alpha-channel-opacity has-white-background-color has-background is-style-wide" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30)"/>
<!-- /wp:separator -->
<!-- wp:heading {"level":3,"align":"wide","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white","fontSize":"large"} -->
<h3 class="wp-block-heading alignwide has-white-color has-text-color has-link-color has-large-font-size">A strong grid, sparse layout and restrained use of color. These are the foundations of minimalist style?</h3>
<!-- /wp:heading -->
<!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"elements":{"link":{"color":{"text":"#7f7f7f"}}},"color":{"text":"#7f7f7f"}}} -->
<p class="has-text-color has-link-color" style="color:#7f7f7f">Lorem ipsum dolor sit amet, consectetur&nbsp;adipiscing elit. Pellentesque dapibus,&nbsp;neque consectetur imperdiet euismod,&nbsp;purus risus mattis purus, ac laoreet orci&nbsp;quam ac ante. Vivamus tristique laoreet&nbsp;ex, vel dapibus orci malesuada ut. Integer&nbsp;aliquet vestibulum metus vel efficitur.&nbsp;Vestibulum in dolor metus.</p>
<!-- /wp:paragraph -->
<!-- wp:spacer {"height":"var:preset|spacing|10","style":{"spacing":{"margin":{"top":"var:preset|spacing|10","bottom":"0"}}}} -->
<div style="margin-top:var(--wp--preset--spacing--10);margin-bottom:0;height:var(--wp--preset--spacing--10)" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->'
	) );
}
