<?php
add_action( 'init', 'monowp_register_block_styles' );
function monowp_register_block_styles() {

	/*Box Shadow*/
    register_block_style( 'core/media-text', array(
		'name'         => 'bg-shadow',
		'label'        => __( 'Shadowed', 'monowp' ),
		'inline_style' => '.wp-block-media-text.is-style-bg-shadow figure {
			box-shadow: 0 2px 5px 0 var(--wp--preset--color--extra), 0 2px 10px 0 var(--wp--preset--color--extra);
		}'
    ) );

	/*Text Justify*/
	register_block_style( 'core/paragraph', array(
		'name'         => 'justify',
		'label'        => __( 'Justified', 'monowp' ),
		'inline_style' => 'p.is-style-justify {
			text-align: justify;
		}'
    ) );

	/*Text Shadow*/
	register_block_style( 'core/heading', array(
		'name'         => 'txt-shadow',
		'label'        => __( 'Shadowed', 'monowp' ),
		'inline_style' => '.wp-block-heading.is-style-txt-shadow {
			text-shadow: 0 2px 5px var(--wp--preset--color--extra);
		}'
    ) );
	register_block_style( 'core/post-title', array(
		'name'         => 'txt-shadow',
		'label'        => __( 'Shadowed', 'monowp' ),
		'inline_style' => '.wp-block-post-title.is-style-txt-shadow {
			text-shadow: 0 2px 5px var(--wp--preset--color--extra);
		}'
    ) );
	register_block_style( 'core/site-title', array(
		'name'         => 'txt-shadow',
		'label'        => __( 'Shadowed', 'monowp' ),
		'inline_style' => '.wp-block-site-title.is-style-txt-shadow {
			text-shadow: 0 2px 5px var(--wp--preset--color--extra);
		}'
    ) );
	register_block_style( 'core/query-title', array(
		'name'         => 'txt-shadow',
		'label'        => __( 'Shadowed', 'monowp' ),
		'inline_style' => '.wp-block-query-title.is-style-txt-shadow {
			text-shadow: 0 2px 5px var(--wp--preset--color--extra);
		}'
    ) );
	register_block_style( 'core/site-tagline', array(
		'name'         => 'txt-shadow',
		'label'        => __( 'Shadowed', 'monowp' ),
		'inline_style' => '.wp-block-site-tagline.is-style-txt-shadow {
			text-shadow: 0 2px 5px var(--wp--preset--color--extra);
		}'
    ) );
	register_block_style( 'core/quote', array(
		'name'         => 'txt-shadow',
		'label'        => __( 'Shadowed', 'monowp' ),
		'inline_style' => '.wp-block-quote.is-style-txt-shadow p {
			text-shadow: 0 2px 5px var(--wp--preset--color--extra);
		}'
    ) );
	register_block_style( 'core/pullquote', array(
		'name'         => 'txt-shadow',
		'label'        => __( 'Shadowed', 'monowp' ),
		'inline_style' => '.wp-block-pullquote.is-style-txt-shadow p {
			text-shadow: 0 2px 5px var(--wp--preset--color--extra);
		}'
    ) );
	register_block_style( 'core/verse', array(
		'name'         => 'txt-shadow',
		'label'        => __( 'Shadowed', 'monowp' ),
		'inline_style' => '.wp-block-verse.is-style-txt-shadow {
			text-shadow: 0 2px 5px var(--wp--preset--color--extra);
		}'
    ) );

	/*Curved Container*/
	register_block_style( 'core/group', array(
		'name'         => 'curved',
		'label'        => __( 'Curved', 'monowp' ),
		'inline_style' => '.wp-block-group.is-style-curved {
			border-bottom-left-radius: 50% 50%; border-bottom-right-radius: 50% 50%;
		}
		@media screen and (max-width: 768px) {
			.wp-block-group.is-style-curved {
				border-bottom-left-radius: 50% 25%; border-bottom-right-radius: 50% 25%;
			}
		}'
    ) );
	register_block_style( 'core/columns', array(
		'name'         => 'curved',
		'label'        => __( 'Curved', 'monowp' ),
		'inline_style' => '.wp-block-columns.is-style-curved {
			border-bottom-left-radius: 50% 50%; border-bottom-right-radius: 50% 50%;
		}
		@media screen and (max-width: 768px) {
			.wp-block-columns.is-style-curved {
				border-bottom-left-radius: 50% 25%; border-bottom-right-radius: 50% 25%;
			}
		}'
    ) );
	register_block_style( 'core/column', array(
		'name'         => 'curved',
		'label'        => __( 'Curved', 'monowp' ),
		'inline_style' => '.wp-block-column.is-style-curved {
			border-bottom-left-radius: 50% 50%; border-bottom-right-radius: 50% 50%;
		}
		@media screen and (max-width: 768px) {
			.wp-block-column.is-style-curved {
				border-bottom-left-radius: 50% 25%; border-bottom-right-radius: 50% 25%;
			}
		}'
    ) );

	/*Wavy Separator*/
	register_block_style( 'core/separator', array(
		'name'         => 'wavy',
		'label'        => __( 'Waves', 'monowp' ),
		'inline_style' => '.wp-block-separator.is-style-wavy {
			background: none !important;
    		border: none;
			height: auto;
    		text-align: center;
		}
		.wp-block-separator.is-style-wavy:before {
			color: currentColor;
			content: "﹌﹌﹌﹌﹌﹌";
			font-size: 2.5em;
		}'
    ) );

	/*Animated Button*/
	register_block_style( 'core/button', array(
		'name'         => 'animated',
		'label'        => __( 'Animated', 'monowp' ),
		'inline_style' => '.wp-block-button.is-style-animated a:hover {
    		transform: scale(1.1);
		}'
    ) );
}
