<?php
// Get dynamic attachment data.
$caption = wp_get_attachment_caption( $args['post_id'] );
$image   = wp_get_attachment_image_src( $args['post_id'], 'large' );
$alt     = trim( strip_tags( get_post_meta( $args['post_id'], '_wp_attachment_image_alt', true ) ) );
$url = wp_get_attachment_url( $args['post_id'] );
$metadata = wp_get_attachment_metadata( $args['post_id'] );
$width = $metadata['width'];
$height = $metadata['height'];
$filesize = filesize( get_attached_file( $args['post_id'] ));
$filesize_mb = $filesize / (1024 * 1024);
?>

<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull">

	<!-- wp:image {"lightbox":{"enabled":false},"align":"center","id":<?php echo absint( $args['post_id'] ); ?>,"sizeSlug":"large","linkDestination":"none"} -->
	<figure class="wp-block-image aligncenter size-large">
		<img src="<?php echo esc_url( $image[0] ); ?>" alt="<?php echo esc_attr( $alt ); ?>" />

		<?php if ( $caption ) : ?>
			<figcaption class="wp-element-caption"><?php echo esc_html( $caption ); ?></figcaption>
		<?php endif ?>
	</figure>
	<!-- /wp:image -->
	
	<!-- wp:file {"align":"center","id":<?php echo absint( $args['post_id'] ); ?>,"href":"<?php echo esc_url( $url ); ?>"} -->
	<div class="wp-block-file aligncenter">
	<a href="<?php echo esc_url( $url ); ?>" class="wp-block-file__button wp-element-button" download>Download</a><br><br>
	<?php echo esc_html( $width . " x " . $height . " px" ); ?><br>
	<?php echo esc_html( round($filesize_mb, 2) . " MB"); ?>
	</div>
	<!-- /wp:file -->

</div>
<!-- /wp:group -->