<?php
// Get dynamic attachment data.
$caption = wp_get_attachment_caption( $args['post_id'] );
$src     = wp_get_attachment_url( $args['post_id'] );
$url = wp_get_attachment_url( $args['post_id'] );
$metadata = wp_get_attachment_metadata( $args['post_id'] );
$width = $metadata['width'];
$height = $metadata['height'];
$filesize = filesize( get_attached_file( $args['post_id'] ));
$filesize_mb = $filesize / (1024 * 1024);
?>

<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull">

	<!-- wp:video {"align":"center"} -->
	<figure class="wp-block-video aligncenter">
		<video controls muted src="<?php echo esc_url( $src ); ?>"></video>

		<?php if ( $caption ) : ?>
			<figcaption class="wp-element-caption"><?php echo $caption; ?></figcaption>
		<?php endif ?>
	</figure>
	<!-- /wp:video -->

	<!-- wp:file {"align":"center","id":<?php echo absint( $args['post_id'] ); ?>,"href":"<?php echo esc_url( $url ); ?>"} -->
	<div class="wp-block-file aligncenter">
	<a href="<?php echo esc_url( $url ); ?>" class="wp-block-file__button wp-element-button" download>Download</a><br><br>
	<?php echo esc_html( $width . " x " . $height . " px" ); ?><br>
	<?php echo esc_html( round($filesize_mb, 2) . " MB"); ?>
	</div>
	<!-- /wp:file -->

</div>
<!-- /wp:group -->