#!/bin/bash

set -e -o pipefail

wdir=$(dirname $(readlink -sf $0))
backupDirs="cron invaio-visuals.art secure shop.invaio-visuals.art www"
dt=$(date -u +%FT%H%M)
dayPath=${wdir}/../backup/$(date -u +%F)

echo "Backup config:
wdir: ${wdir}
backupDirs: ${backupDirs}
dt: ${dt}
dayPath: ${dayPath}

"

mkdir -vp ${dayPath}
pushd ${wdir}/../
for subPath in ${backupDirs}; do
  {
    echo "Processing subPath: ${subPath}..."
    nice -n 19 tar -czf ${dayPath}/backup_${subPath}_${dt}.tar.gz ${subPath} 
    echo "SubPath done: ${subPath}."    
  } &
done
popd

wait

echo "Cleanup..."
nice -n 19 find ${wdir}/../backup/ -type f -name '*.tar.gz' -mtime 5 -exec rm {} +
nice -n 19 find ${wdir}/../backup/ -depth -type d -empty -delete
echo "Done"
