<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha;

class GoogleAnalyticsAdminV1alphaSubmitUserDeletionResponse extends \Google\Site_Kit_Dependencies\Google\Model
{
    /**
     * Marks the moment for which all visitor data before this point should be
     * deleted. This is set to the time at which the deletion request was
     * received.
     *
     * @var string
     */
    public $deletionRequestTime;
    /**
     * Marks the moment for which all visitor data before this point should be
     * deleted. This is set to the time at which the deletion request was
     * received.
     *
     * @param string $deletionRequestTime
     */
    public function setDeletionRequestTime($deletionRequestTime)
    {
        $this->deletionRequestTime = $deletionRequestTime;
    }
    /**
     * @return string
     */
    public function getDeletionRequestTime()
    {
        return $this->deletionRequestTime;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\GoogleAnalyticsAdminV1alphaSubmitUserDeletionResponse::class, 'Google\\Site_Kit_Dependencies\\Google_Service_GoogleAnalyticsAdminV1alpha_GoogleAnalyticsAdminV1alphaSubmitUserDeletionResponse');
